/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.copyPaste.PhpReplaceUnnecessaryDoubleQuotesPasteProcessor;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpCallbackFunctionUtil;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.inspections.PhpDeprecatedPartiallySupportedCallableInspection;
import com.jetbrains.php.lang.intentions.strings.converters.PhpInterpolationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpReplaceCallableWithFirstClassCallableQuickFix
extends PsiUpdateModCommandQuickFix {
    private final String myName;

    public PhpReplaceCallableWithFirstClassCallableQuickFix(@NotNull String name) {
        if (name == null) {
            PhpReplaceCallableWithFirstClassCallableQuickFix.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = PhpBundle.message("php.replace.with", String.format("%s(...)", this.myName));
        if (string == null) {
            PhpReplaceCallableWithFirstClassCallableQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("replace.with.first.class.callable.family.name", new Object[0]);
        if (string == null) {
            PhpReplaceCallableWithFirstClassCallableQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        FunctionReference call;
        if (project == null) {
            PhpReplaceCallableWithFirstClassCallableQuickFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpReplaceCallableWithFirstClassCallableQuickFix.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            PhpReplaceCallableWithFirstClassCallableQuickFix.$$$reportNull$$$0(5);
        }
        if ((call = (FunctionReference)ObjectUtils.tryCast((Object)element, FunctionReference.class)) != null) {
            PsiElement parameter = call.getParameter(0);
            if (parameter == null) {
                return;
            }
            PhpReplaceCallableWithFirstClassCallableQuickFix.replaceCallableWithFirstClassCallable((PsiElement)call, parameter);
            return;
        }
        PhpReplaceCallableWithFirstClassCallableQuickFix.replaceCallableWithFirstClassCallable(element, element);
    }

    private static void replaceCallableWithFirstClassCallable(@NotNull PsiElement toReplace, @NotNull PsiElement callable) {
        PhpCallableFunction callableFunction;
        if (toReplace == null) {
            PhpReplaceCallableWithFirstClassCallableQuickFix.$$$reportNull$$$0(6);
        }
        if (callable == null) {
            PhpReplaceCallableWithFirstClassCallableQuickFix.$$$reportNull$$$0(7);
        }
        if ((callableFunction = PhpReplaceCallableWithFirstClassCallableQuickFix.createFirstClassCallableFrom(callable)) != null) {
            toReplace.replace((PsiElement)callableFunction);
        }
    }

    @Nullable
    private static PhpCallableFunction createFirstClassCallableFrom(@NotNull PsiElement element) {
        if (element == null) {
            PhpReplaceCallableWithFirstClassCallableQuickFix.$$$reportNull$$$0(8);
        }
        Project project = element.getProject();
        if (element instanceof ArrayCreationExpression) {
            return PhpReplaceCallableWithFirstClassCallableQuickFix.createCallableFromArray(project, (ArrayCreationExpression)element);
        }
        if (element instanceof PhpExpression) {
            return PhpReplaceCallableWithFirstClassCallableQuickFix.createCallableFromStringLiteral(project, (PhpExpression)element);
        }
        return null;
    }

    @NotNull
    private static PhpCallableFunction createCallableFromStringLiteral(Project project, PhpExpression expression) {
        Object callback = PhpCallbackFunctionUtil.getCallbackString((PsiElement)expression);
        if (callback == null) {
            ConcatenationExpression concatenation;
            StringLiteralExpression stringLiteral = (StringLiteralExpression)ObjectUtils.tryCast((Object)expression, StringLiteralExpression.class);
            if (stringLiteral != null) {
                callback = PhpReplaceCallableWithFirstClassCallableQuickFix.replaceDeprecatedClassNames(stringLiteral);
            }
            if ((concatenation = (ConcatenationExpression)ObjectUtils.tryCast((Object)expression, ConcatenationExpression.class)) != null && concatenation.getLeftOperand() instanceof StringLiteralExpression) {
                callback = PhpReplaceCallableWithFirstClassCallableQuickFix.replaceDeprecatedClassNames(concatenation);
            }
        }
        Object object = callback = callback == null ? expression.getText() : callback;
        if (PhpReplaceCallableWithFirstClassCallableQuickFix.isNeedToParenthesize((PsiElement)expression)) {
            callback = "(" + (String)callback + ")";
        }
        String content = String.format("%s(...);", callback);
        PhpCallableFunction phpCallableFunction = PhpPsiElementFactory.createPhpPsiFromText(project, PhpCallableFunction.class, content);
        if (phpCallableFunction == null) {
            PhpReplaceCallableWithFirstClassCallableQuickFix.$$$reportNull$$$0(9);
        }
        return phpCallableFunction;
    }

    private static String replaceDeprecatedClassNames(ConcatenationExpression concatenation) {
        if (PhpLanguageLevel.current((Project)concatenation.getProject()).isLessThan(PhpLanguageLevel.PHP820)) {
            return concatenation.getText();
        }
        ConcatenationExpression copy = (ConcatenationExpression)concatenation.copy();
        StringLiteralExpression stringLiteral = (StringLiteralExpression)ObjectUtils.tryCast((Object)copy.getLeftOperand(), StringLiteralExpression.class);
        if (stringLiteral == null) {
            return concatenation.getText();
        }
        String newContent = PhpReplaceCallableWithFirstClassCallableQuickFix.replaceDeprecatedClassNames(stringLiteral);
        PhpExpression newOperand = PhpPsiElementFactory.createFirstFromText(concatenation.getProject(), PhpExpression.class, newContent);
        if (newOperand == null) {
            return concatenation.getText();
        }
        stringLiteral.replace((PsiElement)newOperand);
        return copy.getText();
    }

    private static String replaceDeprecatedClassNames(StringLiteralExpression expression) {
        StringLiteralExpression stringLiteral;
        if (PhpLanguageLevel.current((Project)expression.getProject()).isLessThan(PhpLanguageLevel.PHP820)) {
            return expression.getText();
        }
        List<PhpStringPartDescriptor> parts = PhpInterpolationStringRepresentationConverter.INSTANCE.getStringParts(expression);
        List elements = ContainerUtil.map(parts, p -> p.getElement());
        StringLiteralExpression stringLiteralExpression = stringLiteral = elements.isEmpty() ? expression : (StringLiteralExpression)ObjectUtils.tryCast(elements.get(0), StringLiteralExpression.class);
        if (stringLiteral == null) {
            return expression.getText();
        }
        String deprecated = PhpDeprecatedPartiallySupportedCallableInspection.getDeprecatedClassName(stringLiteral.getContents());
        if (deprecated == null) {
            return expression.getText();
        }
        String classRefText = deprecated + "::class";
        String quote = expression.isSingleQuote() ? "'" : "\"";
        return classRefText + " . " + quote + expression.getText().substring(deprecated.length() + 1);
    }

    @Nullable
    private static PhpCallableFunction createCallableFromArray(Project project, ArrayCreationExpression array) {
        List elements = ContainerUtil.map((Iterable)ArrayCreationExpressionImpl.children(array).limit(3), PhpPsiElement::getFirstPsiChild);
        if (elements.size() != 2) {
            return null;
        }
        PsiElement firstElement = (PsiElement)elements.get(0);
        PsiElement secondElement = (PsiElement)elements.get(1);
        PhpCallbackReferenceBase.PhpClassMemberCallbackReference callbackReference = new PhpCallbackReferenceBase.PhpClassMemberCallbackReference(firstElement, secondElement, true);
        Object classRef = PhpReplaceCallableWithFirstClassCallableQuickFix.getClassRefText(callbackReference);
        if (PhpReplaceCallableWithFirstClassCallableQuickFix.isNeedToParenthesize(firstElement)) {
            classRef = "(" + (String)classRef + ")";
        }
        String operator = callbackReference.isStaticRef() ? "::" : "->";
        Object classMember = PhpReplaceCallableWithFirstClassCallableQuickFix.getClassMemberText(callbackReference);
        if (PhpReplaceCallableWithFirstClassCallableQuickFix.isNeedToWrapWithCurlyBraces(secondElement)) {
            classMember = "{" + (String)classMember + "}";
        }
        String content = (String)classRef + operator + (String)classMember + "(...);";
        return PhpPsiElementFactory.createPhpPsiFromText(project, PhpCallableFunction.class, content);
    }

    public static boolean isNeedToWrapWithCurlyBraces(PsiElement element) {
        StringLiteralExpression stringLiteral = (StringLiteralExpression)ObjectUtils.tryCast((Object)element, StringLiteralExpression.class);
        return stringLiteral != null && PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.isInterpolatedString(stringLiteral) || PhpReplaceCallableWithFirstClassCallableQuickFix.isNeedToParenthesize(element);
    }

    @Nullable
    private static String getClassMemberText(PhpCallbackReferenceBase.PhpClassMemberCallbackReference callbackReference) {
        String classMemberName = callbackReference.getClassMemberName();
        if (classMemberName != null) {
            return classMemberName;
        }
        return callbackReference.getElement().getText();
    }

    private static String getClassRefText(PhpCallbackReferenceBase.PhpClassMemberCallbackReference callbackReference) {
        PhpExpression classReference;
        Iterator<PhpClass> phpClasses;
        PsiElement ref = callbackReference.getClassRef();
        StringLiteralExpression stringRef = (StringLiteralExpression)ObjectUtils.tryCast((Object)ref, StringLiteralExpression.class);
        if (stringRef != null && PhpReplaceCallableWithFirstClassCallableQuickFix.isSpecialClassName(stringRef)) {
            return ((StringLiteralExpression)ref).getContents();
        }
        if (callbackReference.isStaticRef() && (phpClasses = callbackReference.resolveClassReference().iterator()).hasNext()) {
            return phpClasses.next().getFQN();
        }
        if (stringRef != null) {
            return ((StringLiteralExpression)ref).getContents();
        }
        if (ref instanceof ClassConstantReference && (classReference = ((ClassConstantReference)ref).getClassReference()) != null) {
            return classReference.getText();
        }
        return ref.getText();
    }

    private static boolean isSpecialClassName(@NotNull StringLiteralExpression classRef) {
        String className;
        if (classRef == null) {
            PhpReplaceCallableWithFirstClassCallableQuickFix.$$$reportNull$$$0(10);
        }
        return "parent".equalsIgnoreCase(className = classRef.getContents()) || "self".equalsIgnoreCase(className) || "static".equalsIgnoreCase(className);
    }

    public static boolean isNeedToParenthesize(PsiElement firstElement) {
        if (firstElement instanceof Variable || firstElement instanceof ParenthesizedExpression) {
            return false;
        }
        if (firstElement instanceof StringLiteralExpression) {
            return firstElement.getChildren().length > 0;
        }
        if (firstElement instanceof FunctionReference || firstElement instanceof MemberReference) {
            return false;
        }
        return firstElement instanceof PhpExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpReplaceCallableWithFirstClassCallableQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpReplaceCallableWithFirstClassCallableQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallableFromStringLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceCallableWithFirstClassCallable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFirstClassCallableFrom";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialClassName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 9 -> new IllegalStateException(string);
        };
    }
}

