/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.util;

import com.google.common.base.Predicates;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ArchivedCompilationContextUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.inspections.reference.PhpReferenceScopeExtension;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpRefScopeUtil {
    @NotNull
    public static GlobalSearchScope getReferencesSearchScopeOutOf(@NotNull AnalysisScope analysisScopeToFilter) {
        if (analysisScopeToFilter == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(0);
        }
        SearchScope searchScopeToFilter = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)analysisScopeToFilter).toSearchScope());
        Project project = analysisScopeToFilter.getProject();
        GlobalSearchScope globalScopeToFilter = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)searchScopeToFilter, (Project)project).intersectWith(GlobalSearchScope.projectScope((Project)project));
        GlobalSearchScope referencesSearchScope = PhpRefScopeUtil.getReferencesSearchScope(GlobalSearchScope.notScope((GlobalSearchScope)globalScopeToFilter));
        Collection<VirtualFile> files = PhpRefScopeUtil.getFilesFromTheScope(project, referencesSearchScope);
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)ReadAction.compute(() -> GlobalSearchScope.filesScope((Project)project, (Collection)files));
        if (globalSearchScope == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    public static Collection<VirtualFile> getFilesFromTheScope(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(3);
        }
        CommonProcessors.CollectUniquesProcessor processor2 = new CommonProcessors.CollectUniquesProcessor();
        ProjectFileIndex.getInstance((Project)project).iterateContent(arg_0 -> ((CommonProcessors.CollectUniquesProcessor)processor2).process(arg_0), file -> (Boolean)ReadAction.compute(() -> searchScope.accept(file)));
        Collection collection = processor2.getResults();
        if (collection == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public static GlobalSearchScope getReferencesSearchScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(5);
        }
        return PhpRefScopeUtil.filterBuiltInLibraries(PhpRefScopeUtil.restrictByRefFileTypes(scope));
    }

    @NotNull
    private static GlobalSearchScope filterBuiltInLibraries(@NotNull GlobalSearchScope globalSearchScope) {
        if (globalSearchScope == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(6);
        }
        return new DelegatingGlobalSearchScope(globalSearchScope){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.contains(file) && !PhpRefScopeUtil.isByBuiltInLibrary(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/lang/inspections/reference/util/PhpRefScopeUtil$1", "contains"));
            }
        };
    }

    @NotNull
    private static GlobalSearchScope restrictByRefFileTypes(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(7);
        }
        GlobalSearchScope phpFilesScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)scope, (FileType[])new FileType[]{PhpFileType.INSTANCE});
        GlobalSearchScope globalSearchScope = Arrays.stream((PhpReferenceScopeExtension[])PhpReferenceScopeExtension.EP_NAME.getExtensions()).map(e -> e.getFileTypeScope(scope)).reduce(phpFilesScope, (s1, s2) -> s1.union((SearchScope)s2));
        if (globalSearchScope == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    private static boolean hasAnotherRoots(@NotNull Project project, @NotNull String rootPath) {
        if (project == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(9);
        }
        if (rootPath == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(10);
        }
        return StreamEx.of((Object[])ProjectRootManager.getInstance((Project)project).getContentRoots()).map(VirtualFile::getPath).anyMatch((Predicate)Predicates.not(rootPath::equals));
    }

    private static boolean containsAllDirectories(@NotNull Project project, @NotNull AnalysisScope analysisScope) {
        String basePath;
        if (project == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(11);
        }
        if (analysisScope == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(12);
        }
        if ((basePath = project.getBasePath()) == null || PhpRefScopeUtil.hasAnotherRoots(project, basePath)) {
            return false;
        }
        VirtualFile vDirectory = PsiUtilCore.getVirtualFile((PsiElement)analysisScope.getElement());
        return vDirectory != null && basePath.equals(vDirectory.getPath());
    }

    private static boolean containsAllModules(@NotNull Project project, @NotNull AnalysisScope analysisScope) {
        if (project == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(13);
        }
        if (analysisScope == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(14);
        }
        Object[] existingModules = ModuleManager.getInstance((Project)project).getModules();
        return ContainerUtil.all((Object[])existingModules, arg_0 -> ((AnalysisScope)analysisScope).containsModule(arg_0));
    }

    private static boolean containsAllFiles(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(16);
        }
        GlobalSearchScope phpFileFilter = PhpRefScopeUtil.restrictByRefFileTypes(GlobalSearchScope.projectScope((Project)project));
        return ProjectRootManager.getInstance((Project)project).getFileIndex().iterateContent(arg_0 -> ((AnalysisScope)scope).contains(arg_0), (VirtualFileFilter)phpFileFilter);
    }

    public static boolean containsProjectScope(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(18);
        }
        return switch (scope.getScopeType()) {
            case 3, 8, 9 -> PhpRefScopeUtil.containsAllFiles(project, scope);
            case 4, 7 -> PhpRefScopeUtil.containsAllModules(project, scope);
            case 2 -> {
                if (PhpRefScopeUtil.containsAllDirectories(project, scope) || PhpRefScopeUtil.containsAllFiles(project, scope)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> true;
            default -> false;
        };
    }

    public static boolean isByBuiltInLibrary(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PhpRefScopeUtil.$$$reportNull$$$0(19);
        }
        if (FileUtil.isAncestor((String)PathManager.getHomePath(), (String)virtualFile.getPath(), (boolean)true)) {
            return true;
        }
        String relevantJarsRoot = ArchivedCompilationContextUtil.getArchivedCompiledClassesLocation();
        return relevantJarsRoot != null && FileUtil.isAncestor((String)relevantJarsRoot, (String)virtualFile.getPath(), (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScopeToFilter";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/util/PhpRefScopeUtil";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: 
            case 7: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalSearchScope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScope";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/util/PhpRefScopeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesSearchScopeOutOf";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesFromTheScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictByRefFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesSearchScopeOutOf";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFilesFromTheScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesSearchScope";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterBuiltInLibraries";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restrictByRefFileTypes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasAnotherRoots";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsAllDirectories";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsAllModules";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "containsAllFiles";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "containsProjectScope";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isByBuiltInLibrary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 8 -> new IllegalStateException(string);
        };
    }
}

