/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.type.PhpBooleanConstantValueDfaAnalyzer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFlatCollectionIndexBase;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionsAlwaysReturningBooleanValuesIndex;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantHandler;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExpressionAlwaysConstantEvaluator {
    private static boolean resolveToFunctionThatAlwaysReturnBoolean(FunctionReference value) {
        Collection resolvedElements = (Collection)StreamEx.of((Object[])value.multiResolve(false)).map(ResolveResult::getElement).select(Function.class).collect(Collectors.toSet());
        if (resolvedElements.isEmpty()) {
            return false;
        }
        if (ContainerUtil.all((Collection)resolvedElements, f -> ConstantValue.isBoolean(f.getDeclaredType()))) {
            return true;
        }
        Project project = value.getProject();
        Collection alwaysBooleanFQNs = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create(PhpExpressionAlwaysConstantEvaluator.getAlwaysBooleanFQNs(project), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        return ContainerUtil.all((Collection)resolvedElements, function -> alwaysBooleanFQNs.contains(function.getFQN()));
    }

    @NotNull
    private static Collection<String> getAlwaysBooleanFQNs(@NotNull Project project) {
        if (project == null) {
            PhpExpressionAlwaysConstantEvaluator.$$$reportNull$$$0(0);
        }
        HashSet<String> alwaysBooleanFQNs = new HashSet<String>();
        PhpFlatCollectionIndexBase.processValues(PhpFunctionsAlwaysReturningBooleanValuesIndex.KEY, (file, v) -> {
            alwaysBooleanFQNs.addAll((Collection<String>)v);
            return true;
        }, GlobalSearchScope.allScope((Project)project));
        HashSet<String> hashSet = alwaysBooleanFQNs;
        if (hashSet == null) {
            PhpExpressionAlwaysConstantEvaluator.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public static ConstantValue getConstantValue(PhpAccessVariableInstruction instruction) {
        IntOpenHashSet writeVariableInstructions = new IntOpenHashSet();
        ArrayList<ConstantValue> assignedConstantValues = new ArrayList<ConstantValue>();
        ConstantValue uniqueAssignedConstantValue = PhpExpressionAlwaysConstantEvaluator.getUniqueAssignedConstantValue(instruction, (IntSet)writeVariableInstructions, assignedConstantValues);
        if (uniqueAssignedConstantValue == ConstantValue.UNKNOWN) {
            ConstantValue constantValue = ConstantValue.UNKNOWN;
            if (constantValue == null) {
                PhpExpressionAlwaysConstantEvaluator.$$$reportNull$$$0(2);
            }
            return constantValue;
        }
        if (uniqueAssignedConstantValue != null && uniqueAssignedConstantValue != ConstantValue.UNKNOWN_BOOLEAN_VALUE && assignedConstantValues.size() > 1) {
            ConstantValue constantValue = uniqueAssignedConstantValue;
            if (constantValue == null) {
                PhpExpressionAlwaysConstantEvaluator.$$$reportNull$$$0(3);
            }
            return constantValue;
        }
        ConstantValue constantValue = ConstantValue.fromValue(PhpExpressionAlwaysConstantEvaluator.computeConstantState(instruction, instruction.getVariableName(), (IntSet)writeVariableInstructions));
        if (constantValue == null) {
            PhpExpressionAlwaysConstantEvaluator.$$$reportNull$$$0(4);
        }
        return constantValue;
    }

    @Nullable
    public static ConstantValue getUniqueAssignedConstantValue(PhpAccessVariableInstruction instruction, final IntSet writeVariableInstructions, final Collection<ConstantValue> assignedConstantValues) {
        final CharSequence variableName = instruction.getVariableName();
        final Ref ambiguousAssignment = new Ref((Object)Boolean.FALSE);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpPsiElement phpPsiElement;
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName) || access.isRead() || !((phpPsiElement = instruction.getAnchor()) instanceof Variable)) {
                    return true;
                }
                Variable v = (Variable)phpPsiElement;
                writeVariableInstructions.add(instruction.num());
                AssignmentExpression assignment = PhpPsiUtil.getParentOfClass((PsiElement)v, AssignmentExpression.class);
                if (assignment == null || assignment.getVariable() != v || PhpPsiUtil.getParentOfClass((PsiElement)assignment, PhpStaticStatement.class) != null) {
                    ambiguousAssignment.set((Object)Boolean.TRUE);
                } else {
                    ConstantValue value = ConstantValue.fromValue((PsiElement)assignment.getValue(), true);
                    assignedConstantValues.add(value);
                }
                return false;
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                CharSequence baseVariableName = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
                if (PhpLangUtil.equalsVariableNames(baseVariableName, variableName) && instruction.getAccess().isWrite()) {
                    ambiguousAssignment.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                ambiguousAssignment.set((Object)Boolean.TRUE);
                return true;
            }
        });
        if (((Boolean)ambiguousAssignment.get()).booleanValue() || assignedConstantValues.isEmpty() || assignedConstantValues.contains((Object)ConstantValue.UNKNOWN)) {
            return ConstantValue.UNKNOWN;
        }
        if (assignedConstantValues.size() > 1) {
            return ConstantValue.UNKNOWN_BOOLEAN_VALUE;
        }
        return (ConstantValue)((Object)ContainerUtil.getOnlyItem(EnumSet.copyOf(assignedConstantValues)));
    }

    private static PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState computeConstantState(PhpAccessVariableInstruction instruction, final CharSequence variableName, final IntSet writeVariableInstructions) {
        final int initialInstructionNum = instruction.num();
        final EnumSet<PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState> constantStateRef = EnumSet.noneOf(PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.class);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                if (writeVariableInstructions.contains(instruction.num())) {
                    constantStateRef.add(PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS);
                    return false;
                }
                return true;
            }

            public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                if (constantStateRef.contains((Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS) || instruction.num() >= initialInstructionNum) {
                    return false;
                }
                PhpBooleanConstantValueDfaAnalyzer analyzer = new PhpBooleanConstantValueDfaAnalyzer();
                Object map = analyzer.performDFA(instruction.getCondition(), instruction.getResult());
                PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState computedConstantState = (PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState)((Object)map.get(variableName.toString()));
                if (computedConstantState != null) {
                    if (constantStateRef.isEmpty() || constantStateRef.contains((Object)computedConstantState)) {
                        constantStateRef.add(computedConstantState);
                    } else {
                        constantStateRef.add(PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS);
                    }
                    return false;
                }
                return true;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                constantStateRef.add(PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS);
                return true;
            }
        });
        return (PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState)((Object)ContainerUtil.getOnlyItem(constantStateRef, (Object)((Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlwaysBooleanFQNs";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAlwaysBooleanFQNs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static enum ConstantValue {
        TRUE{

            @Override
            public PsiElement createPsi(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PhpPsiElementFactory.createConstantReference(project, "true");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantEvaluator$ConstantValue$1", "createPsi"));
            }
        }
        ,
        FALSE{

            @Override
            public PsiElement createPsi(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                return PhpPsiElementFactory.createConstantReference(project, "false");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantEvaluator$ConstantValue$2", "createPsi"));
            }
        }
        ,
        UNKNOWN,
        UNKNOWN_BOOLEAN_VALUE;

        private static final TokenSet BOOLEAN_TOKENS;

        public PsiElement createPsi(@NotNull Project project) {
            if (project == null) {
                ConstantValue.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException();
        }

        public static @NotNull ConstantValue fromValue(@Nullable PsiElement value, boolean resolve2) {
            if ((value = PhpPsiUtil.unparenthesize(value)) instanceof PhpIsset || value instanceof PhpEmpty) {
                ConstantValue constantValue = UNKNOWN_BOOLEAN_VALUE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(1);
                }
                return constantValue;
            }
            if (PhpLangUtil.isTrue(value)) {
                ConstantValue constantValue = TRUE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(2);
                }
                return constantValue;
            }
            if (PhpLangUtil.isFalse(value)) {
                ConstantValue constantValue = FALSE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(3);
                }
                return constantValue;
            }
            if (value instanceof UnaryExpression && PhpPsiUtil.isOfType(value, PhpElementTypes.INFIX_EXPRESSION) && PhpPsiUtil.isOfType(((UnaryExpression)value).getOperation(), PhpTokenTypes.opNOT) || value instanceof UnaryExpression && PhpPsiUtil.isOfType(value, PhpElementTypes.CAST_EXPRESSION) && PhpPsiUtil.isOfType(((UnaryExpression)value).getOperation(), PhpTokenTypes.opBOOLEAN_CAST) || value instanceof BinaryExpression && BOOLEAN_TOKENS.contains(((BinaryExpression)value).getOperationType())) {
                ConstantValue constantValue = UNKNOWN_BOOLEAN_VALUE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(4);
                }
                return constantValue;
            }
            if (value instanceof TernaryExpression) {
                ConstantValue falseVariantConstantValue;
                ConstantValue trueVariantConstantValue = ConstantValue.fromValue((PsiElement)((TernaryExpression)value).getTrueVariant(), resolve2);
                if (trueVariantConstantValue == (falseVariantConstantValue = ConstantValue.fromValue((PsiElement)((TernaryExpression)value).getFalseVariant(), resolve2))) {
                    ConstantValue constantValue = trueVariantConstantValue;
                    if (constantValue == null) {
                        ConstantValue.$$$reportNull$$$0(5);
                    }
                    return constantValue;
                }
                if (trueVariantConstantValue == UNKNOWN || falseVariantConstantValue == UNKNOWN) {
                    ConstantValue constantValue = UNKNOWN;
                    if (constantValue == null) {
                        ConstantValue.$$$reportNull$$$0(6);
                    }
                    return constantValue;
                }
                ConstantValue constantValue = UNKNOWN_BOOLEAN_VALUE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(7);
                }
                return constantValue;
            }
            if (resolve2 && value instanceof FunctionReference && !(value instanceof MethodReference) && PhpExpressionAlwaysConstantEvaluator.resolveToFunctionThatAlwaysReturnBoolean((FunctionReference)value)) {
                ConstantValue constantValue = UNKNOWN_BOOLEAN_VALUE;
                if (constantValue == null) {
                    ConstantValue.$$$reportNull$$$0(8);
                }
                return constantValue;
            }
            ConstantValue constantValue = UNKNOWN;
            if (constantValue == null) {
                ConstantValue.$$$reportNull$$$0(9);
            }
            return constantValue;
        }

        protected static boolean isBoolean(PhpType type) {
            return !type.isEmpty() && type.filterOut(t -> "\\false".equals(t) || "\\bool".equals(t)).isEmpty();
        }

        public String getPresentableName() {
            return StringUtil.toLowerCase((String)this.name());
        }

        public static ConstantValue fromValue(@Nullable PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState state) {
            if (state == PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.TRUE) {
                return TRUE;
            }
            if (state == PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.FALSE) {
                return FALSE;
            }
            return UNKNOWN;
        }

        static {
            BOOLEAN_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.andNot((TokenSet)PhpTokenTypes.tsCOMPARE_OPS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opSPACESHIP})), PhpTokenTypes.tsLOGICAL_OPS});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantEvaluator$ConstantValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantEvaluator$ConstantValue";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPsi";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    public static final class PhpIntroduceConstantQuickFix
    implements LocalQuickFix,
    LowPriorityAction {
        private final ConstantValue myValue;

        public PhpIntroduceConstantQuickFix(ConstantValue value) {
            this.myValue = value;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("introduce.named.constant.for.value.0", this.myValue.getPresentableName());
            if (string == null) {
                PhpIntroduceConstantQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpIntroduceConstantQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpIntroduceConstantQuickFix.$$$reportNull$$$0(2);
            }
            Editor editor = PsiEditorUtil.findEditor((PsiElement)descriptor.getStartElement());
            PhpIntroduceConstantHandler handler = this.getIntroduceConstantHandler(project);
            try {
                handler.invoke(handler.getIntroduceContext(editor, descriptor.getStartElement()));
            }
            catch (PhpIntroduceBaseHandler.RefactoringErrorException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)handler.getRefactoringName(), null);
            }
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                PhpIntroduceConstantQuickFix.$$$reportNull$$$0(3);
            }
            if (previewDescriptor == null) {
                PhpIntroduceConstantQuickFix.$$$reportNull$$$0(4);
            }
            Editor editor = PsiEditorUtil.findEditor((PsiElement)previewDescriptor.getStartElement());
            PhpIntroduceConstantHandler handler = this.getIntroduceConstantHandler(project);
            try {
                PhpIntroduceContext context = handler.getIntroduceContext(editor, previewDescriptor.getStartElement());
                handler.doRefactoring(context, handler.getInplaceIntroduceSettings(context, (OccurrencesChooser.BaseReplaceChoice)OccurrencesChooser.ReplaceChoice.ALL));
            }
            catch (PhpIntroduceBaseHandler.RefactoringErrorException refactoringErrorException) {
                // empty catch block
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                PhpIntroduceConstantQuickFix.$$$reportNull$$$0(5);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        private PhpIntroduceConstantHandler getIntroduceConstantHandler(final @NotNull Project project) {
            if (project == null) {
                PhpIntroduceConstantQuickFix.$$$reportNull$$$0(6);
            }
            return new PhpIntroduceConstantHandler(){

                @Override
                protected boolean isSupportedScope(@Nullable PsiElement scope, @NotNull PsiElement expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return true;
                }

                @Override
                protected PsiElement getConstantValue(@NotNull PhpIntroduceContext introduceContext) {
                    if (introduceContext == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return myValue.createPsi(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "introduceContext";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantEvaluator$PhpIntroduceConstantQuickFix$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSupportedScope";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getConstantValue";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantEvaluator$PhpIntroduceConstantQuickFix";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysConstantEvaluator$PhpIntroduceConstantQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getIntroduceConstantHandler";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

