/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInconsistentReturnPointsInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchGetHookReturnType;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeReturnTypeQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpExtendReturnTypeQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIncompatibleReturnTypeInspection
extends PhpInspection {
    public boolean STRICT_TYPE_CHECKING = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpIncompatibleReturnTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpReturn(PhpReturn returnStatement) {
                Condition stopAt = Conditions.or((Condition)PhpClass.INSTANCEOF, (Condition)PhpNamespace.INSTANCEOF);
                Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)returnStatement, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)stopAt);
                if (function == null) {
                    return;
                }
                if (PhpIncompatibleReturnTypeInspection.isVoidDeclaredType(function) && returnStatement.getArgument() != null) {
                    return;
                }
                this.checkReturnTypeCompatibility(function, returnStatement.getArgument(), (PsiElement)returnStatement);
            }

            public void visitPhpFunction(Function function) {
                if (function.isClosure() && FunctionImpl.isShortArrowFunction(function)) {
                    this.visitShortFunction(function);
                }
            }

            public void visitPhpMethod(Method method) {
                PhpPropertyHook hook;
                if (method instanceof PhpPropertyHook && (hook = (PhpPropertyHook)method).isShort() && hook.getHookType() == PhpPropertyHook.PhpPropertyHookType.GET) {
                    this.visitShortFunction((Function)hook);
                }
            }

            private void visitShortFunction(Function function) {
                PsiElement returnArgument = FunctionImpl.getShortArrowFunctionArgument(function);
                if (returnArgument == null) {
                    return;
                }
                this.checkReturnTypeCompatibility(function, returnArgument, returnArgument);
            }

            private void checkReturnTypeCompatibility(Function function, @Nullable PsiElement returnArgument, @NotNull PsiElement elementToHighlight) {
                if (elementToHighlight == null) {
                    1.$$$reportNull$$$0(0);
                }
                Project project = function.getProject();
                PhpType typeFromDeclaration = function.getDeclaredType();
                PhpType declaredType = new PhpType().add(typeFromDeclaration).add(function.getDocType()).globalLocationAware((PsiElement)function);
                List<PsiElement> arguments = PhpIncompatibleReturnTypeInspection.collectArgumentsContributingToReturnType(returnArgument);
                for (PsiElement argument : arguments) {
                    Object inferredType;
                    if (argument instanceof PhpTypedElement) {
                        inferredType = ((PhpTypedElement)argument).getGlobalType();
                        if (!PhpIncompatibleReturnTypeInspection.this.STRICT_TYPE_CHECKING) {
                            inferredType = inferredType.filterNull();
                        }
                    } else {
                        inferredType = argument == null ? PhpType.VOID : null;
                    }
                    if (inferredType == null || inferredType.hasUnknown() || this.canAccept(project, declaredType, (PhpType)inferredType) || 1.isGenerator(function, declaredType)) continue;
                    String ns = function.getNamespaceName();
                    ProblemHighlightType highlightType = argument == null && !typeFromDeclaration.isEmpty() ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    holder.registerProblem(arguments.size() == 1 || argument == null ? elementToHighlight : argument, isOnTheFly ? PhpBundle.message("inspection.incompatible.return.type", declaredType.toStringRelativized(ns), inferredType.toStringRelativized(ns)) : PhpBundle.message("inspection.incompatible.return.type.batch", new Object[0]), highlightType, 1.getQuickFixes(function, declaredType, inferredType, elementToHighlight));
                }
            }

            private boolean canAccept(@NotNull Project project, @NotNull PhpType declaredType, @NotNull PhpType inferredType) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (declaredType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (inferredType == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (PhpIncompatibleReturnTypeInspection.this.STRICT_TYPE_CHECKING && PhpType.intersects((PhpType)declaredType, (PhpType)PhpType.SCALAR)) {
                    if (PhpStrictTypeCheckingInspection.allScalar(declaredType) || PhpStrictTypeCheckingInspection.allScalar(inferredType)) {
                        return PhpStrictTypeCheckingInspection.canAccept(declaredType, inferredType);
                    }
                    return PhpStrictTypeCheckingInspection.canAccept(declaredType, inferredType) || declaredType.filterScalarPrimitives().filterUnknown().isConvertibleFrom(inferredType.filterScalarPrimitives().filterUnknown(), PhpIndex.getInstance((Project)project));
                }
                return declaredType.filterUnknown().isConvertibleFrom(inferredType.filterUnknown(), PhpIndex.getInstance((Project)project));
            }

            private static boolean isGenerator(@NotNull Function function, @NotNull PhpType declaredType) {
                if (function == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (declaredType == null) {
                    1.$$$reportNull$$$0(5);
                }
                return PhpType.intersects((PhpType)PhpInconsistentReturnPointsInspection.GENERATOR_TYPE, (PhpType)declaredType) || PhpInconsistentReturnPointsInspection.isProbablyGenerator(declaredType) && PhpType.intersects((PhpType)PhpInconsistentReturnPointsInspection.GENERATOR_TYPE, (PhpType)function.getInferredType());
            }

            private static LocalQuickFix[] getQuickFixes(@NotNull Function function, @NotNull PhpType declaredType, @NotNull PhpType inferredType, PsiElement elementToHighlight) {
                PhpType typesWithoutNull;
                if (function == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (declaredType == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (inferredType == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (function instanceof PhpPropertyHook) {
                    return new LocalQuickFix[]{new PhpChangeFieldTypeToMatchGetHookReturnType(inferredType)};
                }
                SmartList fixes = new SmartList();
                PhpDocComment phpDoc = function.getDocComment();
                if (phpDoc != null && phpDoc.getReturnTag() != null) {
                    fixes.add(new PhpExtendReturnTypeQuickFix(declaredType, new PhpType().add(declaredType).add(inferredType)));
                }
                if ((typesWithoutNull = inferredType.filterNull()).size() == 1 || typesWithoutNull.size() > 1 && PhpLanguageFeature.UNION_TYPES.isSupported(function.getProject()) || inferredType.equals((Object)PhpType.NULL) && PhpLanguageFeature.STANDALONE_NULL_FALSE.isSupported(function.getProject())) {
                    fixes.add(new PhpChangeReturnTypeQuickFix(function.getProject(), declaredType, inferredType));
                }
                if (elementToHighlight instanceof PhpReturn) {
                    if (PhpType.VOID.equals((Object)declaredType)) {
                        PsiElement returnArgument = ((PhpReturn)elementToHighlight).getArgument();
                        if (returnArgument != null) {
                            fixes.add(LocalQuickFix.from((ModCommandAction)new PhpDeleteElementQuickFix(returnArgument, PhpBundle.message("quickfix.delete.return.argument", new Object[0]))));
                        }
                    } else if (!function.getDeclaredType().isEmpty() && function.getDeclaredType().isNullable()) {
                        fixes.add(LocalQuickFix.from((ModCommandAction)new PhpReplaceWithReturnNullQuickFix((PhpReturn)elementToHighlight)));
                    }
                }
                return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elementToHighlight";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declaredType";
                        break;
                    }
                    case 3: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inferredType";
                        break;
                    }
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpIncompatibleReturnTypeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkReturnTypeCompatibility";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canAccept";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isGenerator";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getQuickFixes";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static List<PsiElement> collectArgumentsContributingToReturnType(PsiElement returnArgument) {
        SmartList arguments = new SmartList();
        LinkedList expressions = ContainerUtil.newLinkedList((Object[])new Pair[]{Pair.create((Object)returnArgument, (Object)true)});
        while (!expressions.isEmpty()) {
            Pair element = (Pair)expressions.pop();
            PsiElement expression = (PsiElement)element.first;
            boolean shouldAddNull = (Boolean)element.second;
            if (expression instanceof ParenthesizedExpression) {
                PhpPsiElement unparenthesized = ((ParenthesizedExpression)expression).extract();
                if (unparenthesized == null) continue;
                expressions.push(Pair.create((Object)unparenthesized, (Object)shouldAddNull));
                continue;
            }
            if (expression instanceof TernaryExpression) {
                expressions.push(Pair.create((Object)((TernaryExpression)expression).getTrueVariant(), (Object)shouldAddNull));
                expressions.push(Pair.create((Object)((TernaryExpression)expression).getFalseVariant(), (Object)shouldAddNull));
                continue;
            }
            if (PhpPsiUtil.isOfType(expression, PhpElementTypes.COALESCE_EXPRESSION)) {
                expressions.push(Pair.create((Object)((BinaryExpression)expression).getLeftOperand(), (Object)false));
                expressions.push(Pair.create((Object)((BinaryExpression)expression).getRightOperand(), (Object)shouldAddNull));
                continue;
            }
            if (!shouldAddNull && PhpCodeInsightUtil.isNull(expression)) continue;
            arguments.add(expression);
        }
        SmartList smartList = arguments;
        if (smartList == null) {
            PhpIncompatibleReturnTypeInspection.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    public static boolean isVoidDeclaredType(@NotNull Function function) {
        PhpPropertyHook hook;
        if (function == null) {
            PhpIncompatibleReturnTypeInspection.$$$reportNull$$$0(2);
        }
        if (!PhpLanguageFeature.RETURN_VOID.isSupported(function.getProject())) {
            return false;
        }
        if (function instanceof PhpPropertyHook && PhpType.VOID.equals((Object)(hook = (PhpPropertyHook)function).getDeclaredType())) {
            return true;
        }
        PhpReturnType returnTypeElement = (PhpReturnType)function.getTypeDeclaration();
        if (returnTypeElement == null) {
            return false;
        }
        return PhpType.VOID.equals((Object)function.getDeclaredType());
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"STRICT_TYPE_CHECKING", (String)PhpBundle.message("inspection.incompatible.return.type.strict.type.checking", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpIncompatibleReturnTypeInspection.$$$reportNull$$$0(3);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpIncompatibleReturnTypeInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpIncompatibleReturnTypeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectArgumentsContributingToReturnType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isVoidDeclaredType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    public static class PhpReplaceWithReturnNullQuickFix
    extends PsiUpdateModCommandAction<PhpReturn> {
        public PhpReplaceWithReturnNullQuickFix(PhpReturn statement) {
            super((PsiElement)statement);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpReturn element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithReturnNullQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpReplaceWithReturnNullQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpReplaceWithReturnNullQuickFix.$$$reportNull$$$0(2);
            }
            element.replace((PsiElement)PhpPsiElementFactory.createReturnStatement(context.project(), "null"));
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", "return null;");
            if (string == null) {
                PhpReplaceWithReturnNullQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpIncompatibleReturnTypeInspection$PhpReplaceWithReturnNullQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpIncompatibleReturnTypeInspection$PhpReplaceWithReturnNullQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

