/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/lang/inspections/type/PhpMissingClassConstantTypeInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "PhpAddClassConstantTypeQuickFix", "intellij.php.impl"})
public final class PhpMissingClassConstantTypeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpField(Field field) {
                boolean hasOverridingConst;
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                if (!field.isConstant() || !field.getDeclaredType().isEmpty()) {
                    return;
                }
                PsiElement psiElement = field.getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
                PsiElement fieldNameIdentifier = psiElement;
                PsiElement defaultValue = field.getDefaultValue();
                if (!(defaultValue instanceof PhpTypedElement) || !PhpCodeValidationUtil.isAllowedAsConstantValue(defaultValue)) {
                    return;
                }
                PhpType phpType = ((PhpTypedElement)defaultValue).getGlobalType();
                Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getGlobalType(...)");
                PhpType defaultValueGlobalType = phpType;
                if (defaultValueGlobalType.hasUnknown()) {
                    return;
                }
                boolean bl = hasOverridingConst = !PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)((PhpClassMember)field), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)PhpClassHierarchyUtils.FALSE_PROCESSOR);
                if (hasOverridingConst) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new PhpAddClassConstantTypeQuickFix(field, defaultValueGlobalType)};
                this.$holder.registerProblem(fieldNameIdentifier, PhpBundle.message("inspection.missing.class.constant.type", new Object[0]), localQuickFixArray);
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP830;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bH\u0016J\u0012\u0010\f\u001a\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/lang/inspections/type/PhpMissingClassConstantTypeInspection$PhpAddClassConstantTypeQuickFix;", "Lcom/jetbrains/php/lang/inspections/quickfix/type/PhpChangeFieldTypeToMatchSuperQuickFix;", "field", "Lcom/jetbrains/php/lang/psi/elements/Field;", "fieldType", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;", "<init>", "(Lcom/jetbrains/php/lang/psi/elements/Field;Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getName", "intellij.php.impl"})
    public static final class PhpAddClassConstantTypeQuickFix
    extends PhpChangeFieldTypeToMatchSuperQuickFix {
        @NotNull
        private final PhpType fieldType;

        public PhpAddClassConstantTypeQuickFix(@NotNull Field field, @NotNull PhpType fieldType) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
            super(field, fieldType);
            this.fieldType = fieldType;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.fieldType};
            String string = PhpBundle.message("quick.fix.missing.class.constant.type", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.fieldType};
            String string = PhpBundle.message("quick.fix.missing.class.constant.type", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

