/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpUndefinedVariableInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpConvertShortArrowFunctionToClosureIntention
extends PsiUpdateModCommandAction<Function> {
    public PhpConvertShortArrowFunctionToClosureIntention() {
        super(Function.class);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull Function function) {
        if (context == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(0);
        }
        if (function == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable((PsiElement)function)) {
            return null;
        }
        if (!PhpLanguageFeature.ARROW_FUNCTION_SYNTAX.isSupported(context.project())) {
            return null;
        }
        if (!function.isClosure() || !FunctionImpl.isShortArrowFunction(function)) {
            return null;
        }
        return Presentation.of((String)this.getFamilyName());
    }

    protected void invoke(@NotNull ActionContext context, @NotNull Function function, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(2);
        }
        if (function == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(4);
        }
        PhpConvertShortArrowFunctionToClosureIntention.convertArrowFunctionToClosure(context.project(), function);
    }

    @Nullable
    public static Function convertArrowFunctionToClosure(@NotNull Project project, Function function) {
        if (project == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(5);
        }
        if (function == null) {
            return null;
        }
        PsiElement kwFN = PhpConvertShortArrowFunctionToClosureIntention.findNode((PsiElement)function, PhpTokenTypes.kwFN);
        if (kwFN == null) {
            return null;
        }
        PhpScopeHolder scope = PhpPsiUtil.getScopeHolder((PsiElement)function);
        Variable[] externalVariables = (Variable[])((StreamEx)((StreamEx)StreamEx.of((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)function, Variable.class)).distinct(PhpNamedElement::getName)).filter(e -> PhpConvertShortArrowFunctionToClosureIntention.shouldBeAddedToUseList(e, scope))).toArray(Variable.class);
        PsiElement opHash = PhpConvertShortArrowFunctionToClosureIntention.findNode((PsiElement)function, PhpTokenTypes.opHASH_ARRAY);
        if (opHash == null) {
            return null;
        }
        PsiElement returnArgument = FunctionImpl.getShortArrowFunctionArgument(function);
        if (returnArgument == null) {
            return null;
        }
        kwFN.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.kwFUNCTION, "function () {}"));
        opHash.delete();
        Statement returnStatement = (Statement)returnArgument.replace((PsiElement)PhpPsiElementFactory.createReturnStatement(project, returnArgument.getText()));
        returnStatement = PhpRefactoringUtil.wrapWithBraces(project, returnStatement);
        if (externalVariables.length > 0) {
            PhpUndefinedVariableInspection.addUseListWithVariables(project, function, externalVariables);
        }
        return PhpPsiUtil.getParentOfClass((PsiElement)returnStatement, Function.class);
    }

    private static boolean shouldBeAddedToUseList(@NotNull Variable e, PhpScopeHolder scope) {
        if (e == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(6);
        }
        return StringUtil.isNotEmpty((String)e.getName()) && PhpAnnotatorVisitor.canBeUsedAsLexicalVariable(e) && !PhpControlFlowBuilder.getParentClosuresParameterNames((PsiElement)e, scope).contains(e.getName());
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("convert.the.arrow.function.to.a.traditional.closure", new Object[0]);
        if (string == null) {
            PhpConvertShortArrowFunctionToClosureIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static PsiElement findNode(PsiElement element, IElementType elementType) {
        ASTNode fnNode = element.getNode().findChildByType(elementType);
        return fnNode != null ? fnNode.getPsi() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpConvertShortArrowFunctionToClosureIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpConvertShortArrowFunctionToClosureIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertArrowFunctionToClosure";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeAddedToUseList";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

