/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.addConstructorParameters;

import com.google.common.base.Predicates;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.actions.PhpNamedElementNode;
import com.jetbrains.php.lang.actions.generation.PhpGenerateFieldAccessorHandlerBase;
import com.jetbrains.php.lang.intentions.addConstructorParameters.PhpAddConstructorParametersChangeSignatureDialog;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddConstructorParametersIntention
extends BaseElementAtCaretIntentionAction {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Field targetField;
        if (project == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(2);
        }
        if ((targetField = PhpAddConstructorParametersIntention.getTargetField(element)) == null || targetField instanceof PhpPromotedFieldParameterImpl) {
            return;
        }
        PhpClass clazz = targetField.getContainingClass();
        if (clazz == null) {
            return;
        }
        Method constructor = clazz.getOwnConstructor();
        if (constructor == null) {
            return;
        }
        Collection<Field> selectedFields = PhpAddConstructorParametersIntention.chooseFields(PhpAddConstructorParametersIntention.getUninitializedFields(clazz), project, targetField);
        if (selectedFields.isEmpty()) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(clazz.getContainingFile())) {
            return;
        }
        Map<Field, PhpParameterInfo> fieldsToParameters = this.createFieldsToParametersMap(selectedFields, constructor);
        if (PhpAddConstructorParametersIntention.hasUsages(constructor)) {
            PhpAddConstructorParametersIntention.invokeChangeSignatureRefactoring(project, constructor, fieldsToParameters);
        } else {
            PhpAddConstructorParametersIntention.addParametersToConstructorDeclaration(project, constructor, fieldsToParameters);
        }
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(5);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        Field field = PhpAddConstructorParametersIntention.getTargetField(element);
        if (field == null) {
            return false;
        }
        PhpClass clazz = field.getContainingClass();
        if (clazz == null || clazz.getOwnConstructor() == null) {
            return false;
        }
        if (PhpAddConstructorParametersIntention.mayBeInitialized(field)) {
            return false;
        }
        return PhpAddConstructorParametersIntention.getUninitializedFields(clazz).contains(field);
    }

    @NotNull
    protected Map<Field, PhpParameterInfo> createFieldsToParametersMap(@NotNull Collection<Field> fields, @NotNull Method constructor) {
        if (fields == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(6);
        }
        if (constructor == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(7);
        }
        ArrayList<String> initializingParametersNames = new ArrayList<String>(ContainerUtil.map(fields, PhpNamedElement::getName));
        PhpNameUtil.unique(initializingParametersNames, ContainerUtil.map2Set((Object[])constructor.getParameters(), Parameter::getName));
        Project project = constructor.getProject();
        LinkedHashMap<Field, PhpParameterInfo> fieldsToParameters = new LinkedHashMap<Field, PhpParameterInfo>();
        for (Pair fieldToParameterName : ContainerUtil.zip(fields, initializingParametersNames)) {
            Field field = (Field)fieldToParameterName.first;
            PhpParameterInfo parameterInfo = new PhpParameterInfo(-1, (String)fieldToParameterName.second);
            PhpType fieldType = field.getType();
            if (PhpLanguageFeature.SCALAR_TYPE_HINTS.isSupported(project) || !PhpType.isScalar((PhpType)fieldType, (Project)project)) {
                PhpType resolvedType = fieldType.global(project);
                parameterInfo.setType(resolvedType, resolvedType.toStringRelativized(constructor.getNamespaceName()));
            }
            fieldsToParameters.put(field, parameterInfo);
        }
        LinkedHashMap<Field, PhpParameterInfo> linkedHashMap = fieldsToParameters;
        if (linkedHashMap == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(8);
        }
        return linkedHashMap;
    }

    private static void invokeChangeSignatureRefactoring(@NotNull Project project, @NotNull Method constructor, @NotNull Map<Field, PhpParameterInfo> fieldsToParameters) {
        if (project == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(9);
        }
        if (constructor == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(10);
        }
        if (fieldsToParameters == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(11);
        }
        PhpMethodDescriptor constructorDescriptor = new PhpMethodDescriptor((Function)constructor);
        List<PhpParameterInfo> parameterInfos = constructorDescriptor.getParameters();
        parameterInfos.addAll(fieldsToParameters.values());
        Runnable generateFieldAssignmentsCallback = () -> PhpAddConstructorParametersIntention.generateFieldAssignments(constructor, fieldsToParameters);
        PhpAddConstructorParametersIntention.addParameterUsingChangeSignature(project, constructorDescriptor, parameterInfos, generateFieldAssignmentsCallback, null);
    }

    public static void addParameterUsingChangeSignature(@NotNull Project project, @NotNull PhpMethodDescriptor constructorDescriptor, @NotNull List<PhpParameterInfo> parameterInfos, @NotNull Runnable generateFieldAssignmentsCallback, @Nullable Variable initialReference) {
        if (project == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(12);
        }
        if (constructorDescriptor == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(13);
        }
        if (parameterInfos == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(14);
        }
        if (generateFieldAssignmentsCallback == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(15);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            PhpAddConstructorParametersChangeSignatureDialog.createPhpChangeSignatureProcessor(project, constructorDescriptor, constructorDescriptor.getVisibility(), parameterInfos, generateFieldAssignmentsCallback).run();
            PhpAddConstructorParametersIntention.handleRenameInitialReference(project, constructorDescriptor, parameterInfos, initialReference);
        } else {
            PhpAddConstructorParametersChangeSignatureDialog changeSignatureDialog = new PhpAddConstructorParametersChangeSignatureDialog(project, constructorDescriptor, generateFieldAssignmentsCallback);
            changeSignatureDialog.setParameterInfos(parameterInfos);
            if (changeSignatureDialog.showAndGet()) {
                PhpAddConstructorParametersIntention.handleRenameInitialReference(project, constructorDescriptor, parameterInfos, initialReference);
            }
        }
    }

    private static void handleRenameInitialReference(@NotNull Project project, @NotNull PhpMethodDescriptor constructorDescriptor, @NotNull List<PhpParameterInfo> parameterInfos, final @Nullable Variable initialReference) {
        if (project == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(16);
        }
        if (constructorDescriptor == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(17);
        }
        if (parameterInfos == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(18);
        }
        if (initialReference != null) {
            parameterInfos.stream().filter(ParameterInfo::isNew).findFirst().ifPresent(info -> {
                if (!info.getName().equals(initialReference.getName())) {
                    final ArrayList variables = new ArrayList();
                    constructorDescriptor.getMethod().accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

                        public void visitPhpVariable(Variable variable) {
                            if (variable.getName().equals(initialReference.getName()) && variable.resolve() == null) {
                                variables.add(variable);
                            }
                            super.visitPhpVariable(variable);
                        }
                    });
                    WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                        for (Variable it : variables) {
                            it.replace((PsiElement)PhpPsiElementFactory.createVariable(project, info.getName(), true));
                        }
                    });
                }
            });
        }
    }

    private static void addParametersToConstructorDeclaration(@NotNull Project project, @NotNull Method method, @NotNull Map<Field, PhpParameterInfo> fieldsToParameters) {
        if (project == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(19);
        }
        if (method == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(20);
        }
        if (fieldsToParameters == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(21);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)PhpAddConstructorParametersIntention.getTitle(), null, () -> {
            Collection<PhpParameterInfo> parameterInfos = fieldsToParameters.values();
            PhpChangeSignatureProcessor.addParameterToFunctionSignature(project, (Function)method, parameterInfos);
            PhpAddConstructorParametersIntention.generateFieldAssignments(method, fieldsToParameters);
        }, (PsiFile[])new PsiFile[0]);
    }

    @NotNull
    private static Collection<Field> chooseFields(@NotNull Collection<Field> uninitializedFields, @NotNull Project project, @NotNull Field toSelect) {
        if (uninitializedFields == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(22);
        }
        if (project == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(23);
        }
        if (toSelect == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(24);
        }
        if (uninitializedFields.size() == 1) {
            Collection<Field> collection = uninitializedFields;
            if (collection == null) {
                PhpAddConstructorParametersIntention.$$$reportNull$$$0(25);
            }
            return collection;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            Collection<Field> collection = uninitializedFields;
            if (collection == null) {
                PhpAddConstructorParametersIntention.$$$reportNull$$$0(26);
            }
            return collection;
        }
        Collection<PhpNamedElementNode> orderedUninitializedFields = PhpGenerateFieldAccessorHandlerBase.fixOrderToBeAsOriginalFiles((PhpNamedElementNode[])ContainerUtil.map2Array(uninitializedFields, PhpNamedElementNode.class, PhpNamedElementNode::new));
        MemberChooser fieldsChooser = new MemberChooser((ClassMember[])orderedUninitializedFields.toArray(new PhpNamedElementNode[0]), false, true, project);
        fieldsChooser.setCopyJavadocVisible(false);
        fieldsChooser.selectElements(new ClassMember[]{new PhpNamedElementNode((PhpNamedElement)toSelect)});
        fieldsChooser.setTitle(PhpBundle.message("intention.add.constructor.parameters.fields.chooser.dialog.title", new Object[0]));
        if (!fieldsChooser.showAndGet()) {
            List<Field> list = Collections.emptyList();
            if (list == null) {
                PhpAddConstructorParametersIntention.$$$reportNull$$$0(27);
            }
            return list;
        }
        List selectedFieldNodes = fieldsChooser.getSelectedElements();
        if (selectedFieldNodes == null) {
            List<Field> list = Collections.emptyList();
            if (list == null) {
                PhpAddConstructorParametersIntention.$$$reportNull$$$0(28);
            }
            return list;
        }
        ArrayList<Field> selectedFields = new ArrayList<Field>();
        for (PhpNamedElementNode fieldNode : selectedFieldNodes) {
            PsiElement psiElement = fieldNode.getPsiElement();
            if (!(psiElement instanceof Field)) continue;
            Field field = (Field)psiElement;
            selectedFields.add(field);
        }
        ArrayList<Field> arrayList = selectedFields;
        if (arrayList == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    private static boolean hasUsages(@NotNull Method constructor) {
        if (constructor == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(30);
        }
        return ReferencesSearch.search((PsiElement)constructor).findFirst() != null;
    }

    private static boolean hasSetters(Field field) {
        return new PhpAccessorsGenerator(field).findSetters().length > 0;
    }

    @NotNull
    private static Collection<Field> getUninitializedFields(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(31);
        }
        Collection<@NotNull Field> fields = PhpAddConstructorParametersIntention.getUninitializedFieldsInConstructor(clazz);
        Collection collection = (Collection)((StreamEx)StreamEx.of(fields).filter((Predicate)Predicates.not(PhpAddConstructorParametersIntention::mayBeInitialized))).collect(Collectors.toCollection(LinkedHashSet::new));
        if (collection == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @NotNull
    public static Collection<Field> getUninitializedFieldsInConstructor(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(33);
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)clazz, () -> new CachedValueProvider.Result(PhpAddConstructorParametersIntention.getUninitializedFieldsInConstructorInternal(clazz), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (collection == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(34);
        }
        return collection;
    }

    @NotNull
    private static Collection<Field> getUninitializedFieldsInConstructorInternal(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(35);
        }
        Method constructor = clazz.getOwnConstructor();
        final HashSet initializedFieldNames = new HashSet();
        if (constructor != null) {
            for (PhpInstruction instruction : constructor.getControlFlow().getInstructions()) {
                instruction.process(new PhpInstructionProcessor(){

                    public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                        FieldReference fieldReference;
                        if (instruction.getAccess().isWrite() && (fieldReference = (FieldReference)ObjectUtils.tryCast((Object)instruction.getAnchor(), FieldReference.class)) != null) {
                            initializedFieldNames.add(fieldReference.getName());
                        }
                        return super.processAccessFieldByVariableInstruction(instruction);
                    }
                });
            }
        }
        Collection collection = (Collection)((StreamEx)((StreamEx)StreamEx.of((Object[])clazz.getOwnFields()).filter(field -> !initializedFieldNames.contains(field.getName()))).filter(field -> !(field instanceof PhpPromotedFieldParameterImpl))).collect(Collectors.toCollection(LinkedHashSet::new));
        if (collection == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(36);
        }
        return collection;
    }

    private static boolean mayBeInitialized(Field field) {
        PhpModifier fieldModifier = field.getModifier();
        return !fieldModifier.isPrivate() || fieldModifier.isStatic() || PhpAddConstructorParametersIntention.isInitializedInplace(field) || PhpAddConstructorParametersIntention.hasSetters(field);
    }

    private static void generateFieldAssignments(@NotNull Method constructor, @NotNull Map<Field, PhpParameterInfo> fieldsToParameters) {
        if (constructor == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(37);
        }
        if (fieldsToParameters == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(38);
        }
        if (fieldsToParameters.isEmpty()) {
            return;
        }
        Object groupStatement = PhpPsiUtil.getChildByCondition((PsiElement)constructor, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (groupStatement == null) {
            return;
        }
        for (Map.Entry<Field, PhpParameterInfo> fieldToParameter : fieldsToParameters.entrySet()) {
            AssignmentExpression assignmentExpression = PhpPsiElementFactory.createPhpPsiFromText(constructor.getProject(), AssignmentExpression.class, "$this->" + fieldToParameter.getKey().getName() + " = $" + fieldToParameter.getValue().getName() + ";");
            PsiElement semicolon = assignmentExpression.getNextSibling();
            if (semicolon == null) {
                return;
            }
            groupStatement.addRangeBefore((PsiElement)assignmentExpression, semicolon, groupStatement.getLastChild());
        }
    }

    private static boolean isInitializedInplace(@NotNull Field field) {
        if (field == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(39);
        }
        return PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(field.getLastChild(), true), PhpTokenTypes.opASGN);
    }

    @Nullable
    private static Field getTargetField(@NotNull PsiElement element) {
        if (element == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(40);
        }
        return (Field)ObjectUtils.tryCast((Object)element.getParent(), Field.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpAddConstructorParametersIntention.getTitle();
        if (string == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PhpAddConstructorParametersIntention.getTitle();
        if (string == null) {
            PhpAddConstructorParametersIntention.$$$reportNull$$$0(42);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nls
    public static String getTitle() {
        return PhpBundle.message("intention.add.constructor.parameters", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 25, 26, 27, 28, 29, 32, 34, 36, 41, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 7: 
            case 10: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 8: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/addConstructorParameters/PhpAddConstructorParametersIntention";
                break;
            }
            case 11: 
            case 21: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldsToParameters";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorDescriptor";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterInfos";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generateFieldAssignmentsCallback";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uninitializedFields";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/addConstructorParameters/PhpAddConstructorParametersIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldsToParametersMap";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseFields";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninitializedFields";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninitializedFieldsInConstructor";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninitializedFieldsInConstructorInternal";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFieldsToParametersMap";
                break;
            }
            case 8: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 41: 
            case 42: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeChangeSignatureRefactoring";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addParameterUsingChangeSignature";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleRenameInitialReference";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addParametersToConstructorDeclaration";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "chooseFields";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasUsages";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getUninitializedFields";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getUninitializedFieldsInConstructor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getUninitializedFieldsInConstructorInternal";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "generateFieldAssignments";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isInitializedInplace";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getTargetField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 25, 26, 27, 28, 29, 32, 34, 36, 41, 42 -> new IllegalStateException(string);
        };
    }
}

