/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.commaSeparated;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.editor.actions.lists.CommaListSplitJoinContext;
import com.intellij.openapi.editor.actions.lists.JoinOrSplit;
import com.intellij.openapi.editor.actions.lists.ListWithElements;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J \u0010\u0011\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002\u00a8\u0006 "}, d2={"Lcom/jetbrains/php/lang/intentions/commaSeparated/PhpSplitJoinContext;", "Lcom/intellij/openapi/editor/actions/lists/CommaListSplitJoinContext;", "<init>", "()V", "extractData", "Lcom/intellij/openapi/editor/actions/lists/ListWithElements;", "context", "Lcom/intellij/psi/PsiElement;", "getSplitText", "", "data", "getJoinText", "isValidIntermediateElement", "", "element", "nextBreak", "prevBreak", "needTailBreak", "lastElement", "mode", "Lcom/intellij/openapi/editor/actions/lists/JoinOrSplit;", "reformatRange", "", "file", "Lcom/intellij/psi/PsiFile;", "rangeToAdjust", "Lcom/intellij/openapi/util/TextRange;", "split", "reformatParameterList", "project", "Lcom/intellij/openapi/project/Project;", "parameterList", "intellij.php.impl"})
public final class PhpSplitJoinContext
extends CommaListSplitJoinContext {
    @Nullable
    public ListWithElements extractData(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object condition = PhpPsiUtil.getParentByCondition(context, (Condition<? super PsiElement>)Conditions.or((Condition)ArrayCreationExpression.INSTANCEOF, (Condition)ParameterList.INSTANCEOF));
        if (condition instanceof ParameterList) {
            PsiElement[] psiElementArray = ((ParameterList)condition).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getParameters(...)");
            return new ListWithElements(condition, ArraysKt.toList((Object[])psiElementArray));
        }
        if (condition instanceof ArrayCreationExpression) {
            ImmutableList immutableList = ArrayCreationExpressionImpl.children((ArrayCreationExpression)condition).toList();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"toList(...)");
            return new ListWithElements(condition, (List)immutableList);
        }
        return null;
    }

    @NotNull
    public String getSplitText(@NotNull ListWithElements data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = PhpBundle.message("intention.split.comma.separated.values", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getJoinText(@NotNull ListWithElements data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = PhpBundle.message("intention.join.comma.separated.values", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isValidIntermediateElement(@NotNull ListWithElements data, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return super.isValidIntermediateElement(data, element) || element instanceof PhpDocPsiElement;
    }

    @Nullable
    public PsiElement nextBreak(@NotNull ListWithElements data, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement nextBreak = super.nextBreak(data, element);
        if (nextBreak != null || !(data.getList() instanceof ParameterList) || !Intrinsics.areEqual((Object)CollectionsKt.last((List)data.getElements()), (Object)element)) {
            return nextBreak;
        }
        return super.nextBreak(data, data.getList());
    }

    @Nullable
    public PsiElement prevBreak(@NotNull ListWithElements data, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement prevBreak = super.prevBreak(data, element);
        if (prevBreak != null || !(data.getList() instanceof ParameterList) || !Intrinsics.areEqual((Object)CollectionsKt.first((List)data.getElements()), (Object)element)) {
            return prevBreak;
        }
        return super.prevBreak(data, data.getList());
    }

    public boolean needTailBreak(@NotNull ListWithElements data, @NotNull PsiElement lastElement, @NotNull JoinOrSplit mode) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)lastElement, (String)"lastElement");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return mode == JoinOrSplit.SPLIT ? this.hasSeparatorAfter(data, lastElement) : super.needTailBreak(data, lastElement, mode);
    }

    public void reformatRange(@NotNull PsiFile file, @NotNull TextRange rangeToAdjust, @NotNull JoinOrSplit split) {
        ParameterList parameterList;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)rangeToAdjust, (String)"rangeToAdjust");
        Intrinsics.checkNotNullParameter((Object)split, (String)"split");
        if (split == JoinOrSplit.SPLIT && (parameterList = (ParameterList)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)rangeToAdjust.getStartOffset(), (int)rangeToAdjust.getEndOffset(), ParameterList.class)) != null) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.reformatParameterList(project, (PsiElement)parameterList);
        }
        super.reformatRange(file, rangeToAdjust, split);
    }

    private final void reformatParameterList(Project project, PsiElement parameterList) {
        PsiElement methodBody;
        PsiElement closingParens;
        PsiElement openParens = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(parameterList, true);
        PsiElement lastElement = closingParens = PhpPsiUtil.getNextSiblingIgnoreWhitespace(parameterList, true);
        if (parameterList.getParent() instanceof Function && (methodBody = PhpPsiUtil.getNextSiblingIgnoreWhitespace(closingParens, true)) instanceof GroupStatement && PhpPsiUtil.isOfType(((GroupStatement)methodBody).getFirstChild(), PhpTokenTypes.chLBRACE)) {
            lastElement = ((GroupStatement)methodBody).getFirstChild();
        }
        if (openParens != null && lastElement != null) {
            CodeStyleManager.getInstance((Project)project).reformatText(parameterList.getContainingFile(), openParens.getTextRange().getStartOffset(), lastElement.getTextRange().getEndOffset());
        }
    }
}

