/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.surround;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.RWAccess;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.util.PhpTrimRendererVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpSurroundWithCallBaseIntention
extends PsiUpdateModCommandAction<PsiElement> {
    private static final Logger LOG = Logger.getInstance(PhpSurroundWithCallBaseIntention.class);

    public PhpSurroundWithCallBaseIntention() {
        super(PsiElement.class);
    }

    @NotNull
    @NlsSafe
    protected abstract String getCalleeName();

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("surround.with.0", this.getCalleeName());
        if (string == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        PsiElement expressionToSurround;
        if (context == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(2);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return null;
        }
        Statement statement = PhpPsiUtil.getParentOfClass(element, false, Statement.class);
        if (!PhpLangUtil.isShortEchoTagStatement((PsiElement)statement) && (expressionToSurround = this.getExpressionToSurround(element)) != null) {
            String text = PhpTrimRendererVisitor.getTrimmedText(expressionToSurround, 15, 5);
            if (expressionToSurround instanceof RWAccess) {
                if (!((RWAccess)expressionToSurround).isWriteAccess()) {
                    return Presentation.of((String)PhpSurroundWithCallBaseIntention.createText(this.getCalleeName(), text));
                }
            } else {
                return Presentation.of((String)PhpSurroundWithCallBaseIntention.createText(this.getCalleeName(), text));
            }
        }
        return null;
    }

    @NotNull
    @Nls
    private static String createText(@NotNull String calleeName, @NotNull String text) {
        if (calleeName == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(3);
        }
        if (text == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(4);
        }
        String string = PhpBundle.message("surround.with.if.0.1", calleeName, text);
        if (string == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    protected PsiElement getExpressionToSurround(@NotNull PsiElement element) {
        Variable variable;
        if (element == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(6);
        }
        if ((variable = PhpSurroundWithCallBaseIntention.findCleanElementAt(element, Variable.class)) != null) {
            PsiElement[] children = variable.getChildren();
            if (PhpSurroundWithCallBaseIntention.isFieldReference(variable, children)) {
                return children[0];
            }
            return variable;
        }
        ArrayAccessExpression arrayExpression = PhpSurroundWithCallBaseIntention.findCleanElementAt(element, ArrayAccessExpression.class);
        if (arrayExpression != null) {
            return arrayExpression;
        }
        FieldReference fieldReference = PhpSurroundWithCallBaseIntention.findCleanElementAt(element, FieldReference.class);
        if (fieldReference != null) {
            return fieldReference;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T findCleanElementAt(@NotNull PsiElement element, @NotNull Class<T> aClass) {
        T parent;
        if (element == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(7);
        }
        if (aClass == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(8);
        }
        if ((parent = PhpPsiUtil.getParentOfClass(element, false, aClass)) != null && !PsiTreeUtil.hasErrorElements(parent)) {
            return parent;
        }
        return null;
    }

    private static boolean isFieldReference(@NotNull Variable variable, PsiElement @NotNull [] children) {
        if (variable == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(9);
        }
        if (children == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(10);
        }
        return variable.getParent() instanceof StringLiteralExpression && children.length == 1 && children[0] instanceof FieldReference;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(11);
        }
        if (element == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(12);
        }
        if (updater == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(13);
        }
        PsiElement expressionToSurround = this.getExpressionToSurround(element);
        assert (expressionToSurround != null);
        String text = "if(" + this.getCalleeName() + "(" + PhpSurroundWithCallBaseIntention.getExpressionText(expressionToSurround) + ")){\necho 1;\n}\n";
        Statement ifStatement = PhpPsiElementFactory.createStatement(context.project(), text);
        Statement outerStatement = PhpPsiUtil.getParentOfClass(expressionToSurround, Statement.class);
        if (outerStatement == null) {
            updater.cancel(PhpBundle.message("intention.can.not.find.statement.to.surround", new Object[0]));
            return;
        }
        PsiElement outerStatementCopy = outerStatement.copy();
        PhpEchoStatement echoStatement = (PhpEchoStatement)PsiTreeUtil.findChildOfType((PsiElement)(ifStatement = outerStatement.replace((PsiElement)ifStatement)), PhpEchoStatement.class);
        if (echoStatement == null) {
            ifStatement.replace(outerStatementCopy);
            updater.cancel(PhpBundle.message("intention.statement.to.surround.failed.message", this.getCalleeName()));
            LOG.error("Can not find place to insert code in if statement: '" + text + "'");
            return;
        }
        echoStatement.replace(outerStatementCopy);
    }

    private static String getExpressionText(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpSurroundWithCallBaseIntention.$$$reportNull$$$0(14);
        }
        if (expression instanceof Variable) {
            return "$" + ((Variable)expression).getName();
        }
        return expression.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/surround/PhpSurroundWithCallBaseIntention";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/surround/PhpSurroundWithCallBaseIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionToSurround";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCleanElementAt";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFieldReference";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

