/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.PhpMemberResolveResult;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpBaseMemberReference
extends PhpReferenceImpl
implements PhpExpression {
    protected static final PhpMemberResolveResult[] EMPTY_RESOLVE_RESULTS = new PhpMemberResolveResult[0];

    protected PhpBaseMemberReference(ASTNode node) {
        super(node);
    }

    public boolean isStatic() {
        return this.findChildByType(PhpTokenTypes.SCOPE_RESOLUTION) != null;
    }

    @Nullable
    public PhpExpression getClassReference() {
        PhpPsiElement firstPsiChild = this.getFirstPsiChild();
        if (firstPsiChild instanceof PhpDefine) {
            firstPsiChild = firstPsiChild.getFirstPsiChild();
        }
        if (firstPsiChild instanceof PhpExpression) {
            return (PhpExpression)firstPsiChild;
        }
        return null;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(Function<PhpExpression, PhpType> classReferenceTypeProvider) {
        List list = ContainerUtil.map(this.resolveGlobalDescriptors(classReferenceTypeProvider), PhpMemberResolveResult::getElement);
        if (list == null) {
            PhpBaseMemberReference.$$$reportNull$$$0(0);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    protected Collection<PhpMemberResolveResult> resolveGlobalDescriptors(Function<PhpExpression, PhpType> classReferenceTypeProvider) {
        HashSet<PhpNamedElement> result = new HashSet<PhpNamedElement>();
        HashSet resultFromSubclasses = new HashSet();
        PhpExpression classReference = this.getClassReference();
        if (classReference != null) {
            Function<PhpExpression, PhpType> fullClassReferenceTypeProvider = this.getFullClassReferenceTypeProvider(classReferenceTypeProvider, classReference);
            if (MemberReferenceImpl.chainIsTooDeep(classReference)) {
                Set<PhpMemberResolveResult> set = Collections.emptySet();
                if (set == null) {
                    PhpBaseMemberReference.$$$reportNull$$$0(1);
                }
                return set;
            }
            Project project = this.getProject();
            result.addAll(MemberReferenceImpl.resolveInHierarchy(this, fullClassReferenceTypeProvider));
            if (!(this.getClassReference() instanceof ConstantReference) && this.resolveInSubclasses(result)) {
                boolean resultsIsEmpty = result.isEmpty();
                @NlsSafe Set fqns = resultsIsEmpty ? fullClassReferenceTypeProvider.apply(classReference).getTypes() : StreamEx.of(result).select(Method.class).map(PhpClassMember::getContainingClass).nonNull().map(PhpNamedElement::getFQN).toSet();
                for (String fqn : fqns) {
                    MemberReferenceImpl.lookInSubclasses(project, this, fqn).forEach(e -> {
                        if (result.add((PhpNamedElement)e)) {
                            resultFromSubclasses.add(e);
                        }
                    });
                }
            }
        }
        List list = ContainerUtil.map(PhpReferenceImpl.extendedResolve2(this, result), e -> new PhpMemberResolveResult((PhpNamedElement)e, resultFromSubclasses.contains(e)));
        if (list == null) {
            PhpBaseMemberReference.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    protected ResolveResult[] multiResolve(PhpReference expression, boolean incompleteCode) {
        if (expression instanceof PhpBaseMemberReference) {
            return (ResolveResult[])((PhpBaseMemberReference)expression).resolveGlobalDescriptors(MemberReferenceImpl.CLASS_REFERENCE_TYPE_PROVIDER).toArray(EMPTY_RESOLVE_RESULTS);
        }
        return super.multiResolve(expression, incompleteCode);
    }

    private Function<PhpExpression, PhpType> getFullClassReferenceTypeProvider(Function<PhpExpression, PhpType> classReferenceTypeProvider, PhpExpression classReference) {
        if (MemberReferenceImpl.mayHaveDynamicClassFQN(this)) {
            return e -> {
                PhpType res = new PhpType();
                ClassReferenceImpl.inferDynamicClassReferenceFQNs((Variable)classReference).forEach(arg_0 -> ((PhpType)res).add(arg_0));
                res.add((PhpType)classReferenceTypeProvider.apply((PhpExpression)e));
                return res;
            };
        }
        return classReferenceTypeProvider;
    }

    @NotNull
    public abstract Set<? extends PhpNamedElement> resolveMember(@NotNull PhpClass var1, boolean var2);

    @NotNull
    public abstract Set<? extends PhpNamedElement> resolveMemberWithGenerics(@NotNull PhpClass var1, boolean var2, @Nullable String var3);

    protected boolean resolveInSubclasses(Set<PhpNamedElement> result) {
        return result.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PhpBaseMemberReference.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PhpClassMember)) return false;
        if (!Arrays.stream(this.multiResolve(false)).filter(ResolveResult::isValidResult).map(ResolveResult::getElement).anyMatch(arg_0 -> ((PsiElement)element).equals(arg_0))) return false;
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpBaseMemberReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobalDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpBaseMemberReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

