/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpMultipleDeclarationFilter;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpASTElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPsiElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpReferenceImpl
extends PhpASTElementImpl
implements PhpReference,
PhpTypedElement,
PhpPsiElement {
    public static final boolean CACHE_PHP_REF_RESOLVE = true;

    protected PhpReferenceImpl(ASTNode node) {
        super(node);
    }

    @Nullable
    public String getName() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null ? nameNode.getText() : null;
    }

    @Nullable
    public CharSequence getNameCS() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null ? nameNode.getChars() : "";
    }

    public PsiReference getReference() {
        if (this.getNameNode() != null) {
            return this;
        }
        return null;
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            int startOffset = nameNode.getPsi().getStartOffsetInParent();
            return new TextRange(startOffset, startOffset + nameNode.getTextLength());
        }
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        ASTNode nameNode;
        if (newElementName == null) {
            PhpReferenceImpl.$$$reportNull$$$0(0);
        }
        if ((nameNode = this.getNameNode()) != null && !this.getName().equals(newElementName)) {
            nameNode.getTreeParent().addLeaf(PhpTokenTypes.IDENTIFIER, (CharSequence)newElementName, nameNode);
            nameNode.getTreeParent().removeChild(nameNode);
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PhpReferenceImpl.$$$reportNull$$$0(1);
        }
        throw new IncorrectOperationException("Method bindToElement is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(PhpTokenTypes.IDENTIFIER);
    }

    @NotNull
    public PsiElement getElement() {
        PhpReferenceImpl phpReferenceImpl = this;
        if (phpReferenceImpl == null) {
            PhpReferenceImpl.$$$reportNull$$$0(2);
        }
        return phpReferenceImpl;
    }

    @NotNull
    public String getCanonicalText() {
        String name = this.getName();
        return name != null ? name : "";
    }

    public boolean isSoft() {
        return false;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length == 1) {
            return results[0].getElement();
        }
        return null;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (!incompleteCode) {
            ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, this.getResolver(), true, false);
            if (resolveResultArray == null) {
                PhpReferenceImpl.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = this.getResolver().resolve((PsiPolyVariantReference)this, true);
        if (resolveResultArray == null) {
            PhpReferenceImpl.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    private ResolveCache.PolyVariantResolver<PhpReference> getResolver() {
        return (expression, incompleteCode) -> {
            Object[] results = this.multiResolve((PhpReference)expression, incompleteCode);
            if (IntentionPreviewUtils.isPreviewElement((PsiElement)this) && ContainerUtil.exists((Object[])results, e -> e.getElement() != null && !IntentionPreviewUtils.isPreviewElement((PsiElement)e.getElement()))) {
                return (ResolveResult[])((StreamEx)StreamEx.of((Object[])results).filter(e -> e.getElement() == null || !IntentionPreviewUtils.isPreviewElement((PsiElement)e.getElement()))).toArray((Object[])ResolveResult.EMPTY_ARRAY);
            }
            return results;
        };
    }

    protected ResolveResult[] multiResolve(PhpReference expression, boolean incompleteCode) {
        Collection globals = expression.resolveGlobal(incompleteCode);
        return PsiElementResolveResult.createResults((Collection)globals);
    }

    public static <T extends PhpNamedElement> Collection<T> extendedResolve2(@NotNull PhpReference reference, Collection<T> candidates) {
        if (reference == null) {
            PhpReferenceImpl.$$$reportNull$$$0(5);
        }
        candidates = Collections.unmodifiableCollection(candidates);
        List extensions = PhpMultipleDeclarationFilter.EP_NAME.getExtensionList();
        for (PhpMultipleDeclarationFilter resolver : extensions) {
            candidates = ContainerUtil.intersection(candidates, (Collection)resolver.filter((PsiElement)reference, candidates));
        }
        return candidates;
    }

    @NotNull
    public String getImmediateNamespaceName() {
        PhpNamespaceReference reference = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)this, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF);
        return reference != null ? reference.getFullName() : "";
    }

    @NotNull
    public String getNamespaceName() {
        return PhpReferenceImpl.findNamespaceName(this.getImmediateNamespaceName(), (PsiElement)this);
    }

    public boolean isAbsolute() {
        String local = this.getImmediateNamespaceName();
        if (StringUtil.startsWithChar((CharSequence)local, (char)'\\')) {
            return true;
        }
        return PhpReferenceImpl.isImport((PsiElement)this);
    }

    public static boolean isImport(@NotNull PsiElement reference) {
        PsiElement use;
        if (reference == null) {
            PhpReferenceImpl.$$$reportNull$$$0(6);
        }
        if (!((use = reference.getParent()) instanceof PhpUse)) {
            return false;
        }
        PsiElement list = use.getParent();
        if (!(list instanceof PhpUseList)) {
            list = list.getParent();
        }
        return list instanceof PhpUseList && !((PhpUseList)list).isTraitImport();
    }

    @NotNull
    public static String findNamespaceName(@NotNull String local, @NotNull PsiElement e) {
        PhpNamespaceReference nsr;
        if (local == null) {
            PhpReferenceImpl.$$$reportNull$$$0(7);
        }
        if (e == null) {
            PhpReferenceImpl.$$$reportNull$$$0(8);
        }
        if (!StringUtil.startsWithChar((CharSequence)local, (char)'\\') && !PhpReferenceImpl.isImport(e)) {
            String declared;
            PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)e.getContainingFile(), PhpFile.class);
            String string = declared = file != null ? file.getMainNamespaceName() : null;
            if (declared == null) {
                PhpNamespace namespace = PhpPsiUtil.getParentOfClass(e, true, PhpNamespace.class);
                if (namespace != null) {
                    declared = namespace.getFQN();
                    if ("\\".equals(declared)) {
                        declared = "";
                    }
                } else {
                    declared = "";
                }
            }
            local = declared + (declared.endsWith("\\") ? "" : "\\") + (String)local;
        }
        if (e.getParent() instanceof PhpUse && PhpPsiUtil.isOfType(e.getParent().getParent(), PhpElementTypes.USE_BRACES) && (nsr = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition(e.getParent().getParent(), (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF)) != null) {
            local = nsr.getFullName() + (String)local;
        }
        if (!StringUtil.startsWithChar((CharSequence)local, (char)'\\')) {
            local = "\\" + (String)local;
        }
        String string = local;
        if (string == null) {
            PhpReferenceImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public PhpType getType() {
        PhpType phpType = PhpTypeInfo.getType((PsiElement)this);
        if (phpType == null) {
            PhpReferenceImpl.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @Nullable
    public String getFQN() {
        return PhpReferenceImpl.getFqn(this);
    }

    @NotNull
    protected static String getFqn(PhpReference reference) {
        String string = reference.getNamespaceName() + reference.getName();
        if (string == null) {
            PhpReferenceImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    public String toString() {
        return PhpPsiElementImpl.toStringWithValue((PsiElement)this, this.getText());
    }

    public static boolean allowGlobal(PhpReference reference) {
        String namespaceName = reference.getNamespaceName();
        return reference.getImmediateNamespaceName().isEmpty() && (PhpLangUtil.isGlobalNamespaceFQN(namespaceName) || !PhpReferenceImpl.isImport((PsiElement)reference));
    }

    @NotNull
    public abstract Collection<String> getSignatureParts();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpReferenceImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpReferenceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamespaceName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extendedResolve2";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isImport";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

