/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpUseStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUseImpl
extends PhpNamedElementImpl<PhpUseStub>
implements PhpUse {
    public static final Condition<PsiElement> USE_BRACES_CONDITION = element -> PhpPsiUtil.isOfType(element, PhpElementTypes.USE_BRACES);

    public PhpUseImpl(ASTNode node) {
        super(node);
    }

    public PhpUseImpl(PhpUseStub stub) {
        super(stub, (IElementType)PhpStubElementTypes.USE);
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return PhpIcons.ALIAS;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpUseImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpUse((PhpUse)this);
    }

    @Override
    @NotNull
    public String getName() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                PhpUseImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (this.getNameNode() != null) {
            String string = super.getName();
            if (string == null) {
                PhpUseImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        PhpReference targetReference = this.getTargetReference();
        return targetReference != null ? StringUtil.notNullize((String)targetReference.getName()) : "";
    }

    @Override
    @NotNull
    public CharSequence getNameCS() {
        if (this.getNameNode() != null) {
            CharSequence charSequence = super.getNameCS();
            if (charSequence == null) {
                PhpUseImpl.$$$reportNull$$$0(3);
            }
            return charSequence;
        }
        PhpReference targetReference = this.getTargetReference();
        if (targetReference != null) {
            CharSequence charSequence = targetReference.getNameCS();
            if (charSequence == null) {
                PhpUseImpl.$$$reportNull$$$0(4);
            }
            return charSequence;
        }
        return "";
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            PhpUseImpl.$$$reportNull$$$0(5);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            ASTNode node = PhpPsiElementFactory.createConstantReference(this.getProject(), name).getNameNode();
            assert (node != null);
            nameNode.getTreeParent().replaceChild(nameNode, node);
        }
        return this;
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpReference reference = this.getTargetReference();
        PhpType phpType = this.getTargetReference() != null ? new PhpType().add((reference instanceof FunctionReference ? "#F" : (reference instanceof ConstantReference ? "#D" : "")) + this.getFQN()).createImmutableType() : PhpType.EMPTY;
        if (phpType == null) {
            PhpUseImpl.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    @Override
    @NotNull
    public String getFQN() {
        PhpUseStub stub = (PhpUseStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getFQN();
            if (string == null) {
                PhpUseImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (this.isTraitImport()) {
            String string = super.getFQN();
            if (string == null) {
                PhpUseImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        PhpReference targetReference = this.getTargetReference();
        String fqn = targetReference != null ? targetReference.getFQN() : null;
        return fqn != null ? PhpLangUtil.toFQN(fqn) : "\\";
    }

    @Nullable
    public String getAliasName() {
        PhpUseStub stub = (PhpUseStub)this.getGreenStub();
        if (stub != null) {
            return stub.getAliasName();
        }
        ASTNode node = this.getNameNode();
        if (node != null) {
            return StringUtil.nullize((String)super.getName());
        }
        return null;
    }

    public PhpReference getTargetReference() {
        return (PhpReference)PhpPsiUtil.getChildByCondition((PsiElement)this, (Condition<? super PsiElement>)PhpReference.INSTANCEOF);
    }

    public boolean isTraitImport() {
        PhpUseList useList = PhpUseImpl.getUseList((PsiElement)this);
        if (useList != null) {
            return useList.isTraitImport();
        }
        return false;
    }

    public static boolean resolvesToClass(@NotNull PhpUse use) {
        PhpReference reference;
        if (use == null) {
            PhpUseImpl.$$$reportNull$$$0(9);
        }
        if ((reference = use.getTargetReference()) != null) {
            return reference.resolveGlobal(false).stream().anyMatch(PhpClass.class::isInstance);
        }
        return false;
    }

    public boolean isOfConst() {
        return PhpPsiUtil.getChildOfType((PsiElement)this, PhpTokenTypes.kwCONST) != null;
    }

    public boolean isOfFunction() {
        return PhpPsiUtil.getChildOfType((PsiElement)this, PhpTokenTypes.kwFUNCTION) != null;
    }

    @Nullable
    public static PhpUseList getUseList(@Nullable PsiElement element) {
        return (PhpUseList)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    public static boolean isOfConst(@NotNull PhpUse use) {
        if (use == null) {
            PhpUseImpl.$$$reportNull$$$0(10);
        }
        if (use.isOfConst()) {
            return true;
        }
        PhpUseList useList = PhpUseImpl.getUseList((PsiElement)use);
        return useList != null && useList.isOfConst();
    }

    public static boolean isOfFunction(@NotNull PhpUse use) {
        if (use == null) {
            PhpUseImpl.$$$reportNull$$$0(11);
        }
        if (use.isOfFunction()) {
            return true;
        }
        PhpUseList useList = PhpUseImpl.getUseList((PsiElement)use);
        return useList != null && useList.isOfFunction();
    }

    @NotNull
    public static String getReferenceText(@NotNull PhpUse use) {
        PhpReference reference;
        if (use == null) {
            PhpUseImpl.$$$reportNull$$$0(12);
        }
        return (reference = use.getTargetReference()) != null ? reference.getText() : "";
    }

    @NotNull
    public SearchScope getUseScope() {
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)this);
        Object object = scope != null ? new LocalSearchScope((PsiElement)scope) : super.getUseScope();
        if (object == null) {
            PhpUseImpl.$$$reportNull$$$0(13);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 7, 8, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpUseImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpUseImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCS";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOfConst";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isOfFunction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 7, 8, 13 -> new IllegalStateException(string);
        };
    }
}

