/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types.shapes;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.completion.PhpAnyExpressionArgument;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocPropertyTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpDocTagAliasTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpArrayShapesProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpDocArrayShapeProvider
extends PhpArrayShapesProvider {
    @Override
    protected Collection<PhpShapeEntriesIndex.PhpShapeEntry> collectValuesFromAssignments(Variable element, PhpAccessVariableInstruction accessInstruction, Ref<Boolean> ambiguous, boolean allowAmbiguity) {
        Collection<PhpShapeEntriesIndex.PhpShapeEntry> entries = super.collectValuesFromAssignments(element, accessInstruction, ambiguous, allowAmbiguity);
        if (entries.isEmpty()) {
            return (Collection)StreamEx.of(((VariableImpl)element).resolveVariables(false)).select(PhpDocVariable.class).map(PsiElement::getParent).select(PhpDocTag.class).flatMap(tag -> PhpDocArrayShapeProvider.getArrayShapesFromTagsWithCustom(tag, Stream.empty()).stream()).collect(Collectors.toList());
        }
        return entries;
    }

    @Override
    @NotNull
    protected List<PhpShapeEntriesIndex.PhpShapeEntry> getValuesFromAssignedValue(@Nullable Variable variable, PsiElement element) {
        if (variable != null) {
            PhpDocComment comment = variable.getDocComment();
            Collection<PhpDocParamTag> tags = ((VariableImpl)variable).getCurrentVarTags(comment);
            for (PhpDocParamTag tag : tags) {
                List<PhpShapeEntriesIndex.PhpShapeEntry> shapes = comment != null ? PhpDocArrayShapeProvider.getArrayShapesFromTagsWithCustom((PhpDocTag)tag, ((VariableImpl)variable).customTagsForVariable(comment)) : Collections.emptyList();
                if (shapes.isEmpty()) continue;
                List<PhpShapeEntriesIndex.PhpShapeEntry> list = shapes;
                if (list == null) {
                    PhpDocArrayShapeProvider.$$$reportNull$$$0(0);
                }
                return list;
            }
        }
        List<PhpShapeEntriesIndex.PhpShapeEntry> list = super.getValuesFromAssignedValue(variable, element);
        if (list == null) {
            PhpDocArrayShapeProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<PhpShapeEntriesIndex.PhpShapeEntry> getParameterValuesInner(@NotNull Function function, int argumentIndex) {
        Parameter parameter;
        if (function == null) {
            PhpDocArrayShapeProvider.$$$reportNull$$$0(2);
        }
        if ((parameter = function.getParameter(argumentIndex)) == null) {
            List<PhpShapeEntriesIndex.PhpShapeEntry> list = Collections.emptyList();
            if (list == null) {
                PhpDocArrayShapeProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<PhpShapeEntriesIndex.PhpShapeEntry> list = PhpDocArrayShapeProvider.getArrayShapesFromTagsWithCustom((PhpDocTag)parameter.getDocTag(), ParameterImpl.customTags(parameter));
        if (list == null) {
            PhpDocArrayShapeProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<PhpShapeEntriesIndex.PhpShapeEntry> getValuesInner(Function function) {
        PhpDocComment comment = function.getDocComment();
        if (comment == null) {
            List<PhpShapeEntriesIndex.PhpShapeEntry> list = Collections.emptyList();
            if (list == null) {
                PhpDocArrayShapeProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<PhpShapeEntriesIndex.PhpShapeEntry> list = PhpDocArrayShapeProvider.getArrayShapesFromTagsWithCustom((PhpDocTag)comment.getReturnTag(), FunctionImpl.getCustomTags(comment).stream());
        if (list == null) {
            PhpDocArrayShapeProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PhpShapeEntriesIndex.PhpShapeEntry> getValues(Field field) {
        if (field instanceof PhpDocProperty) {
            List<PhpShapeEntriesIndex.PhpShapeEntry> list = PhpDocArrayShapeProvider.getArrayShapesFromDoc((PhpDocTag)ObjectUtils.tryCast((Object)field.getParent(), PhpDocPropertyTag.class));
            if (list == null) {
                PhpDocArrayShapeProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        PhpDocComment comment = field.getDocComment();
        if (comment == null) {
            List<PhpShapeEntriesIndex.PhpShapeEntry> list = Collections.emptyList();
            if (list == null) {
                PhpDocArrayShapeProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<PhpShapeEntriesIndex.PhpShapeEntry> list = PhpDocArrayShapeProvider.getArrayShapesFromTagsWithCustom((PhpDocTag)comment.getVarTag(), FieldImpl.getCustomTags(comment).stream());
        if (list == null) {
            PhpDocArrayShapeProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static <T extends PhpNamedElement> List<PhpShapeEntriesIndex.PhpShapeEntry> getArrayShapesFromTagsWithCustom(@Nullable PhpDocTag docTag, Stream<PhpDocTag> tags) {
        StreamEx entries = docTag != null ? StreamEx.of(tags).append((Object)docTag) : tags;
        return entries.flatMap(tag -> PhpDocArrayShapeProvider.getArrayShapesFromDoc(tag).stream()).collect(Collectors.toList());
    }

    public static List<PhpShapeEntriesIndex.PhpShapeEntry> getArrayShapesFromDoc(PhpDocTag tag) {
        StreamEx docTypes = StreamEx.of(PhpPsiUtil.getChildren((PsiElement)tag, (Condition<? super PsiElement>)((Condition)PhpDocType.class::isInstance)));
        return (List)((StreamEx)docTypes.flatMap(d -> PhpDocArrayShapeProvider.collectShapesFromAttributeList((PsiElement)d).stream()).filter(s -> !s.isObjectShape())).collect(Collectors.toList());
    }

    public static List<PhpShapeEntriesIndex.PhpShapeEntry> getObjectShapesFromDoc(PhpDocTag tag) {
        StreamEx docTypes = StreamEx.of(PhpPsiUtil.getChildren((PsiElement)tag, (Condition<? super PsiElement>)((Condition)PhpDocType.class::isInstance)));
        return (List)((StreamEx)docTypes.flatMap(d -> PhpDocArrayShapeProvider.collectShapesFromAttributeList((PsiElement)d).stream()).filter(s -> s.isObjectShape())).collect(Collectors.toList());
    }

    private static boolean isUnsealedShape(PsiElement docAttributeList) {
        PsiElement variadic;
        PsiElement brace = docAttributeList.getLastChild();
        if (!PhpPsiUtil.isOfType(brace, PhpDocTokenTypes.DOC_RBRACE)) {
            return false;
        }
        for (variadic = brace.getPrevSibling(); !(variadic == null || variadic.getText().equals("...") || variadic.getText().equals(",") || variadic.getText().equals("{")); variadic = variadic.getPrevSibling()) {
        }
        return variadic != null && variadic.getText().equals("...");
    }

    @Nullable
    public static PsiElement resolveDocTagAliasTypes(@Nullable PsiElement element) {
        PhpDocType resolvedDocType;
        PhpDocType originalDocType;
        Collection<PhpDocTag> resolvedDocTags;
        PhpDocTag resolvedDocTag;
        if (element instanceof PhpDocType && (resolvedDocTag = (PhpDocTag)ContainerUtil.getFirstItem(resolvedDocTags = PhpDocTagAliasTypeProvider.resolveTypeAliases(originalDocType = (PhpDocType)element))) != null && (resolvedDocType = PhpPsiUtil.getChildOfClass((PsiElement)resolvedDocTag, PhpDocType.class)) != null && !resolvedDocTag.getName().endsWith("import-type")) {
            return resolvedDocType;
        }
        return element;
    }

    @NotNull
    public static List<PhpShapeEntriesIndex.PhpShapeEntry> collectShapesFromAttributeList(PsiElement element) {
        PsiElement docAttributeList;
        PhpDocType docType;
        boolean isObjectShape = (element = PhpDocArrayShapeProvider.resolveDocTagAliasTypes(element)) instanceof PhpDocType && "object".equals((docType = (PhpDocType)element).getName());
        PsiElement psiElement = docAttributeList = element != null ? PhpPsiUtil.getChildOfType(element, (IElementType)PhpDocElementTypes.phpDocAttributeList) : null;
        if (docAttributeList == null) {
            List<PhpShapeEntriesIndex.PhpShapeEntry> list = Collections.emptyList();
            if (list == null) {
                PhpDocArrayShapeProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        boolean isUnsealedShape = PhpDocArrayShapeProvider.isUnsealedShape(docAttributeList);
        ArrayList<PhpShapeEntriesIndex.PhpShapeEntry> result = new ArrayList<PhpShapeEntriesIndex.PhpShapeEntry>();
        PsiElement firstChild = docAttributeList.getFirstChild();
        if (!PhpPsiUtil.isOfType(firstChild, PhpDocTokenTypes.DOC_LBRACE)) {
            List<PhpShapeEntriesIndex.PhpShapeEntry> list = PhpDocArrayShapeProvider.collectArrayShapesFromNestedList(docAttributeList);
            if (list == null) {
                PhpDocArrayShapeProvider.$$$reportNull$$$0(11);
            }
            return list;
        }
        PsiElement child = PhpDocArrayShapeProvider.getNextElementInMultilineDocType(firstChild);
        int naturalCounter = 0;
        while (child != null) {
            PsiElement lastElement = child;
            while (child != null) {
                PsiElement closingQuote;
                String text = child.getText();
                if ("'".equals(text) || "':".equals(text) || "?'".equals(text) || "?".equals(text)) {
                    if ((child = PhpDocArrayShapeProvider.getNextElementInMultilineDocType(child)) == null) break;
                    text = child.getText();
                }
                String name = child instanceof PhpDocType ? String.valueOf(naturalCounter++) : (StringUtil.isNotNegativeNumber((CharSequence)PhpDocArrayShapeProvider.trimNumberSuffix(text)) ? PhpDocArrayShapeProvider.trimNumberSuffix(text) : (StringUtil.isQuotedString((String)text) ? text : (isObjectShape ? text : StringUtil.wrapWithDoubleQuote((String)text))));
                boolean isOptional = child.getNextSibling() != null && child.getNextSibling().getText().contains("?");
                PhpType type = new PhpType();
                List<PsiElement> docTypes = PhpDocArrayShapeProvider.collectDocTypes(child, type);
                lastElement = (PsiElement)ContainerUtil.getLastItem(docTypes);
                for (PsiElement docType2 : docTypes) {
                    result.add(new PhpShapeEntriesIndex.PhpShapeEntry(new PhpExpectedFunctionScalarArgument(name, 0, 0, null, false, "", false), type, PhpDocArrayShapeProvider.collectShapesFromAttributeList(docType2), isObjectShape, isUnsealedShape, true, isOptional));
                }
                if (child.getNextSibling() == null || !child.getNextSibling().getText().equals("'") || !PhpPsiUtil.isOfType((closingQuote = child.getNextSibling()).getNextSibling(), PhpDocTokenTypes.DOC_PIPE)) break;
                child = closingQuote.getNextSibling().getNextSibling();
            }
            if ((child = lastElement) != null && (child = PhpDocArrayShapeProvider.getNextEntry(child)) != null) continue;
        }
        ArrayList<PhpShapeEntriesIndex.PhpShapeEntry> arrayList = result;
        if (arrayList == null) {
            PhpDocArrayShapeProvider.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static List<PhpShapeEntriesIndex.PhpShapeEntry> collectArrayShapesFromNestedList(PsiElement attributeList) {
        ArrayList<PhpShapeEntriesIndex.PhpShapeEntry> arrayShapes = new ArrayList<PhpShapeEntriesIndex.PhpShapeEntry>();
        LinkedList<PsiElement> attributeListQueue = new LinkedList<PsiElement>();
        attributeListQueue.add(attributeList);
        int depth = 0;
        while (!attributeListQueue.isEmpty()) {
            int size = attributeListQueue.size();
            for (int i = 0; i < size; ++i) {
                PsiElement attribute = (PsiElement)attributeListQueue.poll();
                if (attribute == null) continue;
                if (!PhpPsiUtil.isOfType(attribute.getFirstChild(), PhpDocTokenTypes.DOC_LBRACE)) {
                    List values = PhpPsiUtil.getChildren(attribute, (Condition<? super PsiElement>)((Condition)PhpDocType.class::isInstance));
                    attributeListQueue.addAll(ContainerUtil.map(values, v -> PhpPsiUtil.getChildOfType(v, (IElementType)PhpDocElementTypes.phpDocAttributeList)));
                    continue;
                }
                List<PhpShapeEntriesIndex.PhpShapeEntry> children = PhpDocArrayShapeProvider.collectShapesFromAttributeList(attribute.getParent());
                if (children.isEmpty()) continue;
                arrayShapes.add(PhpDocArrayShapeProvider.createNestedShapeWithDepth(depth, children));
            }
            ++depth;
        }
        return arrayShapes;
    }

    @NotNull
    private static PhpShapeEntriesIndex.PhpShapeEntry createNestedShapeWithDepth(int depth, List<PhpShapeEntriesIndex.PhpShapeEntry> children) {
        PhpShapeEntriesIndex.PhpShapeEntry entry = new PhpShapeEntriesIndex.PhpShapeEntry(PhpAnyExpressionArgument.INSTANCE, PhpType.ARRAY, children, false);
        for (int i = 1; i < depth; ++i) {
            entry = new PhpShapeEntriesIndex.PhpShapeEntry(PhpAnyExpressionArgument.INSTANCE, PhpType.ARRAY, Collections.singletonList(entry), false);
        }
        PhpShapeEntriesIndex.PhpShapeEntry phpShapeEntry = entry;
        if (phpShapeEntry == null) {
            PhpDocArrayShapeProvider.$$$reportNull$$$0(13);
        }
        return phpShapeEntry;
    }

    @Nullable
    private static PsiElement getNextElementInMultilineDocType(PsiElement firstChild) {
        return firstChild != null ? PhpPsiUtil.getNextSibling(firstChild, PhpDocArrayShapeProvider::isIgnoredElementInMultilineDocType) : null;
    }

    @Contract(value="null->false")
    public static boolean isIgnoredElementInMultilineDocType(@Nullable PsiElement e) {
        return e instanceof PsiWhiteSpace || PhpPsiUtil.isOfType(e, PhpDocTokenTypes.DOC_LEADING_ASTERISK) || PhpPsiUtil.isOfType(e, PhpTokenTypes.ARRAY_SHAPE_LINE_COMMENT);
    }

    @Nullable
    private static PsiElement getNextEntry(PsiElement child) {
        Object comma = PhpPsiUtil.getNextSiblingByCondition(child, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpDocTokenTypes.DOC_COMMA)));
        return PhpDocArrayShapeProvider.getNextElementInMultilineDocType(comma);
    }

    @NotNull
    private static String trimNumberSuffix(String text) {
        String string = StringUtil.trimEnd((String)StringUtil.trimEnd((String)text, (String)":"), (String)"?");
        if (string == null) {
            PhpDocArrayShapeProvider.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static List<PsiElement> collectDocTypes(PsiElement child, PhpType type) {
        PsiElement docType;
        ArrayList<PsiElement> docTypes = new ArrayList<PsiElement>();
        Object object = docType = child instanceof PhpDocType ? child : PhpPsiUtil.getNextSiblingByCondition(child, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF);
        while (docType instanceof PhpDocType) {
            type.add(docType);
            docTypes.add(docType);
            PsiElement pipe = PhpPsiUtil.getNextSiblingIgnoreWhitespace(docType, true);
            if (!PhpPsiUtil.isOfType(pipe, PhpDocTokenTypes.DOC_PIPE)) break;
            docType = PhpPsiUtil.getNextSiblingIgnoreWhitespace(pipe, true);
        }
        return docTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/shapes/PhpDocArrayShapeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesFromAssignedValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/shapes/PhpDocArrayShapeProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterValuesInner";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesInner";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectShapesFromAttributeList";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createNestedShapeWithDepth";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "trimNumberSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParameterValuesInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

