/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.impl.PhpFilePathUtils;
import com.jetbrains.php.lang.psi.stubs.PhpConstantStub;
import com.jetbrains.php.lang.psi.stubs.PhpConstantStubImpl;
import com.jetbrains.php.lang.psi.stubs.PhpStubSerializer;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCaseSensitiveConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantIndex;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00122\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/php/lang/psi/stubs/PhpConstantBaseStubSerializer;", "Lcom/jetbrains/php/lang/psi/stubs/PhpStubSerializer;", "Lcom/jetbrains/php/lang/psi/elements/Constant;", "Lcom/jetbrains/php/lang/psi/stubs/PhpConstantStub;", "<init>", "()V", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "Companion", "intellij.php.impl"})
public abstract class PhpConstantBaseStubSerializer
extends PhpStubSerializer<Constant, PhpConstantStub> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void serialize(@NotNull PhpConstantStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getNamespaceName());
        dataStream.writeName(stub.getValuePresentation());
        dataStream.writeShort((int)stub.getFlags());
        dataStream.writeName(stub.getDeprecatedSinceVersion());
        List<List<PhpFilePathUtils.PhpFilePathDescriptor>> filePaths = ((PhpConstantStubImpl)stub).getFilePaths();
        Intrinsics.checkNotNull(filePaths);
        Companion.writeFilePaths(dataStream, filePaths);
    }

    @NotNull
    public PhpConstantStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef name = dataStream.readName();
        StringRef namespace = dataStream.readName();
        if (namespace == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        StringRef valuePresentation = dataStream.readName();
        short flags = dataStream.readShort();
        StringRef deprecatedSinceRef = dataStream.readName();
        List<List<PhpFilePathUtils.PhpFilePathDescriptor>> res = Companion.readFilePaths(dataStream);
        return new PhpConstantStubImpl(parentStub, this.getElementType(), name, namespace, valuePresentation, deprecatedSinceRef, flags, res);
    }

    @Override
    public void indexStub(@NotNull PhpConstantStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        String string = stub.getName();
        if (string == null) {
            return;
        }
        String shortName = string;
        if (stub.isCaseSensitive()) {
            sink.occurrence(PhpCaseSensitiveConstantIndex.KEY, (Object)shortName);
        } else {
            sink.occurrence(PhpConstantIndex.KEY, (Object)StringUtil.toLowerCase((String)shortName));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\tJ\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nH\u0002J\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t2\u0006\u0010\u0006\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/php/lang/psi/stubs/PhpConstantBaseStubSerializer$Companion;", "", "<init>", "()V", "writeFilePaths", "", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "paths", "", "Lcom/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils$PhpFilePathDescriptor;", "writeFilePathDescriptor", "descriptor", "readFilePaths", "Lcom/intellij/psi/stubs/StubInputStream;", "readFilePathDescriptor", "intellij.php.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void writeFilePaths(@NotNull StubOutputStream dataStream, @NotNull List<? extends List<? extends PhpFilePathUtils.PhpFilePathDescriptor>> paths) {
            Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            dataStream.writeInt(paths.size());
            for (List<? extends PhpFilePathUtils.PhpFilePathDescriptor> list : paths) {
                dataStream.writeInt(list.size());
                for (PhpFilePathUtils.PhpFilePathDescriptor phpFilePathDescriptor : list) {
                    this.writeFilePathDescriptor(dataStream, phpFilePathDescriptor);
                }
            }
        }

        private final void writeFilePathDescriptor(StubOutputStream dataStream, PhpFilePathUtils.PhpFilePathDescriptor descriptor) {
            PhpFilePathUtils.PhpFilePathDescriptor phpFilePathDescriptor = descriptor;
            if (phpFilePathDescriptor instanceof PhpFilePathUtils.PhpStringFilePathDescriptor) {
                dataStream.writeInt(0);
                dataStream.writeUTF(((PhpFilePathUtils.PhpStringFilePathDescriptor)descriptor).getString());
            } else if (phpFilePathDescriptor instanceof PhpFilePathUtils.PhpSignatureFilePathDescriptor) {
                dataStream.writeInt(1);
                dataStream.writeUTF(((PhpFilePathUtils.PhpSignatureFilePathDescriptor)descriptor).getSignature());
            } else if (phpFilePathDescriptor instanceof PhpFilePathUtils.PhpDirUpFilePathDescriptor) {
                dataStream.writeInt(2);
                dataStream.writeInt(((PhpFilePathUtils.PhpDirUpFilePathDescriptor)descriptor).getLevel());
                List<PhpFilePathUtils.PhpFilePathDescriptor> childDescriptors = ((PhpFilePathUtils.PhpDirUpFilePathDescriptor)descriptor).getDescriptors();
                dataStream.writeInt(childDescriptors.size());
                for (PhpFilePathUtils.PhpFilePathDescriptor child : childDescriptors) {
                    Intrinsics.checkNotNull((Object)child);
                    this.writeFilePathDescriptor(dataStream, child);
                }
            } else if (phpFilePathDescriptor instanceof PhpFilePathUtils.PhpProjectRelativeStringFilePathDescriptor) {
                dataStream.writeInt(3);
                dataStream.writeUTF(((PhpFilePathUtils.PhpProjectRelativeStringFilePathDescriptor)descriptor).getRelativePath());
            } else {
                throw new IllegalStateException();
            }
        }

        @NotNull
        public final List<List<PhpFilePathUtils.PhpFilePathDescriptor>> readFilePaths(@NotNull StubInputStream dataStream) {
            Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
            int size = dataStream.readInt();
            if (size == 0) {
                return CollectionsKt.emptyList();
            }
            List result = new ArrayList();
            for (int i = 0; i < size; ++i) {
                int it = i;
                boolean bl = false;
                int pathSize = dataStream.readInt();
                List path = new ArrayList();
                int n = 0;
                while (n < pathSize) {
                    int it2 = n++;
                    boolean bl2 = false;
                    path.add(Companion.readFilePathDescriptor(dataStream));
                }
                result.add(path);
            }
            return result;
        }

        private final PhpFilePathUtils.PhpFilePathDescriptor readFilePathDescriptor(StubInputStream dataStream) {
            return switch (dataStream.readInt()) {
                case 0 -> new PhpFilePathUtils.PhpStringFilePathDescriptor(dataStream.readUTF());
                case 1 -> new PhpFilePathUtils.PhpSignatureFilePathDescriptor(dataStream.readUTF());
                case 2 -> {
                    int level = dataStream.readInt();
                    int descriptorSize = dataStream.readInt();
                    List descriptors = new ArrayList();
                    int var5_5 = 0;
                    while (var5_5 < descriptorSize) {
                        int it = var5_5++;
                        boolean $i$a$-repeat-PhpConstantBaseStubSerializer$Companion$readFilePathDescriptor$1 = false;
                        descriptors.add(Companion.readFilePathDescriptor(dataStream));
                    }
                    yield new PhpFilePathUtils.PhpDirUpFilePathDescriptor(descriptors, level);
                }
                case 3 -> new PhpFilePathUtils.PhpProjectRelativeStringFilePathDescriptor(dataStream.readUTF());
                default -> throw new IllegalStateException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

