/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpLanguageTypeMap;
import com.jetbrains.php.lang.psi.stubs.PhpParameterStub;
import com.jetbrains.php.lang.psi.stubs.PhpParameterStubImpl;
import com.jetbrains.php.lang.psi.stubs.PhpStubElementType;
import com.jetbrains.php.lang.psi.stubs.PhpStubSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/php/lang/psi/stubs/PhpParameterStubSerializer;", "Lcom/jetbrains/php/lang/psi/stubs/PhpStubSerializer;", "Lcom/jetbrains/php/lang/psi/elements/Parameter;", "Lcom/jetbrains/php/lang/psi/stubs/PhpParameterStub;", "isPromotedField", "", "<init>", "(Z)V", "()Z", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "getElementType", "Lcom/intellij/psi/tree/IElementType;", "intellij.php.impl"})
public final class PhpParameterStubSerializer
extends PhpStubSerializer<Parameter, PhpParameterStub> {
    private final boolean isPromotedField;

    public PhpParameterStubSerializer(boolean isPromotedField) {
        this.isPromotedField = isPromotedField;
    }

    public final boolean isPromotedField() {
        return this.isPromotedField;
    }

    public void serialize(@NotNull PhpParameterStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        dataStream.writeShort((int)stub.getFlags());
        dataStream.writeName(stub.getDefaultValuePresentation());
        PhpType phpType = stub.getDeclaredType();
        Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getDeclaredType(...)");
        this.writePhpType(dataStream, phpType);
        PhpType phpType2 = stub.getDefaultValueType();
        Intrinsics.checkNotNullExpressionValue((Object)phpType2, (String)"getDefaultValueType(...)");
        this.writePhpType(dataStream, phpType2);
        boolean isPromotedField = stub.isPromotedField();
        dataStream.writeBoolean(isPromotedField);
        if (isPromotedField) {
            dataStream.writeInt(stub.getPromotedFieldAccessIndex());
        }
        PhpDeprecationAttributeOwner.PhpDeprecationInfo.write((PhpDeprecationAttributeOwner.PhpDeprecationInfo)((PhpParameterStubImpl)stub).getDeprecationInfo(), (StubOutputStream)dataStream);
        dataStream.writeName(((PhpParameterStubImpl)stub).getAvailableInLanguageLevelFrom());
        dataStream.writeName(((PhpParameterStubImpl)stub).getAvailableInLanguageLevelTo());
        this.writeLanguageTypeMap(((PhpParameterStubImpl)stub).getLanguageTypeMap(), dataStream);
        dataStream.writeBoolean(((PhpParameterStubImpl)stub).isComputableCompileTimeDefaultValue());
    }

    @NotNull
    public PhpParameterStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef name = dataStream.readName();
        short flags = dataStream.readShort();
        StringRef defaultValuePresentation = dataStream.readName();
        PhpType declaredType = this.readPhpType(dataStream);
        PhpType defaultValueType = this.readPhpType(dataStream);
        boolean isPromotedField = dataStream.readBoolean();
        int promotedFieldAccessIndex = isPromotedField ? dataStream.readInt() : 1;
        PhpDeprecationAttributeOwner.PhpDeprecationInfo info = PhpDeprecationAttributeOwner.PhpDeprecationInfo.read((StubInputStream)dataStream);
        StringRef availableFrom = dataStream.readName();
        StringRef availableTo = dataStream.readName();
        PhpLanguageTypeMap map = this.readLanguageTypeMap(dataStream);
        boolean computableCompileTimeDefaultValue = dataStream.readBoolean();
        return new PhpParameterStubImpl(parentStub, this.getElementType(), name, flags, defaultValuePresentation, declaredType, defaultValueType, isPromotedField, promotedFieldAccessIndex, info, availableFrom, availableTo, map, computableCompileTimeDefaultValue);
    }

    @Override
    @NotNull
    public IElementType getElementType() {
        IElementType iElementType;
        if (this.isPromotedField) {
            PhpStubElementType phpStubElementType = PhpElementTypes.PROMOTED_FIELD_PARAMETER;
            Intrinsics.checkNotNullExpressionValue((Object)phpStubElementType, (String)"PROMOTED_FIELD_PARAMETER");
            iElementType = (IElementType)phpStubElementType;
        } else {
            PhpStubElementType phpStubElementType = PhpElementTypes.NOT_PROMOTED_PARAMETER;
            Intrinsics.checkNotNullExpressionValue((Object)phpStubElementType, (String)"NOT_PROMOTED_PARAMETER");
            iElementType = (IElementType)phpStubElementType;
        }
        return iElementType;
    }
}

