/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.completion.PhpAnyExpressionArgument;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCollectionExternalizer;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentUnwrapped;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsCollector;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantsFromClassArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionValuesFromConstantArguments;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedReturnValuesIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpMetaRegisteredArgumentsSetCollector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExpectedFunctionArgumentsIndex
extends FileBasedIndexExtension<String, Collection<PhpExpectedFunctionArgument>> {
    @NonNls
    public static final ID<String, Collection<PhpExpectedFunctionArgument>> KEY = ID.create((String)"php.expected.function.arguments");
    public static final DataExternalizer<PhpExpectedFunctionArgument> EXTERNALIZER = new DataExternalizer<PhpExpectedFunctionArgument>(){

        public void save(@NotNull DataOutput out, PhpExpectedFunctionArgument value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            Kind kind = PhpExpectedFunctionArgumentsIndex.getKind(value);
            out.writeInt(kind.ordinal());
            out.writeInt(value.getArgumentIndex());
            out.writeInt(value.getOrder());
            out.writeBoolean(value.isFlag());
            out.writeUTF(StringUtil.notNullize((String)value.getArgumentSet()));
            out.writeBoolean(value.isFromAttribute());
            if (value instanceof PhpAnyExpressionArgument) {
                return;
            }
            if (value instanceof PhpExpectedFunctionClassConstantArgument) {
                out.writeUTF(((PhpExpectedFunctionClassConstantArgument)value).getClassFqn());
                out.writeUTF(((PhpExpectedFunctionClassConstantArgument)value).getConstantName());
            } else if (value instanceof PhpExpectedFunctionScalarArgument) {
                out.writeUTF(value.getValue());
                out.writeUTF(((PhpExpectedFunctionScalarArgument)value).getType());
            } else if (value instanceof PhpExpectedFunctionConstantsFromClassArgument) {
                out.writeUTF(value.getValue());
            } else {
                out.writeUTF(value.getValue());
            }
        }

        public PhpExpectedFunctionArgument read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            Kind kind = Kind.values()[in.readInt()];
            int argumentIndex = in.readInt();
            int order = in.readInt();
            boolean flag = in.readBoolean();
            String argumentSet = StringUtil.nullize((String)in.readUTF());
            boolean fromAttribute = in.readBoolean();
            return switch (kind.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> new PhpExpectedFunctionConstantArgument(in.readUTF(), argumentIndex, order, argumentSet, flag, fromAttribute);
                case 3 -> new PhpExpectedFunctionClassConstantArgument(in.readUTF(), in.readUTF(), argumentIndex, order, argumentSet, flag, fromAttribute);
                case 4 -> new PhpExpectedFunctionConstantsFromClassArgument(in.readUTF(), argumentIndex, flag, fromAttribute);
                case 5 -> new PhpExpectedFunctionValuesFromConstantArguments(in.readUTF(), argumentIndex, flag, fromAttribute);
                case 0 -> PhpAnyExpressionArgument.INSTANCE;
                case 1 -> new PhpExpectedFunctionScalarArgument(in.readUTF(), argumentIndex, order, argumentSet, flag, in.readUTF(), fromAttribute);
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedFunctionArgumentsIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final PhpCollectionExternalizer<PhpExpectedFunctionArgument> VALUE_EXTERNALIZER = new PhpCollectionExternalizer<PhpExpectedFunctionArgument>(EXTERNALIZER, size -> size == 1 ? new SmartList() : new ArrayList(size));

    @NotNull
    public ID<String, Collection<PhpExpectedFunctionArgument>> getName() {
        ID<String, Collection<PhpExpectedFunctionArgument>> iD = KEY;
        if (iD == null) {
            PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Collection<PhpExpectedFunctionArgument>, FileContent> getIndexer() {
        return new DataIndexer<String, Collection<PhpExpectedFunctionArgument>, FileContent>(this){

            @NotNull
            public Map<String, Collection<PhpExpectedFunctionArgument>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    2.$$$reportNull$$$0(0);
                }
                HashMap<String, Collection<PhpExpectedFunctionArgument>> map = new HashMap<String, Collection<PhpExpectedFunctionArgument>>();
                PsiFile file = inputData.getPsiFile();
                if (file instanceof PhpFile) {
                    if (PhpParameterBasedTypeProvider.isMeta(file)) {
                        PhpExpectedFunctionArgumentsIndex.collectRegisteredExpectedArgumentsFromMeta((PhpFile)file, map);
                    } else {
                        PhpExpectedFunctionArgumentsIndex.collectExpectedArgumentsFromParametersDefaultValues((PhpFile)file, map);
                    }
                }
                Map map2 = StreamEx.of(map.entrySet()).toMap(Map.Entry::getKey, entry -> ((Collection)entry.getValue()).stream().distinct().collect(Collectors.toList()));
                if (map2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedFunctionArgumentsIndex$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedFunctionArgumentsIndex$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static void collectExpectedArgumentsFromParametersDefaultValues(PhpFile file, Map<String, Collection<PhpExpectedFunctionArgument>> map) {
        for (Function element : PhpFuncGetArgUsageProvider.findTopLevelFunctions((PsiFile)file)) {
            String fqn = element.getFQN();
            Parameter[] parameters = element.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                List elements;
                PsiElement defaultValue = parameters[i].getDefaultValue();
                if (defaultValue != null && !(elements = ContainerUtil.filter(PhpExpectedFunctionArgumentsIndex.unwrapOperands(defaultValue), PhpExpectedFunctionArgumentsIndex::canBeResolvedAbsolutely)).isEmpty()) {
                    map.computeIfAbsent(fqn, s -> new SmartList()).addAll(PhpExpectedFunctionArgumentsIndex.getExpectedFunctionArguments(elements, i, 0, null));
                }
                PhpExpectedReturnValuesIndex.expectedValuesFromAttributes((PhpAttributesOwner)parameters[i], i).forEach(expectedValue -> map.computeIfAbsent(fqn, s -> new ArrayList()).add(expectedValue));
            }
        }
    }

    private static boolean canBeResolvedAbsolutely(PsiElement e) {
        if (e instanceof ConstantReference) {
            return ((PhpReference)e).isAbsolute();
        }
        if (e instanceof ClassConstantReference) {
            PhpExpression reference = ((ClassConstantReference)e).getClassReference();
            return reference instanceof ClassReference && ((ClassReference)reference).isAbsolute();
        }
        return PhpPsiUtil.isOfType(e, PhpElementTypes.NUMBER, PhpElementTypes.STRING);
    }

    private static void collectRegisteredExpectedArgumentsFromMeta(PhpFile file, Map<String, Collection<PhpExpectedFunctionArgument>> map) {
        PhpMetaRegisteredArgumentsSetCollector registeredArgumentsSetCollector = new PhpMetaRegisteredArgumentsSetCollector();
        PhpControlFlowUtil.processFile(file, registeredArgumentsSetCollector);
        PhpControlFlowUtil.processFile(file, new PhpExpectedFunctionArgumentsCollector(map, registeredArgumentsSetCollector.getRegisteredArguments()));
    }

    @NotNull
    public DataExternalizer<Collection<PhpExpectedFunctionArgument>> getValueExternalizer() {
        PhpCollectionExternalizer<PhpExpectedFunctionArgument> phpCollectionExternalizer = VALUE_EXTERNALIZER;
        if (phpCollectionExternalizer == null) {
            PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(1);
        }
        return phpCollectionExternalizer;
    }

    @NotNull
    public static Kind getKind(@NotNull PhpExpectedFunctionArgument argument) {
        if (argument == null) {
            PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(2);
        }
        if (argument instanceof PhpAnyExpressionArgument) {
            Kind kind = Kind.ANY_EXPRESSION;
            if (kind == null) {
                PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(3);
            }
            return kind;
        }
        if (argument instanceof PhpExpectedFunctionScalarArgument) {
            Kind kind = Kind.SCALAR;
            if (kind == null) {
                PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(4);
            }
            return kind;
        }
        if (argument instanceof PhpExpectedFunctionConstantArgument) {
            Kind kind = Kind.CONSTANT;
            if (kind == null) {
                PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(5);
            }
            return kind;
        }
        if (argument instanceof PhpExpectedFunctionConstantsFromClassArgument) {
            Kind kind = Kind.CONSTANTS_FROM_CLASS;
            if (kind == null) {
                PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(6);
            }
            return kind;
        }
        if (argument instanceof PhpExpectedFunctionValuesFromConstantArguments) {
            Kind kind = Kind.VALUES_FROM_CONSTANT;
            if (kind == null) {
                PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(7);
            }
            return kind;
        }
        Kind kind = Kind.CLASS_CONSTANT;
        if (kind == null) {
            PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(8);
        }
        return kind;
    }

    @NotNull
    public static Collection<PhpExpectedFunctionArgument> getExpectedFunctionArguments(@NotNull PsiElement parameter, int argumentIndex, int order, @Nullable String argumentsSetName) {
        if (parameter == null) {
            PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(9);
        }
        return PhpExpectedFunctionArgumentsIndex.getExpectedFunctionArguments(PhpExpectedFunctionArgumentsIndex.unwrapOperands(parameter), argumentIndex, order, argumentsSetName);
    }

    @NotNull
    public static PhpExpectedFunctionArgument getExpectedArgument(@NotNull PsiElement parameter, int argumentIndex, int order, @Nullable String argumentsSetName, boolean flag) {
        if (parameter == null) {
            PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(10);
        }
        boolean fromAttribute = PhpPsiUtil.getParentByCondition(parameter, false, (Condition<? super PsiElement>)((Condition)PhpAttribute.class::isInstance), (Condition<? super PsiElement>)FunctionReference.INSTANCEOF) != null;
        return PhpExpectedFunctionArgumentsIndex.getExpectedArgument(parameter, argumentIndex, order, argumentsSetName, flag, fromAttribute);
    }

    @NotNull
    public static PhpExpectedFunctionArgument getExpectedArgument(@NonNls PsiElement parameter, int argumentIndex, int order, @Nullable String argumentsSetName, boolean flag, boolean fromAttribute) {
        return PhpExpectedFunctionArgumentsIndex.getExpectedArgument(parameter, argumentIndex, order, argumentsSetName, flag, fromAttribute, false);
    }

    @NotNull
    public static PhpExpectedFunctionArgument getExpectedArgument(@NonNls PsiElement parameter, int argumentIndex, int order, @Nullable String argumentsSetName, boolean flag, boolean fromAttribute, boolean isObjectShape) {
        String name;
        String text;
        String fqn;
        ClassConstantReference classConstantReference;
        PhpExpression classReference;
        if (parameter instanceof ClassConstantReference && (classReference = (classConstantReference = (ClassConstantReference)parameter).getClassReference()) instanceof ClassReference) {
            String classFqn = PhpExpectedFunctionArgumentsIndex.getFqnMetaAware((PhpReference)classReference);
            String constantName = classConstantReference.getName();
            if (classFqn != null && constantName != null) {
                return new PhpExpectedFunctionClassConstantArgument(classFqn, constantName, argumentIndex, order, argumentsSetName, flag, fromAttribute);
            }
        }
        if (parameter instanceof ConstantReference && (fqn = PhpExpectedFunctionArgumentsIndex.getFqnMetaAware((PhpReference)parameter)) != null) {
            return new PhpExpectedFunctionConstantArgument(fqn, argumentIndex, order, argumentsSetName, flag, fromAttribute);
        }
        String string = text = isObjectShape ? StringUtil.unquoteString((String)parameter.getText()) : parameter.getText();
        if (parameter instanceof FieldReference && (name = ((FieldReference)parameter).getName()) != null) {
            text = name;
        }
        PhpType type = isObjectShape ? PhpType.EMPTY : (parameter instanceof PhpTypedElement ? ((PhpTypedElement)parameter).getType() : null);
        return new PhpExpectedFunctionScalarArgument(text, argumentIndex, order, argumentsSetName, flag, type != null ? type.toString() : "", fromAttribute);
    }

    @NotNull
    private static Collection<PhpExpectedFunctionArgument> getExpectedFunctionArguments(@NotNull Collection<PsiElement> parameters, int argumentIndex, int order, @Nullable String argumentsSetName) {
        if (parameters == null) {
            PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(11);
        }
        boolean flag = parameters.size() > 1;
        List list = ContainerUtil.map(parameters, parameter -> PhpExpectedFunctionArgumentsIndex.getExpectedArgument(parameter, argumentIndex, order, argumentsSetName, flag));
        if (list == null) {
            PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private static String getFqnMetaAware(PhpReference reference) {
        if (reference.getNamespaceName().equals("\\PHPSTORM_META\\")) {
            return PhpCodeInsightUtil.getImmediateFQN(reference);
        }
        return reference.getFQN();
    }

    @NotNull
    public static Collection<PsiElement> unwrapOperands(PsiElement element) {
        SmartList parts = new SmartList();
        if (element instanceof BinaryExpression && ((BinaryExpression)element).getOperationType() == PhpTokenTypes.opBIT_OR) {
            for (PsiElement child : PhpPsiUtil.getChildren(element, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF)) {
                parts.addAll(PhpExpectedFunctionArgumentsIndex.unwrapOperands(child));
            }
        } else {
            parts.add(element);
        }
        SmartList smartList = parts;
        if (smartList == null) {
            PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(13);
        }
        return smartList;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(14);
        }
        return enumeratorStringDescriptor;
    }

    public int getVersion() {
        return 14;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpExpectedFunctionArgumentsIndex.$$$reportNull$$$0(15);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static boolean metaFunctionWithName(FunctionReference reference, String name) {
        return PhpLangUtil.equalsClassNames(reference.getName(), name) && "\\PHPSTORM_META\\".equals(reference.getNamespaceName());
    }

    public static List<PhpExpectedFunctionArgument> getUnpackedArguments(Project project, String functionFQN, ID<? super String, ? extends Collection<PhpExpectedFunctionArgument>> key) {
        FileBasedIndex index = FileBasedIndex.getInstance();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        return PhpExpectedFunctionArgumentsIndex.unpackArguments(project, index.getValues(key, (Object)functionFQN, scope).stream().flatMap(Collection::stream));
    }

    public static List<PhpExpectedFunctionArgument> unpackArguments(Project project, Stream<PhpExpectedFunctionArgument> stream) {
        return stream.flatMap(arg -> arg instanceof PhpExpectedFunctionArgumentUnwrapped ? ((PhpExpectedFunctionArgumentUnwrapped)arg).getArguments(project).stream() : Stream.of(arg)).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedFunctionArgumentsIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedFunctionArgumentsIndex";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFunctionArguments";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapOperands";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedFunctionArguments";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    public static enum Kind {
        ANY_EXPRESSION,
        SCALAR,
        CONSTANT,
        CLASS_CONSTANT,
        CONSTANTS_FROM_CLASS,
        VALUES_FROM_CONSTANT;

    }
}

