/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.phar.PharCompression;
import com.jetbrains.php.phar.PharHandlerBase;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.jetbrains.annotations.NotNull;

class TarHandler
extends PharHandlerBase {
    TarHandler(@NotNull String path, @NotNull PharCompression compression) {
        if (path == null) {
            TarHandler.$$$reportNull$$$0(0);
        }
        if (compression == null) {
            TarHandler.$$$reportNull$$$0(1);
        }
        super(path, compression);
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        HashMap<String, ArchiveHandler.EntryInfo> map = new HashMap<String, ArchiveHandler.EntryInfo>();
        try (TarArchiveInputStream stream = new TarArchiveInputStream(this.myCompression.wrapStream(Files.newInputStream(this.getPath(), new OpenOption[0])));){
            TarArchiveEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                long size = entry.getSize();
                long ts = entry.getModTime().getTime();
                long offset = stream.getBytesRead();
                this.processEntry(map, entry.getName(), entry.isDirectory() ? null : (parent, name) -> new TarEntryInfo((ArchiveHandler.EntryInfo)parent, (CharSequence)name, size, ts, offset));
            }
        }
        HashMap<String, ArchiveHandler.EntryInfo> hashMap = map;
        if (hashMap == null) {
            TarHandler.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @Override
    protected byte @NotNull [] readContentsFromStream(@NotNull String relativePath, @NotNull InputStream inputStream) throws IOException {
        block9: {
            ArchiveHandler.EntryInfo entryInfo;
            if (relativePath == null) {
                TarHandler.$$$reportNull$$$0(3);
            }
            if (inputStream == null) {
                TarHandler.$$$reportNull$$$0(4);
            }
            if ((entryInfo = this.getEntryInfo(relativePath)) instanceof TarEntryInfo) {
                byte[] byArray;
                BufferedInputStream stream;
                block10: {
                    TarEntryInfo info = (TarEntryInfo)entryInfo;
                    stream = new BufferedInputStream(inputStream);
                    long offset = info.offset;
                    if (stream.skip(offset) != offset) break block9;
                    long length = info.length;
                    byArray = FileUtil.loadBytes((InputStream)stream, (int)((int)length));
                    if (byArray != null) break block10;
                    TarHandler.$$$reportNull$$$0(5);
                }
                return byArray;
                finally {
                    stream.close();
                }
            }
        }
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            TarHandler.$$$reportNull$$$0(6);
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compression";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phar/TarHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phar/TarHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentsFromStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readContentsFromStream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6 -> new IllegalStateException(string);
        };
    }

    private static final class TarEntryInfo
    extends ArchiveHandler.EntryInfo {
        private final long offset;

        private TarEntryInfo(ArchiveHandler.EntryInfo parent, CharSequence shortName, long length, long timestamp, long offset) {
            super(shortName, false, length, timestamp, parent);
            this.offset = offset;
        }
    }
}

