/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.statistics.ComposerPackageVersion;
import com.jetbrains.php.phpunit.PhpUnitConfigurableForm;
import com.jetbrains.php.phpunit.PhpUnitExecutionUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PhpParaTestValidationLabel
extends JPanel {
    private final JBLabel myLabel;
    private final Project myProject;

    PhpParaTestValidationLabel(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            PhpParaTestValidationLabel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.setLayout(new BorderLayout());
        this.myLabel = new JBLabel();
        this.add((Component)this.myLabel);
        this.validatePath(path);
    }

    boolean validatePath(@Nullable String path) {
        boolean fileExists;
        VirtualFile file = path != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
        boolean bl = fileExists = file != null;
        if (StringUtil.isEmpty((String)path) || fileExists && path.endsWith("paratest_for_phpstorm")) {
            this.myLabel.setVisible(false);
            return true;
        }
        String versionWarning = PhpParaTestValidationLabel.validateParaTestVersion(this.myProject, file);
        if (versionWarning != null) {
            this.showWarning(versionWarning);
            return false;
        }
        if (StringUtil.isEmpty((String)path)) {
            this.showError(PhpBundle.message("PhpUnitConfigurableForm.phpunit.paratest.is.empty", new Object[0]));
            return false;
        }
        if (!path.endsWith("paratest_for_phpstorm")) {
            this.showError(PhpBundle.message("PhpUnitConfigurableForm.specified.wrong.paratest.binary", new Object[0]));
            return false;
        }
        if (!fileExists) {
            this.showError(PhpBundle.message("PhpUnitConfigurableForm.can.not.find.paratest", path));
            return false;
        }
        this.myLabel.setVisible(false);
        return true;
    }

    private void showWarning(@NlsSafe @NotNull String message) {
        if (message == null) {
            PhpParaTestValidationLabel.$$$reportNull$$$0(1);
        }
        this.myLabel.setVisible(true);
        this.myLabel.setText(message);
        this.myLabel.setIcon(UIUtil.getBalloonWarningIcon());
    }

    private void showError(@NlsSafe @NotNull String message) {
        if (message == null) {
            PhpParaTestValidationLabel.$$$reportNull$$$0(2);
        }
        this.myLabel.setVisible(true);
        this.myLabel.setText(message);
        this.myLabel.setIcon(UIUtil.getBalloonErrorIcon());
    }

    @NlsContexts.LinkLabel
    private static String validateParaTestVersion(@NotNull Project project, @Nullable VirtualFile file) {
        ComposerPackageVersion version;
        if (project == null) {
            PhpParaTestValidationLabel.$$$reportNull$$$0(3);
        }
        if ((version = PhpUnitExecutionUtil.getParaTestVersion(project, file)) != null && !version.isGreaterThan(PhpUnitConfigurableForm.PARATEST_SUPPORTED_VERSION)) {
            return PhpBundle.message("PhpUnitConfigurableForm.unsupported.paratest.version", version.getVersion());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phpunit/PhpParaTestValidationLabel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showWarning";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showError";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "validateParaTestVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

