/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.phpunit.PhpUnitBaseSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.phpunit.PhpUnitRuntimeConfigurationProducer;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationFactory;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkStateListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitSettingsManager
implements Disposable {
    private final PhpUnitProjectSettingsManager myProjectManager;
    private final PhpUnitApplicationSettingsManager myApplicationManager;
    @Nullable
    private Project myProject;

    public static PhpUnitSettingsManager getInstance(@Nullable Project project) {
        Project targetProject = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        return (PhpUnitSettingsManager)targetProject.getService(PhpUnitSettingsManager.class);
    }

    public PhpUnitSettingsManager(final @Nullable Project project) {
        this.myProject = project;
        this.myApplicationManager = PhpUnitApplicationSettingsManager.getInstance();
        if (project != null && !project.isDefault()) {
            this.myProjectManager = PhpUnitProjectSettingsManager.getInstance(project);
            PhpTestFrameworkStateListener listener = new PhpTestFrameworkStateListener(){

                @Override
                public void onSettingsUpdate() {
                    PhpUnitSettingsManager.this.resolvePossibleCollisions(project);
                }
            };
            this.myProjectManager.addListener(this, listener);
            this.myApplicationManager.addListener(this, listener);
            this.resolvePossibleCollisions(project);
        } else {
            this.myProjectManager = null;
        }
    }

    private void resolvePossibleCollisions(@NotNull Project project) {
        if (project == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(0);
        }
        if (this.myProjectManager == null) {
            return;
        }
        boolean hasApplicationLevel = this.myProjectManager.getAllSettings().stream().anyMatch(settings -> !settings.isProjectLevel());
        if (!hasApplicationLevel) {
            boolean hasProjectLevel = this.myApplicationManager.getAllSettings().stream().anyMatch(PhpUnitSettings::isProjectLevel);
            if (hasProjectLevel) {
                this.setSettings(this.getAllSettings());
            }
            return;
        }
        SmartList newSettings = new SmartList();
        ArrayList<PhpUnitSettings> projectLevel = new ArrayList<PhpUnitSettings>();
        ArrayList<PhpUnitSettings> applicationLevel = new ArrayList<PhpUnitSettings>();
        for (PhpUnitSettings settings2 : this.myApplicationManager.getAllSettings()) {
            if (settings2.isProjectLevel()) {
                projectLevel.add(settings2);
                continue;
            }
            applicationLevel.add(settings2);
        }
        for (PhpUnitSettings settings2 : this.myProjectManager.getAllSettings()) {
            if (!settings2.isProjectLevel()) {
                PhpUnitSettings existingSetting = this.myApplicationManager.getSettingsByName(settings2.getPresentableName(project));
                if (existingSetting != null) {
                    PhpUnitSettings copySettings;
                    if (existingSetting.equals(settings2) || (copySettings = settings2.copyWithSettingsSource(project)) == null) continue;
                    newSettings.add(existingSetting.getPresentableName(project));
                    projectLevel.add(copySettings);
                    continue;
                }
                applicationLevel.add(settings2);
                continue;
            }
            projectLevel.add(settings2);
        }
        this.myApplicationManager.setSettings(applicationLevel);
        this.myProjectManager.setSettings(projectLevel);
        if (!newSettings.isEmpty()) {
            PhpUnitSettingsManager.showWarning(project, (List<String>)newSettings);
        }
    }

    public void onInterpretersUpdate() {
        if (this.myProjectManager == null) {
            return;
        }
        this.resolvePossibleCollisions(this.myProjectManager.myProject);
    }

    private static void showWarning(@NotNull Project project, @NotNull List<@NlsSafe String> newSettings) {
        if (project == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(1);
        }
        if (newSettings == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(2);
        }
        HtmlBuilder builder2 = new HtmlBuilder().append(PhpBundle.message("PhpUnitConfiguration.interpreter.conflict", new Object[0]));
        for (String name : newSettings) {
            builder2.append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.text((String)("'" + name + "'")).bold());
        }
        String title = PhpBundle.message("PhpUnitConfiguration.interpreter.conflict.title", new Object[0]);
        PhpUnitUtil.NOTIFICATION_GROUP.createNotification(title, builder2.toString(), NotificationType.WARNING).notify(project);
    }

    @NotNull
    public List<PhpUnitSettings> getAllSettings() {
        ArrayList<PhpUnitSettings> result = new ArrayList<PhpUnitSettings>();
        if (this.myProjectManager != null) {
            result.addAll(this.myProjectManager.getAllSettings());
        }
        result.addAll(this.myApplicationManager.getAllSettings());
        ArrayList<PhpUnitSettings> arrayList = result;
        if (arrayList == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public PhpUnitSettings addSettingsIfAbsent(@NotNull PhpUnitSettings settings, @Nullable String interpreterId, @Nullable VirtualFile locationContext) {
        if (settings == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(4);
        }
        if (this.myProjectManager == null) {
            PhpUnitSettings phpUnitSettings = this.myApplicationManager.addIfAbsent(settings, interpreterId, locationContext);
            if (phpUnitSettings == null) {
                PhpUnitSettingsManager.$$$reportNull$$$0(5);
            }
            return phpUnitSettings;
        }
        if (settings.isProjectLevel()) {
            PhpUnitSettings phpUnitSettings = this.myProjectManager.addIfAbsent(settings, interpreterId, locationContext);
            if (phpUnitSettings == null) {
                PhpUnitSettingsManager.$$$reportNull$$$0(6);
            }
            return phpUnitSettings;
        }
        PhpUnitSettings phpUnitSettings = this.myApplicationManager.addIfAbsent(settings, interpreterId, locationContext);
        if (phpUnitSettings == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(7);
        }
        return phpUnitSettings;
    }

    public void setSettings(@NotNull List<PhpUnitSettings> settings) {
        if (settings == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(8);
        }
        if (this.myProjectManager == null) {
            this.myApplicationManager.setSettings(settings);
            return;
        }
        ArrayList<PhpUnitSettings> applicationLevel = new ArrayList<PhpUnitSettings>();
        ArrayList<PhpUnitSettings> projectLevel = new ArrayList<PhpUnitSettings>();
        for (PhpUnitSettings phpunit : settings) {
            if (phpunit.isProjectLevel()) {
                projectLevel.add(phpunit);
                continue;
            }
            applicationLevel.add(phpunit);
        }
        this.myApplicationManager.setSettings(applicationLevel);
        this.myProjectManager.setSettings(projectLevel);
    }

    @NotNull
    public Collection<PhpUnitSettings> getLocalSettings() {
        if (this.myProjectManager != null) {
            Collection<PhpUnitSettings> collection = this.myProjectManager.getLocalSettings();
            if (collection == null) {
                PhpUnitSettingsManager.$$$reportNull$$$0(9);
            }
            return collection;
        }
        List<PhpUnitSettings> list = Collections.emptyList();
        if (list == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public PhpUnitSettings getLocalSettings(@Nullable VirtualFile locationContext) {
        if (this.myProjectManager != null && this.myProject != null) {
            Collection<PhpUnitSettings> configurations = PhpTestFrameworkSettingsManager.filterConfigsByLocation(this.myProject, this.myProjectManager.getAllSettings(), locationContext);
            return PhpTestFrameworkSettingsManager.findLocalConfiguration(configurations);
        }
        return null;
    }

    @Nullable
    private PhpUnitSettings getRemoteSettings(@Nullable VirtualFile locationContext) {
        if (this.myProjectManager != null && this.myProject != null) {
            Collection<PhpUnitSettings> configurations = PhpTestFrameworkSettingsManager.filterConfigsByLocation(this.myProject, this.myProjectManager.getAllSettings(), locationContext);
            return PhpTestFrameworkSettingsManager.findRemoteConfiguration(configurations);
        }
        return null;
    }

    @Nullable
    private PhpUnitSettings getDefaultLocalSettings(@Nullable VirtualFile locationContext) {
        VirtualFile mainConfig;
        VirtualFile composerConfig;
        if (this.myProject == null) {
            return null;
        }
        PhpUnitSettings localSettings = this.getLocalSettings(locationContext);
        if (localSettings == null && !Objects.equals(composerConfig = ComposerConfigManager.getInstance(this.myProject).getConfig(locationContext), mainConfig = ComposerConfigManager.getInstance(this.myProject).getMainConfig())) {
            return this.getLocalSettings(mainConfig);
        }
        return localSettings;
    }

    @Nullable
    private PhpUnitSettings getDefaultRemoteSettings(@Nullable VirtualFile locationContext) {
        VirtualFile mainConfig;
        VirtualFile composerConfig;
        if (this.myProject == null) {
            return null;
        }
        PhpUnitSettings remoteSettings = this.getRemoteSettings(locationContext);
        if (remoteSettings == null && !Objects.equals(composerConfig = ComposerConfigManager.getInstance(this.myProject).getConfig(locationContext), mainConfig = ComposerConfigManager.getInstance(this.myProject).getMainConfig())) {
            return this.getRemoteSettings(mainConfig);
        }
        return remoteSettings;
    }

    @Nullable
    public PhpUnitSettings getDefaultSettings(@Nullable VirtualFile locationContext) {
        PhpUnitSettings defaultLocalSettings = this.getDefaultLocalSettings(locationContext);
        if (defaultLocalSettings != null) {
            return defaultLocalSettings;
        }
        return this.getDefaultRemoteSettings(locationContext);
    }

    @NotNull
    public PhpUnitSettings getOrCreateByInterpreter(@Nullable PhpInterpreter interpreter, @Nullable VirtualFile locationContext) {
        PhpUnitSettings phpUnitSettings = this.getOrCreateByInterpreter(interpreter, false, locationContext);
        if (phpUnitSettings == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(11);
        }
        return phpUnitSettings;
    }

    @NotNull
    public PhpUnitSettings getOrCreateByInterpreter(@Nullable PhpInterpreter interpreter, boolean onTheFly, @Nullable VirtualFile locationContext) {
        PhpUnitSettings settings = this.getSettingsByInterpreter(interpreter, locationContext);
        if (settings != null) {
            PhpUnitSettings phpUnitSettings = settings;
            if (phpUnitSettings == null) {
                PhpUnitSettingsManager.$$$reportNull$$$0(12);
            }
            return phpUnitSettings;
        }
        String paraTestExe = PhpUnitRuntimeConfigurationProducer.findParaTestExePath(this.myProject, locationContext);
        List<PhpTestFrameworkConfigurationFactory> factories = PhpUnitFrameworkType.getInstance().getFactories();
        for (PhpTestFrameworkConfigurationFactory factory : factories) {
            Object config = factory.createByInterpreter(interpreter);
            if (!(config instanceof PhpUnitSettings)) continue;
            PhpUnitSettings newSettings = (PhpUnitSettings)config;
            newSettings.setParaTestPath(paraTestExe);
            if (!onTheFly) {
                String interpreterId = interpreter != null ? interpreter.getId() : null;
                PhpUnitSettings phpUnitSettings = this.addSettingsIfAbsent(newSettings, interpreterId, locationContext);
                if (phpUnitSettings == null) {
                    PhpUnitSettingsManager.$$$reportNull$$$0(13);
                }
                return phpUnitSettings;
            }
            PhpUnitSettings defaultSettings = this.getDefaultSettings(locationContext);
            PhpTestFrameworkSettingsManager.fillSettings(factory, interpreter, defaultSettings, newSettings, this.myProject);
            PhpUnitSettings phpUnitSettings = newSettings;
            if (phpUnitSettings == null) {
                PhpUnitSettingsManager.$$$reportNull$$$0(14);
            }
            return phpUnitSettings;
        }
        assert (false);
        if (null == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(15);
        }
        return null;
    }

    @NotNull
    public Collection<PhpUnitSettings> getSettingsByInterpreter(@Nullable PhpInterpreter interpreter) {
        if (interpreter == null || !interpreter.isRemote()) {
            Collection<PhpUnitSettings> collection = this.getLocalSettings();
            if (collection == null) {
                PhpUnitSettingsManager.$$$reportNull$$$0(16);
            }
            return collection;
        }
        PhpUnitSettings settingsByName = this.getSettingsByName("Interpreter: " + interpreter.getName());
        List<PhpUnitSettings> list = settingsByName != null ? List.of(settingsByName) : Collections.emptyList();
        if (list == null) {
            PhpUnitSettingsManager.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    public PhpUnitSettings getSettingsByInterpreter(@Nullable PhpInterpreter interpreter, @Nullable VirtualFile locationContext) {
        if (interpreter == null || !interpreter.isRemote()) {
            return this.getLocalSettings(locationContext);
        }
        if (!Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            return this.getSettingsByName("Interpreter: " + interpreter.getName());
        }
        if (this.myProject == null || StringUtil.isEmpty((String)interpreter.getName()) || StringUtil.isEmpty((String)interpreter.getId())) {
            return null;
        }
        PhpUnitSettings appSetting = PhpTestFrameworkSettingsManager.getConfigurationByInterpreter(this.myProject, this.myApplicationManager.getAllSettings(), interpreter, locationContext);
        if (appSetting != null) {
            return appSetting;
        }
        if (this.myProjectManager != null) {
            return PhpTestFrameworkSettingsManager.getConfigurationByInterpreter(this.myProject, this.myProjectManager.getAllSettings(), interpreter, locationContext);
        }
        return null;
    }

    @Nullable
    public PhpUnitSettings getSettingsByName(@Nullable String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        PhpUnitSettings phpunit = this.myApplicationManager.getSettingsByName(name);
        if (phpunit == null && this.myProjectManager != null) {
            phpunit = this.myProjectManager.getSettingsByName(name);
        }
        return phpunit;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSettings";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitSettingsManager";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitSettingsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSettings";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addSettingsIfAbsent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalSettings";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateByInterpreter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsByInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolvePossibleCollisions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showWarning";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsIfAbsent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    @State(name="PhpUnit", storages={@Storage(value="php.xml", roamingType=RoamingType.DISABLED, deprecated=true), @Storage(value="php-tools.xml", roamingType=RoamingType.DISABLED)})
    public static class PhpUnitApplicationSettingsManager
    extends PhpUnitBaseSettingsManager {
        public static PhpUnitApplicationSettingsManager getInstance() {
            return (PhpUnitApplicationSettingsManager)ApplicationManager.getApplication().getService(PhpUnitApplicationSettingsManager.class);
        }
    }

    @State(name="PhpUnit", storages={@Storage(value="php.xml")})
    private static class PhpUnitProjectSettingsManager
    extends PhpUnitBaseSettingsManager {
        public static PhpUnitProjectSettingsManager getInstance(@NotNull Project project) {
            if (project == null) {
                PhpUnitProjectSettingsManager.$$$reportNull$$$0(0);
            }
            return (PhpUnitProjectSettingsManager)project.getService(PhpUnitProjectSettingsManager.class);
        }

        PhpUnitProjectSettingsManager(@NotNull Project project) {
            if (project == null) {
                PhpUnitProjectSettingsManager.$$$reportNull$$$0(1);
            }
            super(project);
        }

        @NotNull
        public Collection<PhpUnitSettings> getLocalSettings() {
            List list = ContainerUtil.filter(this.mySettings.values(), s -> s.isLocal());
            if (list == null) {
                PhpUnitProjectSettingsManager.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitSettingsManager$PhpUnitProjectSettingsManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitSettingsManager$PhpUnitProjectSettingsManager";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocalSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

