/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpParameterTemplate;
import com.jetbrains.php.refactoring.changeSignature.PhpCallerChooser;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterCodeFragment;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterTableModel;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterTableModelItem;
import com.jetbrains.php.refactoring.ui.PhpCodeComponentsFactory;
import com.jetbrains.php.refactoring.validation.PhpFunctionConflictDetector;
import com.jetbrains.php.refactoring.validation.PhpMethodConflictDetector;
import com.jetbrains.php.refactoring.validation.PhpNameConflictDetector;
import com.jetbrains.php.refactoring.validation.PhpParameterValidator;
import com.jetbrains.php.refactoring.validation.PhpReturnTypeValidator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class PhpChangeSignatureDialog
extends ChangeSignatureDialogBase<PhpParameterInfo, Function, String, PhpMethodDescriptor, PhpParameterTableModelItem, PhpParameterTableModel> {
    private final Font defaultTableFont = EditorUtil.getEditorFont();
    private JCheckBox myInitializeParametersCheckBox;
    private final PhpNameConflictDetector myNameConflictDetector;

    public PhpChangeSignatureDialog(Project project, PhpMethodDescriptor method, PsiElement defaultValueContext) {
        super(project, (MethodDescriptor)method, false, defaultValueContext);
        Function function = method.getMethod();
        this.myNameConflictDetector = function instanceof Method ? new PhpMethodConflictDetector((Method)function) : new PhpFunctionConflictDetector(function);
    }

    protected LanguageFileType getFileType() {
        return PhpFileType.INSTANCE;
    }

    @NotNull
    protected PhpParameterTableModel createParametersInfoModel(@NotNull PhpMethodDescriptor method) {
        if (method == null) {
            PhpChangeSignatureDialog.$$$reportNull$$$0(0);
        }
        PsiElement parameterList = PhpPsiUtil.getChildOfType((PsiElement)method.getMethod(), PhpElementTypes.PARAMETER_LIST);
        return new PhpParameterTableModel(parameterList, this.myDefaultValueContext, this.myProject);
    }

    @VisibleForTesting
    public BaseRefactoringProcessor createRefactoringProcessor() {
        List parameters = this.getParameters();
        return new PhpChangeSignatureProcessor(this.myProject, (PhpMethodDescriptor)this.myMethod, this.getVisibility(), this.getMethodName(), this.myReturnTypeField != null ? this.myReturnTypeField.getText() : null, parameters.toArray(new PhpParameterInfo[0]), this.myMethodsToPropagateParameters, this.initializeParameters(), true);
    }

    private boolean initializeParameters() {
        return this.myInitializeParametersCheckBox != null && this.myInitializeParametersCheckBox.isSelected();
    }

    @Nullable
    protected PsiCodeFragment createReturnTypeCodeFragment() {
        return PhpPsiElementFactory.createTypeCodeFragment(this.myProject, StringUtil.notNullize((String)((PhpMethodDescriptor)this.myMethod).getReturnTypeText()), (PsiElement)((PhpMethodDescriptor)this.myMethod).getMethod(), true);
    }

    protected CallerChooserBase<Function> createCallerChooser(String title, Tree treeToReuse, Consumer<? super Set<Function>> callback) {
        return new PhpCallerChooser(((PhpMethodDescriptor)this.myMethod).getMethod(), this.myProject, title, treeToReuse, callback);
    }

    @Nullable
    protected String getVisibility() {
        return ((PhpMethodDescriptor)this.myMethod).getMethod() instanceof Method ? (String)super.getVisibility() : null;
    }

    protected String calculateSignature() {
        for (PhpParameterTableModelItem item : ((PhpParameterTableModel)this.myParametersTableModel).getItems()) {
            String typeText = item.typeCodeFragment.getText().trim();
            ((PhpParameterInfo)item.parameter).setType(PhpChangeSignatureDialog.getTypeFromPresentation(typeText, ((PhpMethodDescriptor)this.myMethod).getMethod().getNamespaceName()), typeText);
        }
        @NonNls StringBuilder builder2 = new StringBuilder();
        String visibility = this.getVisibility();
        if (StringUtil.isNotEmpty((String)visibility)) {
            builder2.append(visibility);
            builder2.append(" ");
            PhpModifier modifier = ((Method)((PhpMethodDescriptor)this.myMethod).getMethod()).getModifier();
            if (modifier.isStatic()) {
                builder2.append("static ");
            }
            if (modifier.isAbstract()) {
                builder2.append("abstract ");
            } else if (modifier.isFinal()) {
                builder2.append("final ");
            }
        }
        String signature = PhpFunctionCodeGenerator.PREVIEW.generate(this.getMethodName(), ((PhpParameterTableModel)this.myParametersTableModel).getItems(), this.myReturnTypeField != null ? this.myReturnTypeField.getText() : "", PhpFunctionCodeGenerator.useTrailingCommaInParametersList(((PhpMethodDescriptor)this.myMethod).getMethod()));
        builder2.append(signature);
        return builder2.toString();
    }

    protected VisibilityPanelBase<String> createVisibilityControl() {
        return new ComboBoxVisibilityPanel((Object[])new String[]{PhpModifier.Access.PRIVATE.toString(), PhpModifier.Access.PROTECTED.toString(), PhpModifier.Access.PUBLIC.toString(), ""}, new String[]{"private", "protected", "public", "default"});
    }

    protected MethodSignatureComponent createSignaturePreviewComponent() {
        MethodSignatureComponent preview = PhpCodeComponentsFactory.createPhpMethodSignaturePreview(this.myProject);
        preview.setText(this.calculateSignature());
        return preview;
    }

    protected JComponent createCenterPanel() {
        JComponent panel = super.createCenterPanel();
        assert (panel != null);
        if (this.showInitializeParametersCheckbox()) {
            JPanel subPanel = new JPanel(new BorderLayout());
            this.myInitializeParametersCheckBox = new JCheckBox(PhpBundle.message("change.signature.initialize.new.parameters", new Object[0]), true);
            subPanel.add((Component)this.myInitializeParametersCheckBox, "Center");
            panel.add((Component)subPanel, "North");
        }
        return panel;
    }

    protected boolean showInitializeParametersCheckbox() {
        return ((PhpMethodDescriptor)this.myMethod).isConstructor();
    }

    protected boolean isListTableViewSupported() {
        return true;
    }

    protected ChangeSignatureDialogBase.ParametersListTable createParametersListTable() {
        return new ChangeSignatureDialogBase.ParametersListTable(){

            @NotNull
            protected JBTableRowEditor getRowEditor(final ParameterTableModelItemBase<PhpParameterInfo> item) {
                assert (item instanceof PhpParameterTableModelItem);
                final PhpParameterTableModelItem phpItem = (PhpParameterTableModelItem)item;
                return new JBTableRowEditor(){
                    private EditorTextField myTypeEditor;
                    private EditorTextField myParameterEditor;
                    private EditorTextField myDefaultValueEditor;

                    public void prepareEditor(JTable table, int row) {
                        this.setLayout(new GridLayout(1, 3));
                        this.add(this.createTypePanel());
                        this.add(this.createParameterPanel());
                        if (phpItem.defaultValueNeeded(PhpChangeSignatureDialog.this.myProject)) {
                            this.add(this.createDefaultValuePanel());
                        }
                    }

                    @NotNull
                    private JPanel createTypePanel() {
                        this.myTypeEditor = this.createEditorTextField(item.typeCodeFragment, new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 0));
                        JPanel typePanel = 1.createLabeledPanel((String)PhpBundle.message("change.signature.column.type.parameter", new Object[0]), (JComponent)this.myTypeEditor);
                        this.myTypeEditor.addDocumentListener((DocumentListener)PhpChangeSignatureDialog.this.mySignatureUpdater);
                        JPanel jPanel = typePanel;
                        if (jPanel == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return jPanel;
                    }

                    @NotNull
                    private JPanel createParameterPanel() {
                        PhpParameterTableModelItem paramModel = (PhpParameterTableModelItem)item;
                        PhpParameterCodeFragment codeFragment = new PhpParameterCodeFragment(PhpChangeSignatureDialog.this.myProject, "fragment." + PhpFileType.INSTANCE.getDefaultExtension(), StringUtil.notNullize((String)PhpFunctionCodeGenerator.getParameterNameWithInitializer((PhpParameterTemplate)paramModel.parameter, paramModel.getName())), PhpChangeSignatureDialog.this.myDefaultValueContext, true);
                        this.myParameterEditor = this.createEditorTextField((PsiCodeFragment)codeFragment, new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 1));
                        JPanel parameterPanel = 1.createLabeledPanel((String)PhpBundle.message("change.signature.column.name.parameter", new Object[0]), (JComponent)this.myParameterEditor);
                        parameterPanel.setToolTipText(PhpBundle.message("change.signature.tooltip.parameter", new Object[0]));
                        this.myParameterEditor.setToolTipText(PhpBundle.message("change.signature.tooltip.parameter", new Object[0]));
                        this.myParameterEditor.addDocumentListener((DocumentListener)PhpChangeSignatureDialog.this.mySignatureUpdater);
                        JPanel jPanel = parameterPanel;
                        if (jPanel == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return jPanel;
                    }

                    @NotNull
                    private JPanel createDefaultValuePanel() {
                        this.myDefaultValueEditor = this.createEditorTextField(item.defaultValueCodeFragment, null);
                        JPanel defaultValueEditorPanel = 1.createLabeledPanel((String)PhpBundle.message("default", new Object[0]), (JComponent)this.myDefaultValueEditor);
                        defaultValueEditorPanel.setToolTipText(PhpBundle.message("change.signature.tooltip.default.value", new Object[0]));
                        this.myDefaultValueEditor.setToolTipText(PhpBundle.message("change.signature.tooltip.default.value", new Object[0]));
                        JPanel jPanel = defaultValueEditorPanel;
                        if (jPanel == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return jPanel;
                    }

                    @NotNull
                    private EditorTextField createEditorTextField(@NotNull PsiCodeFragment psiCodeFragment, @Nullable JBTableRowEditor.RowEditorChangeListener documentListener) {
                        if (psiCodeFragment == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        Document document = PsiDocumentManager.getInstance((Project)PhpChangeSignatureDialog.this.getProject()).getDocument((PsiFile)psiCodeFragment);
                        EditorTextField editorTextField = new EditorTextField(document, PhpChangeSignatureDialog.this.getProject(), (FileType)PhpChangeSignatureDialog.this.getFileType());
                        if (documentListener != null) {
                            editorTextField.addDocumentListener((DocumentListener)documentListener);
                        }
                        editorTextField.setBorder(BorderFactory.createLineBorder(UIUtil.getTableBackground()));
                        editorTextField.setFont(PhpChangeSignatureDialog.this.defaultTableFont);
                        EditorTextField editorTextField2 = editorTextField;
                        if (editorTextField2 == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return editorTextField2;
                    }

                    public JBTableRow getValue() {
                        return new JBTableRow(){

                            @Nullable
                            public Object getValueAt(int column) {
                                return switch (column) {
                                    case 0 -> phpItem.typeCodeFragment;
                                    case 1 -> PhpFunctionCodeGenerator.getParameterNameWithInitializer((PhpParameterTemplate)phpItem.parameter, ((PhpParameterInfo)phpItem.parameter).getName());
                                    case 2 -> phpItem.defaultValueCodeFragment;
                                    default -> null;
                                };
                            }
                        };
                    }

                    public JComponent getPreferredFocusedComponent() {
                        return this.myTypeEditor.getFocusTarget();
                    }

                    public JComponent[] getFocusableComponents() {
                        ArrayList<JComponent> focusable = new ArrayList<JComponent>();
                        focusable.add(this.myTypeEditor.getFocusTarget());
                        focusable.add(this.myParameterEditor.getFocusTarget());
                        if (this.myDefaultValueEditor != null) {
                            focusable.add(this.myDefaultValueEditor.getFocusTarget());
                        }
                        return focusable.toArray(new JComponent[0]);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 2;
                            case 3 -> 3;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureDialog$1$1";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "psiCodeFragment";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createTypePanel";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createParameterPanel";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createDefaultValuePanel";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureDialog$1$1";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createEditorTextField";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 3: {
                                objectArray = objectArray;
                                objectArray[2] = "createEditorTextField";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalStateException(string);
                            case 3 -> new IllegalArgumentException(string);
                        };
                    }
                };
            }

            protected JBTableRowRenderer getRowRenderer(int row) {
                return new EditorTextFieldJBTableRowRenderer(PhpChangeSignatureDialog.this.getProject(), (Language)PhpLanguage.INSTANCE, PhpChangeSignatureDialog.this.getDisposable()){

                    protected String getText(JTable table, int row) {
                        PhpParameterTableModelItem phpItem = (PhpParameterTableModelItem)this.getRowItem(row);
                        String defaultValue = phpItem.defaultValueCodeFragment.getText();
                        String defaultValuePresentationTail = this.getDefaultValuePresentation(phpItem, defaultValue);
                        return " " + phpItem.getNewParameter() + defaultValuePresentationTail;
                    }

                    @NotNull
                    private String getDefaultValuePresentation(PhpParameterTableModelItem phpItem, String defaultValue) {
                        if (StringUtil.isNotEmpty((String)defaultValue)) {
                            int numberOfSpaces = PhpChangeSignatureDialog.this.getParametersMaxLength() - phpItem.getNewParameter().length() + 1;
                            String string = StringUtil.repeatSymbol((char)' ', (int)numberOfSpaces) + " // " + defaultValue;
                            if (string == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            return string;
                        }
                        return "";
                    }

                    @NotNull
                    protected EditorTextFieldCellRenderer.RendererComponent createRendererComponent(@Nullable Project project, @Nullable Language language, boolean inheritFontFromLaF) {
                        EditorTextFieldCellRenderer.RendererComponent component = super.createRendererComponent(project, language, inheritFontFromLaF);
                        PhpCodeComponentsFactory.setPhpCodeFragmentHighlighter(component.getEditor());
                        EditorTextFieldCellRenderer.RendererComponent rendererComponent = component;
                        if (rendererComponent == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return rendererComponent;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureDialog$1$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getDefaultValuePresentation";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createRendererComponent";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
            }

            protected boolean isRowEmpty(int row) {
                return false;
            }
        };
    }

    private int getParametersMaxLength() {
        return StreamEx.of((Collection)((PhpParameterTableModel)this.myParametersTableModel).getItems()).mapToInt(item -> item.getParameterPreviewText().length()).max().orElse(0);
    }

    protected boolean mayPropagateParameters() {
        List items = this.getParameters();
        for (PhpParameterInfo item : items) {
            if (!item.isNew()) continue;
            return true;
        }
        return false;
    }

    protected boolean postponeValidation() {
        return false;
    }

    @VisibleForTesting
    @Nullable
    public ValidationInfo doValidate() {
        String functionValidationMessage;
        if (!((PhpMethodDescriptor)this.myMethod).isAnonymous() && (functionValidationMessage = this.myNameConflictDetector.findConflicts(this.getMethodName())) != null) {
            return new ValidationInfo(functionValidationMessage, (JComponent)this.myNameField);
        }
        if (this.getTableComponent().isEditing()) {
            return super.doValidate();
        }
        if (this.myReturnTypeField != null) {
            String returnType = this.myReturnTypeField.getText();
            ValidationInfo validate = PhpReturnTypeValidator.validate(((PhpMethodDescriptor)this.myMethod).getMethod().getProject(), returnType, (PsiElement)((PhpMethodDescriptor)this.myMethod).getMethod());
            if (validate != null) {
                return validate;
            }
        }
        return PhpParameterValidator.validate(this.myProject, ((PhpParameterTableModel)this.myParametersTableModel).getItems(), ((PhpMethodDescriptor)this.myMethod).getMethod());
    }

    @VisibleForTesting
    @Nullable
    public String validateAndCommitData() {
        String newName = this.getMethodName();
        if (!((PhpMethodDescriptor)this.myMethod).isAnonymous() && !PhpNameUtil.isValidFunctionName(newName)) {
            return PhpBundle.message("validation.invalid.identifier", newName);
        }
        ValidationInfo validationInfo = PhpParameterValidator.validateAndCommit(this.myProject, ((PhpParameterTableModel)this.myParametersTableModel).getItems(), ((PhpMethodDescriptor)this.myMethod).getMethod().getNamespaceName());
        if (validationInfo == null) {
            return this.validateReturnType();
        }
        return validationInfo.message;
    }

    @NlsContexts.DialogMessage
    @Nullable
    private String validateReturnType() {
        ValidationInfo validateReturn;
        if (this.myReturnTypeField != null && (validateReturn = PhpReturnTypeValidator.validate(this.myProject, this.myReturnTypeField.getText(), (PsiElement)((PhpMethodDescriptor)this.myMethod).getMethod())) != null) {
            return validateReturn.message;
        }
        return null;
    }

    public static PhpType getTypeFromPresentation(@NotNull String typePresentation, @Nullable String namespace) {
        boolean hasQuestionMark;
        if (typePresentation == null) {
            PhpChangeSignatureDialog.$$$reportNull$$$0(1);
        }
        String typeWithoutQuestionMark = (hasQuestionMark = typePresentation.startsWith("?")) ? typePresentation.substring(1) : typePresentation;
        PhpType type = (PhpType)StreamEx.of((Collection)StringUtil.split((String)typeWithoutQuestionMark, (String)"|")).map(t -> t.startsWith("\\") || PhpType.isPrimitiveType((String)t) ? t : PhpLangUtil.concat(Strings.notNullize((String)namespace), t)).foldLeft((Object)new PhpType(), (acc, t) -> acc.add(t));
        return hasQuestionMark ? type.add(PhpType.NULL) : type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePresentation";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createParametersInfoModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromPresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

