/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMethodDescriptor
implements MethodDescriptor<PhpParameterInfo, String> {
    private final boolean myIsAnonymous;
    @NotNull
    private final Function myMethod;

    public PhpMethodDescriptor(@NotNull Function method) {
        if (method == null) {
            PhpMethodDescriptor.$$$reportNull$$$0(0);
        }
        this.myMethod = method;
        this.myIsAnonymous = StringUtil.isEmpty((String)this.myMethod.getName());
    }

    public String getMethodAccess() {
        return this.myMethod instanceof Method ? ((Method)this.myMethod).getAccess().toString() : "";
    }

    public String getName() {
        return this.myMethod.getName();
    }

    public boolean isAnonymous() {
        return this.myIsAnonymous;
    }

    @NotNull
    public List<PhpParameterInfo> getParameters() {
        ArrayList<PhpParameterInfo> parameterInfos = new ArrayList<PhpParameterInfo>();
        Parameter[] parameters = this.myMethod.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            PsiElement value = parameter.getDefaultValue();
            boolean isOptional = value != null;
            String initializer = isOptional ? value.getText() : "";
            String type = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter);
            parameterInfos.add(new PhpParameterInfo(i, parameter.getName(), type, parameter.getType(), "", initializer, parameter.isPassByRef(), parameter.isVariadic()));
        }
        ArrayList<PhpParameterInfo> arrayList = parameterInfos;
        if (arrayList == null) {
            PhpMethodDescriptor.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public int getParametersCount() {
        return this.myMethod.getParameters().length;
    }

    @NotNull
    public String getVisibility() {
        if (this.myMethod instanceof Method) {
            PsiElement visibilityModifier;
            PhpModifierList modifierList = (PhpModifierList)PhpPsiUtil.getChildByCondition((PsiElement)this.myMethod, (Condition<? super PsiElement>)((Condition)PhpModifierList.class::isInstance));
            PsiElement psiElement = visibilityModifier = modifierList != null ? PhpPsiUtil.getChildOfType((PsiElement)modifierList, PhpTokenTypes.tsVISIBILITY_MODIFIERS) : null;
            if (PhpPsiUtil.isOfType(visibilityModifier, PhpTokenTypes.kwPRIVATE)) {
                String string = PhpModifier.Access.PRIVATE.toString();
                if (string == null) {
                    PhpMethodDescriptor.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (PhpPsiUtil.isOfType(visibilityModifier, PhpTokenTypes.kwPROTECTED)) {
                String string = PhpModifier.Access.PROTECTED.toString();
                if (string == null) {
                    PhpMethodDescriptor.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (PhpPsiUtil.isOfType(visibilityModifier, PhpTokenTypes.kwPUBLIC)) {
                String string = PhpModifier.Access.PUBLIC.toString();
                if (string == null) {
                    PhpMethodDescriptor.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        return "";
    }

    @NotNull
    public Function getMethod() {
        Function function = this.myMethod;
        if (function == null) {
            PhpMethodDescriptor.$$$reportNull$$$0(5);
        }
        return function;
    }

    public boolean canChangeVisibility() {
        if (!(this.myMethod instanceof Method)) {
            return false;
        }
        PhpClass clazz = ((Method)this.myMethod).getContainingClass();
        return clazz != null && !clazz.isInterface();
    }

    public boolean canChangeParameters() {
        return true;
    }

    public boolean canChangeName() {
        return !this.isConstructor() && !this.isAnonymous();
    }

    public boolean isConstructor() {
        if (!(this.myMethod instanceof Method)) {
            return false;
        }
        PhpClass clazz = ((Method)this.myMethod).getContainingClass();
        return clazz != null && !clazz.isInterface() && !clazz.isTrait() && ((Method)this.myMethod).getMethodType(false) == Method.MethodType.CONSTRUCTOR;
    }

    @NotNull
    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        if (!PhpLanguageFeature.RETURN_TYPES.isSupported(this.myMethod.getProject())) {
            MethodDescriptor.ReadWriteOption readWriteOption = MethodDescriptor.ReadWriteOption.None;
            if (readWriteOption == null) {
                PhpMethodDescriptor.$$$reportNull$$$0(6);
            }
            return readWriteOption;
        }
        MethodDescriptor.ReadWriteOption readWriteOption = this.myMethod instanceof Method && PhpRefactoringUtil.isConstructor((Method)this.myMethod) ? MethodDescriptor.ReadWriteOption.None : MethodDescriptor.ReadWriteOption.ReadWrite;
        if (readWriteOption == null) {
            PhpMethodDescriptor.$$$reportNull$$$0(7);
        }
        return readWriteOption;
    }

    @Nullable
    public String getReturnTypeText() {
        return PhpMethodDescriptor.getReturnTypeText(this.myMethod);
    }

    public static String getReturnTypeText(Function method) {
        PhpReturnType typeElement = (PhpReturnType)method.getTypeDeclaration();
        if (typeElement == null) {
            return null;
        }
        return typeElement.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpMethodDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpMethodDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "canChangeReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

