/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpParameterTemplate;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParameterInfo
implements ParameterInfo,
PhpParameterTemplate {
    private final int myOldIndex;
    private String myName;
    private String myTypeText;
    private PhpType myType;
    private String myDefaultValue;
    private String myInitializer;
    protected boolean myIsPassByRef;
    private boolean myIsVariadic;

    public PhpParameterInfo(int index) {
        this.myName = "";
        this.myTypeText = "";
        this.myType = PhpType.EMPTY;
        this.myDefaultValue = "";
        this.myInitializer = "";
        this.myIsPassByRef = false;
        this.myIsVariadic = false;
        this.myOldIndex = index;
    }

    public PhpParameterInfo(int oldIndex, String name, String typePresentation, PhpType type, String defaultValue, String initializer, boolean isPassByRef, boolean isVariadic) {
        this.myName = "";
        this.myTypeText = "";
        this.myType = PhpType.EMPTY;
        this.myDefaultValue = "";
        this.myInitializer = "";
        this.myIsPassByRef = false;
        this.myIsVariadic = false;
        this.myOldIndex = oldIndex;
        this.myName = name;
        this.myTypeText = typePresentation;
        this.myType = type;
        this.myDefaultValue = defaultValue;
        this.myInitializer = initializer;
        this.myIsPassByRef = isPassByRef;
        this.myIsVariadic = isVariadic;
    }

    public PhpParameterInfo(int index, String name) {
        this.myName = "";
        this.myTypeText = "";
        this.myType = PhpType.EMPTY;
        this.myDefaultValue = "";
        this.myInitializer = "";
        this.myIsPassByRef = false;
        this.myIsVariadic = false;
        this.myOldIndex = index;
        this.myName = name;
    }

    public PhpParameterInfo(int index, @NotNull Parameter parameter) {
        if (parameter == null) {
            PhpParameterInfo.$$$reportNull$$$0(0);
        }
        this(index, parameter.getName(), PhpRefactoringUtil.getParameterTypeDeclarationString(parameter), parameter.getType(), "", PhpParameterInfo.getDefaultValueText(parameter), parameter.isPassByRef(), parameter.isVariadic());
    }

    private static String getDefaultValueText(@NotNull Parameter parameter) {
        PsiElement value;
        if (parameter == null) {
            PhpParameterInfo.$$$reportNull$$$0(1);
        }
        return (value = parameter.getDefaultValue()) != null ? value.getText() : null;
    }

    @Override
    @NotNull
    public String getParameterPreviewText() {
        String string = PhpFunctionCodeGenerator.generateParameter(this);
        if (string == null) {
            PhpParameterInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PhpParameterInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    public int getOldIndex() {
        return this.myOldIndex;
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    @Override
    public void updateParameter(Parameter parameter) {
    }

    @Override
    public boolean shouldBeInitialized() {
        return false;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    @NotNull
    public String getTypeText() {
        String string = this.myTypeText;
        if (string == null) {
            PhpParameterInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public PhpType getType() {
        PhpType phpType = this.myType;
        if (phpType == null) {
            PhpParameterInfo.$$$reportNull$$$0(5);
        }
        return phpType;
    }

    @Override
    public boolean isPassByRef() {
        return this.myIsPassByRef;
    }

    @Override
    public boolean isVariadic() {
        return this.myIsVariadic;
    }

    public boolean isUseAnySingleVariable() {
        return false;
    }

    public void setUseAnySingleVariable(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getInitializer() {
        return this.myInitializer;
    }

    public void setInitializer(String initializer) {
        this.myInitializer = initializer;
    }

    public void setDefaultValue(String defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    public void setType(PhpType type, String typeText) {
        this.myType = type;
        this.myTypeText = typeText;
    }

    public void setIsPassByRef(boolean isPassByRef) {
        this.myIsPassByRef = isPassByRef;
    }

    public void setVariadic(boolean isVariadic) {
        this.myIsVariadic = isVariadic;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpParameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpParameterInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterPreviewText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValueText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

