/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractClass;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorMethodData;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.PhpNameStyle;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import com.jetbrains.php.refactoring.extractClass.PhpExtractClassBaseProcessor;
import com.jetbrains.php.refactoring.extractClass.PhpExtractMembersToClassConflicts;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PhpExtractMembersToClassProcessor
extends PhpExtractClassBaseProcessor {
    @NotNull
    private final List<PhpClassMember> mySelectedMembersList;
    @NotNull
    private final PhpClass myContainingClass;
    private final boolean myHasDynamicMembers;
    private final boolean myGenerateAccessors;
    private final String myBackReferenceOnContainingClassName;
    @NotNull
    private final String myTargetClassFqn;

    public PhpExtractMembersToClassProcessor(@NotNull Project project, @NotNull PhpClass containingClass, @NotNull List<PhpMemberInfo> memberInfoList, @NotNull String className, @NotNull String namespace, @NotNull PhpFileCreationInfo fileCreationInfo, boolean generateAccessors) {
        if (project == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(0);
        }
        if (containingClass == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(1);
        }
        if (memberInfoList == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(2);
        }
        if (className == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(3);
        }
        if (namespace == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(4);
        }
        if (fileCreationInfo == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(5);
        }
        super(project, className, namespace, fileCreationInfo);
        this.mySelectedMembersList = ContainerUtil.map(memberInfoList, e -> (PhpClassMember)e.getMember());
        this.myContainingClass = containingClass;
        this.myHasDynamicMembers = PhpExtractMembersToClassConflicts.hasDynamicMembers(this.mySelectedMembersList);
        this.myGenerateAccessors = generateAccessors;
        this.myBackReferenceOnContainingClassName = this.generateFieldName((PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)this.myContainingClass.getContainingFile(), PhpCodeStyleSettings.class), this.myContainingClass.getName());
        this.myTargetClassFqn = PhpLangUtil.toFQN(this.myNamespaceName + "\\" + this.myTargetClassName);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(6);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        PhpExtractMembersToClassConflicts conflicts = new PhpExtractMembersToClassConflicts(this.mySelectedMembersList, this.myContainingClass, this.myGenerateAccessors);
        conflicts.checkConstructor();
        conflicts.checkNonMovedMembersInsideMovedMembers();
        ArrayList<PsiFile> affectedFiles = new ArrayList<PsiFile>();
        for (UsageInfo usageInfo : usages) {
            affectedFiles.add(usageInfo.getFile());
        }
        affectedFiles.add(this.myContainingClass.getContainingFile());
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myProject, affectedFiles, (boolean)true)) {
            return false;
        }
        return this.showConflicts(conflicts.getConflicts(), usages);
    }

    @Override
    protected void performMainRefactoring(UsageInfo[] usages) {
        if (!this.tryToCreateClass()) {
            return;
        }
        assert (this.myTargetClass != null);
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)this.myContainingClass.getContainingFile(), PhpCodeStyleSettings.class);
        String delegateName = this.generateFieldName(settings, this.myTargetClassName);
        for (UsageInfo usageInfo : usages) {
            PsiElement usageElement = usageInfo.getElement();
            if (usageElement instanceof FieldReference && !PhpExtractMembersToClassProcessor.isInsideMovedMember(usageElement, this.mySelectedMembersList)) {
                this.replaceWithDynamicDelegationAccess(delegateName, (FieldReference)usageElement);
            }
            if (!(usageElement instanceof ClassConstantReference) || PhpExtractMembersToClassProcessor.isInsideMovedMember(usageElement, this.mySelectedMembersList)) continue;
            this.replaceWithDelegatedConstantReference((ClassConstantReference)usageElement);
        }
        PhpClassReferenceResolver resolver = new PhpClassReferenceResolver();
        final Ref accessedTargetClassDynamically = new Ref((Object)false);
        final Collection containingClassMembers = this.myContainingClass.getMethods();
        final PhpExtractMembersToClassConflicts conflicts = new PhpExtractMembersToClassConflicts(this.mySelectedMembersList, this.myContainingClass, this.myGenerateAccessors);
        ArrayList<PsiElement> addedToTargetClassMembers = new ArrayList<PsiElement>();
        for (final PhpClassMember member : this.mySelectedMembersList) {
            if (member instanceof Method) {
                resolver.processElement((PsiElement)member);
                member.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

                    public void visitPhpFieldReference(FieldReference fieldReference) {
                        PsiElement resolvedElement = fieldReference.resolve();
                        if (resolvedElement instanceof Field) {
                            Field resolvedField = (Field)resolvedElement;
                            if (!fieldReference.isWriteAccess() && conflicts.readAccessFromInitialClass(resolvedField, (Method)member)) {
                                this.processReadAccess(fieldReference, resolvedField);
                            }
                        }
                        super.visitPhpFieldReference(fieldReference);
                    }

                    public void visitPhpMethodReference(MethodReference reference) {
                        PhpExpression classReference;
                        PsiElement resolvedElement = reference.resolve();
                        if (resolvedElement instanceof Method && !PhpExtractMembersToClassProcessor.this.mySelectedMembersList.contains(resolvedElement) && containingClassMembers.contains(resolvedElement) && (classReference = reference.getClassReference()) != null && !reference.isStatic()) {
                            classReference.replace((PsiElement)this.createBackReferenceOnInitialClass());
                            accessedTargetClassDynamically.set((Object)true);
                        }
                        super.visitPhpMethodReference(reference);
                    }

                    @NotNull
                    private PhpExpression createBackReferenceOnInitialClass() {
                        PhpExpression phpExpression = PhpPsiElementFactory.createPhpPsiFromText(PhpExtractMembersToClassProcessor.this.myProject, PhpExpression.class, "$this->" + PhpExtractMembersToClassProcessor.this.myBackReferenceOnContainingClassName);
                        if (phpExpression == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return phpExpression;
                    }

                    public void visitPhpVariable(Variable variable) {
                        if (PhpLangUtil.isThisReference((PsiElement)variable) && PhpPsiUtil.getParentOfClass((PsiElement)variable, FieldReference.class) == null && PhpPsiUtil.getParentOfClass((PsiElement)variable, MemberReference.class) == null) {
                            variable.replace((PsiElement)this.createBackReferenceOnInitialClass());
                            accessedTargetClassDynamically.set((Object)true);
                        }
                        super.visitPhpVariable(variable);
                    }

                    public Method @NotNull [] findOrCreateGetters(@NotNull PhpAccessorsGenerator accessorsGenerator, @NotNull Field resolvedField) {
                        if (accessorsGenerator == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (resolvedField == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        Method[] fieldGetters = accessorsGenerator.findGetters();
                        if (!resolvedField.getModifier().isPublic() && PhpExtractMembersToClassProcessor.this.myGenerateAccessors && fieldGetters.length == 0) {
                            PhpAccessorMethodData[] generatorGetters = accessorsGenerator.createGetters(false);
                            PhpAccessorMethodData generatedGetter = generatorGetters[0];
                            PhpCodeEditUtil.insertClassMemberWithPhpDoc(generatedGetter.getTargetClass(), (PsiElement)generatedGetter.getMethod(), generatedGetter.getDocComment());
                            fieldGetters = accessorsGenerator.findGetters();
                        }
                        if (fieldGetters == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return fieldGetters;
                    }

                    public void processReadAccess(FieldReference fieldReference, @NotNull Field resolvedField) {
                        if (resolvedField == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        PhpAccessorsGenerator accessorsGenerator = new PhpAccessorsGenerator(resolvedField);
                        Method[] fieldGetters = this.findOrCreateGetters(accessorsGenerator, resolvedField);
                        Object fromClassMemberReference = !resolvedField.getModifier().isPublic() && fieldGetters.length > 0 ? PhpPsiElementFactory.createMethodReference(PhpExtractMembersToClassProcessor.this.myProject, "$this->" + PhpExtractMembersToClassProcessor.this.myBackReferenceOnContainingClassName + "->" + fieldGetters[0].getName() + "()") : (MemberReference)PhpPsiElementFactory.createFirstFromText(PhpExtractMembersToClassProcessor.this.myProject, FieldReference.class, "$this->" + PhpExtractMembersToClassProcessor.this.myBackReferenceOnContainingClassName + "->" + resolvedField.getName());
                        fieldReference.replace((PsiElement)Objects.requireNonNull(fromClassMemberReference));
                        accessedTargetClassDynamically.set((Object)true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 2;
                            case 1, 2, 4 -> 3;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/jetbrains/php/refactoring/extractClass/PhpExtractMembersToClassProcessor$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "accessorsGenerator";
                                break;
                            }
                            case 2: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "resolvedField";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createBackReferenceOnInitialClass";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/jetbrains/php/refactoring/extractClass/PhpExtractMembersToClassProcessor$1";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "findOrCreateGetters";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "findOrCreateGetters";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray;
                                objectArray[2] = "processReadAccess";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalStateException(string);
                            case 1, 2, 4 -> new IllegalArgumentException(string);
                        };
                    }
                });
                member.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

                    public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                        if (assignmentExpression instanceof SelfAssignmentExpression || assignmentExpression instanceof MultiassignmentExpression) {
                            return;
                        }
                        PhpPsiElement variable = assignmentExpression.getVariable();
                        if (variable == null) {
                            return;
                        }
                        PsiReference reference = variable.getReference();
                        if (!(reference instanceof FieldReference)) {
                            return;
                        }
                        PsiElement resolvedField = reference.resolve();
                        if (!(resolvedField instanceof Field)) {
                            return;
                        }
                        if (conflicts.isWriteAccessFromInitialClass((FieldReference)reference, (Field)resolvedField, (Method)member)) {
                            PhpExtractMembersToClassProcessor.this.processWriteAccess((FieldReference)reference, (Field)resolvedField, (Ref<Boolean>)accessedTargetClassDynamically);
                        }
                        super.visitPhpAssignmentExpression(assignmentExpression);
                    }
                });
                Method insertedMethod = PhpMoveClassMemberBase.PhpMoveClassMember.copyAsMethodToTargetClass((Function)((Method)member), null, this.myContainingClass, this.myTargetClass, this.mySelectedMembersList);
                PhpChangeSignatureUsageProcessor.updateMethodVisibility(insertedMethod, PhpModifier.Access.PUBLIC.toString());
                addedToTargetClassMembers.add((PsiElement)insertedMethod);
                this.replaceWithMethodDelegation(delegateName, (Method)member);
            }
            if (!(member instanceof Field)) continue;
            resolver.processElement((PsiElement)member);
            addedToTargetClassMembers.add(this.processFieldDeclaration((Field)member));
        }
        PhpPsiElement targetClassScopeForUseOperator = Objects.requireNonNull(PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)this.myTargetClass));
        if (this.myHasDynamicMembers) {
            this.createDelegateField(delegateName, (Boolean)accessedTargetClassDynamically.get());
            if (((Boolean)accessedTargetClassDynamically.get()).booleanValue()) {
                this.createFieldInClass(Objects.requireNonNull(this.myContainingClass).getName(), this.myBackReferenceOnContainingClassName, this.myTargetClass, false);
                PhpCodeEditUtil.insertClassMember(this.myTargetClass, (PsiElement)PhpPsiElementFactory.createMethod(this.myProject, "public function __construct(" + this.myContainingClass.getName() + " $" + this.myBackReferenceOnContainingClassName + "){\n $this->" + this.myBackReferenceOnContainingClassName + "= $" + this.myBackReferenceOnContainingClassName + ";\n}"));
                this.importClassIfPossible(this.myContainingClass.getFQN(), Objects.requireNonNull(PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)this.myTargetClass)));
            }
            this.importClassIfPossible(this.myTargetClassFqn, Objects.requireNonNull(PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)this.myContainingClass)));
        }
        resolver.importReferences(targetClassScopeForUseOperator, addedToTargetClassMembers);
        this.optimizeImports(this.myTargetClass.getContainingFile());
        this.reformatCreatedFileAndNavigate();
    }

    private void importClassIfPossible(@NotNull String classFqn, PhpPsiElement scope) {
        if (classFqn == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(7);
        }
        if (!PhpCodeInsightUtil.isSameNamespace(scope, classFqn)) {
            PhpAliasImporter.insertUseStatement(this.myTargetClassFqn, scope);
        }
    }

    public void processWriteAccess(@NotNull FieldReference fieldReference, @NotNull Field resolvedField, @NotNull Ref<Boolean> accessedFieldsFromTargetClass) {
        PsiElement parent;
        if (fieldReference == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(8);
        }
        if (resolvedField == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(9);
        }
        if (accessedFieldsFromTargetClass == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(10);
        }
        if ((parent = fieldReference.getParent()) instanceof AssignmentExpression) {
            AssignmentExpression assignmentExpression = (AssignmentExpression)parent;
            PhpAccessorsGenerator accessorsGenerator = new PhpAccessorsGenerator(resolvedField);
            PhpPsiElement value = assignmentExpression.getValue();
            if (value != null) {
                boolean fieldIsPublic = resolvedField.getModifier().isPublic();
                Method[] setters = this.findOrCreateSetters(accessorsGenerator, fieldIsPublic);
                if (!(fieldIsPublic || setters.length <= 0 || PhpExtractMembersToClassConflicts.isInsideArrayDestructuringExpression(fieldReference) || PhpExtractMembersToClassConflicts.isInsideMultipleAssignmentExpression(fieldReference))) {
                    MethodReference accessToMemberInFromClass = PhpPsiElementFactory.createMethodReference(this.myProject, "$this->" + this.myBackReferenceOnContainingClassName + "->" + setters[0].getName() + "(" + value.getText() + ")");
                    assignmentExpression.replace((PsiElement)Objects.requireNonNull(accessToMemberInFromClass));
                } else {
                    FieldReference referenceToFieldInFromClass = PhpPsiElementFactory.createFirstFromText(this.myProject, FieldReference.class, "$this->" + this.myBackReferenceOnContainingClassName + "->" + resolvedField.getName());
                    fieldReference.replace((PsiElement)Objects.requireNonNull(referenceToFieldInFromClass));
                }
                accessedFieldsFromTargetClass.set((Object)true);
            }
        }
    }

    public Method @NotNull [] findOrCreateSetters(@NotNull PhpAccessorsGenerator accessorsGenerator, boolean fieldIsPublic) {
        if (accessorsGenerator == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(11);
        }
        Method[] setters = accessorsGenerator.findSetters();
        if (!fieldIsPublic && this.myGenerateAccessors && setters.length == 0) {
            PhpAccessorMethodData[] generatorSetters = accessorsGenerator.createSetters(false, false);
            PhpCodeEditUtil.insertClassMemberWithPhpDoc(generatorSetters[0].getTargetClass(), (PsiElement)generatorSetters[0].getMethod(), generatorSetters[0].getDocComment());
            setters = accessorsGenerator.findSetters();
        }
        if (setters == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(12);
        }
        return setters;
    }

    @NotNull
    private String generateFieldName(PhpCodeStyleSettings settings, @NotNull String name) {
        String generatedDelegateName;
        if (name == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(13);
        }
        String string = (generatedDelegateName = (String)ContainerUtil.getFirstItem((List)PhpNameStyle.DECAPITALIZE.withStyle(settings.VARIABLE_NAMING_STYLE).generateNames(PhpNameUtil.splitName(name)))) != null ? generatedDelegateName : this.myTargetClassName;
        if (string == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(14);
        }
        return string;
    }

    private void createDelegateField(String delegateName, boolean createInitialClassReference) {
        Object constructorBody;
        Method classConstructor;
        if (PhpExtractMembersToClassConflicts.hasDynamicMembers(this.mySelectedMembersList) && (classConstructor = PhpIntroduceFieldHandler.getOrCreateConstructor(this.myContainingClass)) != null && (constructorBody = PhpPsiUtil.getChildByCondition((PsiElement)classConstructor, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF)) != null) {
            constructorBody.addBefore((PsiElement)PhpPsiElementFactory.createStatement(this.myProject, "$this->" + delegateName + " = new " + Objects.requireNonNull(this.myTargetClass).getName() + "(" + (createInitialClassReference ? "$this" : "") + ");"), constructorBody.getLastChild());
        }
        this.createFieldInClass(Objects.requireNonNull(this.myTargetClass).getName(), delegateName, this.myContainingClass, true);
    }

    private void createFieldInClass(String fieldType, String delegateName, PhpClass targetClass, boolean createDocTypeAnnotation) {
        PhpPsiElement delegateField;
        PhpDocComment phpDocTypeAnnotation = null;
        if (PhpLanguageFeature.TYPED_PROPERTIES.isSupported(this.myProject)) {
            delegateField = this.createDelegateFieldDeclaration(delegateName, fieldType);
        } else {
            delegateField = this.createDelegateFieldDeclaration(delegateName, null);
            if (createDocTypeAnnotation) {
                phpDocTypeAnnotation = PhpPsiElementFactory.createPhpPsiFromText(this.myProject, PhpDocComment.class, "<?php /** @var " + fieldType + "*/");
            }
        }
        PhpCodeEditUtil.insertClassMemberWithPhpDoc(targetClass, (PsiElement)delegateField, phpDocTypeAnnotation);
    }

    @NotNull
    private PhpPsiElement createDelegateFieldDeclaration(String delegateName, String type) {
        PhpPsiElement phpPsiElement = PhpPsiElementFactory.createClassField(this.myProject, PhpModifier.PRIVATE_IMPLEMENTED_DYNAMIC, false, delegateName, null, type);
        if (phpPsiElement == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(15);
        }
        return phpPsiElement;
    }

    private void replaceWithDelegatedConstantReference(@NotNull ClassConstantReference constantReference) {
        if (constantReference == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(16);
        }
        constantReference.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(constantReference.getProject(), ClassConstantReference.class, Objects.requireNonNull(this.myTargetClass).getName() + "::" + constantReference.getName()));
    }

    private void replaceWithDynamicDelegationAccess(@NotNull String delegateName, @NotNull FieldReference fieldReference) {
        PhpExpression classReference;
        if (delegateName == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(17);
        }
        if (fieldReference == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(18);
        }
        if ((classReference = fieldReference.getClassReference()) != null) {
            classReference.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(this.myProject, FieldReference.class, classReference.getText() + "->" + delegateName));
        }
    }

    static boolean isInsideMovedMember(PsiElement usageElement, @NotNull List<PhpClassMember> membersList) {
        if (membersList == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(19);
        }
        for (PhpClassMember member : membersList) {
            if (!PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)usageElement, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void replaceWithMethodDelegation(String delegateName, Method method) {
        GroupStatement body = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        assert (body != null);
        String dynamicReferenceText = "$this->" + delegateName + "->" + method.getName();
        String staticReferenceTest = Objects.requireNonNull(this.myTargetClass).getName() + "::" + method.getName();
        GroupStatement groupStatement = this.calculateDelegatedMethodBody(method, dynamicReferenceText, staticReferenceTest);
        Function function = (Function)PhpPsiUtil.getChildByCondition((PsiElement)groupStatement, (Condition<? super PsiElement>)Function.INSTANCEOF);
        GroupStatement methodDelegation = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        body.replace((PsiElement)Objects.requireNonNull(methodDelegation));
    }

    @NotNull
    private GroupStatement calculateDelegatedMethodBody(Method method, String dynamicReferenceText, String staticReferenceTest) {
        PhpType type = PhpDocUtil.getReturnType((Function)method);
        GroupStatement groupStatement = PhpPsiElementFactory.createPhpPsiFromText(this.myProject, GroupStatement.class, "function f(){ \n" + (type.equals((Object)PhpType.VOID) ? "" : "return ") + (method.getModifier().isStatic() ? staticReferenceTest : dynamicReferenceText) + "(" + Arrays.stream(method.getParameters()).map(e -> "$" + e.getName()).collect(Collectors.joining(",")) + ");}");
        if (groupStatement == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(20);
        }
        return groupStatement;
    }

    private PsiElement processFieldDeclaration(Field field) {
        PsiElement fieldList = PhpMoveClassMemberBase.getFieldListElement(field);
        boolean isSingleFieldList = PhpMoveClassMemberBase.isSingleFieldList(Objects.requireNonNull(fieldList));
        PhpDocComment commentToInsert = isSingleFieldList ? field.getDocComment() : null;
        PsiElement insertedField = PhpCodeEditUtil.insertClassMemberWithPhpDoc(Objects.requireNonNull(this.myTargetClass), (PsiElement)PhpMoveClassMemberBase.constructField(field, false, false), commentToInsert);
        if (isSingleFieldList) {
            if (commentToInsert != null) {
                commentToInsert.delete();
            }
            fieldList.delete();
        } else {
            field.delete();
        }
        return insertedField;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(21);
        }
        return new UsageViewDescriptor(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(PhpExtractMembersToClassProcessor.this.mySelectedMembersList);
                if (psiElementArray == null) {
                    3.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return PhpBundle.message("refactoring.extract.class.extracting.from.class", new Object[0]);
            }

            @NotNull
            public String getCodeReferencesText(int usagesCount, int filesCount) {
                String string = PhpBundle.message("refactoring.make.method.static.references.to.be.changed", UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount));
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/refactoring/extractClass/PhpExtractMembersToClassProcessor$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElements";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCodeReferencesText";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray = (UsageInfo[])this.mySelectedMembersList.stream().flatMap(e -> ReferencesSearch.search((PsiElement)e).findAll().stream()).map(e -> new UsageInfo(e)).toArray(UsageInfo[]::new);
        if (usageInfoArray == null) {
            PhpExtractMembersToClassProcessor.$$$reportNull$$$0(22);
        }
        return usageInfoArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14, 15, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfoList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCreationInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedField";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessedFieldsFromTargetClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorsGenerator";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractClass/PhpExtractMembersToClassProcessor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantReference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersList";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractClass/PhpExtractMembersToClassProcessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateSetters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFieldName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDelegateFieldDeclaration";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDelegatedMethodBody";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "importClassIfPossible";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processWriteAccess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateSetters";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateFieldName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithDelegatedConstantReference";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithDynamicDelegationAccess";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInsideMovedMember";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14, 15, 20, 22 -> new IllegalStateException(string);
        };
    }
}

