/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.makeStatic;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticConflicts;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticDialog;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticHandler;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticParameterInfo;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticSettings;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticSettingsBatch;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMakeStaticProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final PhpMakeStaticSettings mySettings;
    @NotNull
    private final Method myMethod;

    @ApiStatus.Internal
    public PhpMakeStaticProcessor(@NotNull Project project, @NotNull Method method, @NotNull PhpMakeStaticSettings settings) {
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(0);
        }
        if (method == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(2);
        }
        super(project);
        this.myMethod = method;
        this.mySettings = settings;
    }

    @NotNull
    public static Method doMakeStatic(final @NotNull Project project, @NotNull Method input, final @NotNull PhpMakeStaticSettings settings) {
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(3);
        }
        if (input == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(5);
        }
        if (settings.isPassedByObject()) {
            PhpMakeStaticParameterInfo[] clazz = input.getContainingClass();
            Parameter parameter = clazz != null ? PhpPsiElementFactory.createComplexParameter(project, clazz.getName() + " $" + settings.getObjectName()) : PhpPsiElementFactory.createParameter(project, settings.getObjectName());
            PhpChangeSignatureProcessor.appendParameterToParameterList((Function)input, parameter);
        }
        if (settings.isPassedByFields()) {
            for (PhpMakeStaticParameterInfo info : settings.getSelectedParameterInfos()) {
                PhpChangeSignatureProcessor.appendParameterToParameterList((Function)input, PhpPsiElementFactory.createParameter(project, info.name));
            }
        }
        PhpMakeStaticProcessor.fixDoc(project, input, settings);
        Method output = PhpMakeStaticProcessor.makeStaticMethod(project, input);
        final ArrayList fieldReferences = new ArrayList();
        output.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFieldReference(FieldReference fieldReference) {
                PhpExpression classReference = fieldReference.getClassReference();
                if (classReference != null && PhpLangUtil.isClassNameSpecial(classReference.getName())) {
                    fieldReferences.add(fieldReference);
                }
                super.visitPhpFieldReference(fieldReference);
            }

            public void visitPhpVariable(Variable variable) {
                if (settings.isPassedByObject() && variable.getName().equals("this") && settings.isPassedByObject()) {
                    variable.replace((PsiElement)PhpPsiElementFactory.createVariable(project, settings.getObjectName(), true));
                }
                super.visitPhpVariable(variable);
            }
        });
        for (FieldReference fieldReference : fieldReferences) {
            String fieldReferenceName = fieldReference.getName();
            if (fieldReferenceName == null) continue;
            PhpMakeStaticParameterInfo parameterInfo = PhpMakeStaticProcessor.findParameterInfo(fieldReferenceName, settings);
            if (parameterInfo != null) {
                fieldReference.replace((PsiElement)PhpPsiElementFactory.createVariable(fieldReference.getProject(), parameterInfo.name, true));
                continue;
            }
            if (!settings.isPassedByObject()) continue;
            fieldReference.replace((PsiElement)PhpPsiElementFactory.createFieldReference(project, settings.getObjectName(), fieldReferenceName, true));
        }
        Method method = output;
        if (method == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(6);
        }
        return method;
    }

    @NotNull
    public static Method doMakeStaticWithDefaultSettings(@NotNull Project project, @NotNull Method method, UsageInfo @NotNull [] usages) {
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(7);
        }
        if (method == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(8);
        }
        if (usages == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(9);
        }
        PhpMakeStaticSettingsBatch settings = PhpMakeStaticProcessor.createDefaultSettings(method);
        PhpMakeStaticProcessor.refactorUsages(project, usages, settings, method);
        Method method2 = (Method)method.replace((PsiElement)PhpMakeStaticProcessor.doMakeStatic(project, method, settings));
        if (method2 == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(10);
        }
        return method2;
    }

    @NotNull
    public static PhpMakeStaticSettingsBatch createDefaultSettings(@NotNull Method method) {
        if (method == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(11);
        }
        PhpMakeStaticSettingsBatch.MakeStaticSettingsBuilder settingsBuilder = new PhpMakeStaticSettingsBatch.MakeStaticSettingsBuilder().setPassedByFields(false);
        if (PhpMakeStaticHandler.processInternalUsages(method).isObjectIsNeeded()) {
            Set occupiedNames = ContainerUtil.union((Set)ContainerUtil.map2Set((Object[])method.getParameters(), Parameter::getName), (Set)ContainerUtil.map2Set((Collection)PsiTreeUtil.collectElementsOfType((PsiElement)method, (Class[])new Class[]{Variable.class}), PhpNamedElement::getName));
            settingsBuilder.setPassedByObject(true).setObjectName(PhpNameUtil.unique("instance", "", "", (Condition<? super String>)((Condition)occupiedNames::contains)));
        }
        PhpMakeStaticSettingsBatch settings = settingsBuilder.build();
        settings.setMethod(method);
        PhpMakeStaticSettingsBatch phpMakeStaticSettingsBatch = settings;
        if (phpMakeStaticSettingsBatch == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(12);
        }
        return phpMakeStaticSettingsBatch;
    }

    @NotNull
    public static Method makeStaticMethod(@NotNull Project project, @NotNull Method input) {
        PhpModifierList newModifierList;
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(13);
        }
        if (input == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(14);
        }
        PhpPsiElement modifierList = (PhpPsiElement)PhpPsiUtil.getChildByCondition((PsiElement)input, (Condition<? super PsiElement>)((Condition)PhpModifierList.class::isInstance));
        if (modifierList != null && modifierList.getTextLength() > 0 && (newModifierList = PhpPsiElementFactory.createFirstFromText(project, PhpModifierList.class, "class A {" + modifierList.getText() + " static function f(){}}")) != null) {
            modifierList.replace((PsiElement)newModifierList);
            Method method = input;
            if (method == null) {
                PhpMakeStaticProcessor.$$$reportNull$$$0(15);
            }
            return method;
        }
        Method method = PhpPsiElementFactory.createMethod(project, "static " + input.getText());
        if (method == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(16);
        }
        return method;
    }

    private static void fixDoc(@NotNull Project project, @NotNull Method input, @NotNull PhpMakeStaticSettings settings) {
        PhpDocComment docComment;
        PhpDocComment original;
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(17);
        }
        if (input == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(18);
        }
        if (settings == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(19);
        }
        if ((original = input.getDocComment()) == null && settings.isPassedByFields()) {
            docComment = PhpPsiElementFactory.createFromText(project, PhpDocComment.class, "<?php /**\n*/");
            assert (docComment != null);
            PhpCodeEditUtil.insertDocCommentBeforeAndGetTextRange((PsiElement)input, docComment);
        }
        PhpChangeSignatureUsageProcessor.fixPhpDoc((Function)input, false);
        docComment = input.getDocComment();
        PhpClass containingClass = settings.getMethod().getContainingClass();
        if (docComment != null) {
            PhpDocParamTag docParamTag;
            PhpDocParamTag tagByName = docComment.getParamTagByName(settings.getObjectName());
            if (containingClass != null && (docParamTag = PhpPsiElementFactory.createFromText(project, PhpDocParamTag.class, "/** @param " + containingClass.getName() + " $" + settings.getObjectName() + "\n")) != null && tagByName != null) {
                tagByName.replace((PsiElement)docParamTag);
            }
        }
    }

    public static PhpMakeStaticParameterInfo findParameterInfo(String fieldReferenceName, PhpMakeStaticSettings settings) {
        for (PhpMakeStaticParameterInfo it : settings.getSelectedParameterInfos()) {
            if (!it.getName().equals(fieldReferenceName)) continue;
            return it;
        }
        return null;
    }

    private static void refactorUsages(@NotNull Project project, UsageInfo @NotNull [] usages, @NotNull PhpMakeStaticSettings settings, Method method) {
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(20);
        }
        if (settings == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(21);
        }
        if (usages == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(22);
        }
        ArrayList<PhpChangeSignatureUsageProcessor.PhpChangeSignatureUsageInfo> newUsages = new ArrayList<PhpChangeSignatureUsageProcessor.PhpChangeSignatureUsageInfo>();
        PhpMethodDescriptor methodDescriptor = new PhpMethodDescriptor((Function)method);
        List<PhpParameterInfo> allParams = methodDescriptor.getParameters();
        allParams.addAll(PhpMakeStaticDialog.getAllParametersList(settings, "placeholder"));
        PhpChangeInfo phpChangeInfo = new PhpChangeInfo(methodDescriptor, allParams.toArray(new PhpParameterInfo[0]), methodDescriptor.getVisibility(), methodDescriptor.getName(), methodDescriptor.getReturnTypeText(), new HashSet<Function>(), false, false);
        for (UsageInfo it : usages) {
            PsiElement element = it.getElement();
            if (!(element instanceof MethodReference)) continue;
            MethodReference methodReference = (MethodReference)element;
            newUsages.add(PhpChangeSignatureUsageSearcher.constructCallUsageInfo((ParameterListOwner)methodReference, phpChangeInfo, false));
        }
        for (PhpChangeSignatureUsageProcessor.PhpChangeSignatureUsageInfo it : newUsages) {
            allParams = methodDescriptor.getParameters();
            PsiElement itElement = it.getElement();
            if (!(itElement instanceof MethodReference)) continue;
            MethodReference methodReference = (MethodReference)itElement;
            if (methodReference.isStatic()) {
                PhpClass containingClass = settings.getMethod().getContainingClass();
                if (containingClass != null && PhpMakeStaticProcessor.classReferenceSpecial(methodReference, containingClass)) {
                    allParams.addAll(PhpMakeStaticDialog.getAllParametersList(settings, "$this"));
                }
            } else {
                PhpExpression classReference = methodReference.getClassReference();
                if (classReference != null) {
                    allParams.addAll(PhpMakeStaticDialog.getAllParametersList(settings, classReference.getText()));
                }
            }
            it.process(new PhpChangeInfo(methodDescriptor, allParams.toArray(new PhpParameterInfo[0]), methodDescriptor.getVisibility(), methodDescriptor.getName(), methodDescriptor.getReturnTypeText(), new HashSet<Function>(), false, false), false);
            PhpMakeStaticProcessor.makeStaticCall(project, methodReference);
        }
    }

    private static boolean classReferenceSpecial(@NotNull MethodReference methodRef, @NotNull PhpClass clazz) {
        PsiElement resolvedElement;
        if (methodRef == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(23);
        }
        if (clazz == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(24);
        }
        return (resolvedElement = methodRef.resolve()) instanceof PhpClassMember && ("parent".equals(methodRef.getName()) || "self".equals(methodRef.getName()) || clazz.equals((Object)((PhpClassMember)resolvedElement).getContainingClass()));
    }

    @Nullable
    public static PsiReference getClassReference(PhpExpression classReference) {
        PhpExpression reference;
        if (classReference instanceof MemberReference && (reference = ((MemberReference)classReference).getClassReference()) != null) {
            return reference.getReference();
        }
        return null;
    }

    private static void makeStaticCall(@NotNull Project project, @NotNull MethodReference methodReference) {
        MethodReference replacement;
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(25);
        }
        if (methodReference == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(26);
        }
        if ((replacement = PhpMakeStaticProcessor.createStaticReplacement(project, methodReference)) != null) {
            methodReference.replace((PsiElement)replacement);
        }
    }

    public static Method doMakeStaticMethod(@NotNull Project project, Method method) {
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(27);
        }
        PhpMakeStaticProcessor.findReferences(method).forEach(reference -> {
            if (reference instanceof MethodReference) {
                PhpMakeStaticProcessor.makeStaticCall(project, (MethodReference)reference);
            }
        });
        return (Method)method.replace((PsiElement)PhpMakeStaticProcessor.makeStaticMethod(project, method));
    }

    public static MethodReference createStaticReplacement(@NotNull Project project, @NotNull MethodReference methodReference) {
        PsiReference reference;
        PhpExpression classReference;
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(28);
        }
        if (methodReference == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(29);
        }
        if ((classReference = methodReference.getClassReference()) != null && !(classReference instanceof MemberReference) && (reference = classReference.getReference()) != null) {
            PsiElement resolved = methodReference.resolve();
            PhpClass resolve2 = PhpPsiUtil.getParentOfClass(resolved, PhpClass.class);
            PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)methodReference);
            if (resolve2 != null) {
                PsiElement siblingIgnoreWhitespace;
                String name = resolve2.getName();
                String aliasName = null;
                if (scopeForUseOperator != null) {
                    List<PhpUseList> imports = PhpCodeInsightUtil.collectImports(scopeForUseOperator);
                    for (PhpUseList list : imports) {
                        PhpUse[] declarations;
                        for (PhpUse declaration : declarations = list.getDeclarations()) {
                            if (!PhpLangUtil.equalsClassNames(declaration.getFQN(), resolve2.getFQN())) continue;
                            name = declaration.getName();
                            aliasName = declaration.getAliasName();
                        }
                    }
                }
                if ((siblingIgnoreWhitespace = PhpPsiUtil.getNextSiblingIgnoreWhitespace(methodReference.getFirstChild(), false)) != null) {
                    String methodCallText = methodReference.getText().substring(siblingIgnoreWhitespace.getTextRange().getEndOffset() - methodReference.getTextOffset());
                    Object newMethodReferenceText = (aliasName == null ? name : aliasName) + methodCallText;
                    newMethodReferenceText = ((String)newMethodReferenceText).replaceFirst("->", "::");
                    return PhpPsiElementFactory.createMethodReference(project, (String)newMethodReferenceText);
                }
            }
        }
        return null;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(30);
        }
        return new UsageViewDescriptor(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{PhpMakeStaticProcessor.this.myMethod};
                if (psiElementArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return PhpBundle.message("refactoring.make.method.static.method.converts.method.to.static", new Object[0]);
            }

            @NotNull
            public String getCodeReferencesText(int usagesCount, int filesCount) {
                String string = PhpBundle.message("refactoring.make.method.static.references.to.be.changed", UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount));
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticProcessor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElements";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCodeReferencesText";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PsiReference reference : PhpMakeStaticProcessor.findReferences(this.myMethod)) {
            PsiElement element = reference.getElement();
            result.add(new UsageInfo(element));
        }
        UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(31);
        }
        return usageInfoArray;
    }

    @NotNull
    public static Collection<PsiReference> findReferences(@NotNull Method method) {
        if (method == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(32);
        }
        Collection<PsiReference> collection = PhpMoveMemberProcessor.findReferences((PsiElement)method);
        if (collection == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(33);
        }
        return collection;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(34);
        }
        PhpMakeStaticProcessor.refactorUsages(this.myProject, usages, this.mySettings, this.myMethod);
        Method newStaticMethod = PhpMakeStaticProcessor.doMakeStatic(this.myProject, this.myMethod, this.mySettings);
        this.myMethod.replace((PsiElement)newStaticMethod);
        PhpChangeSignatureUsageProcessor.fixPhpDoc((Function)newStaticMethod, false);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(35);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        ArrayList<PsiFile> affectedFiles = new ArrayList<PsiFile>();
        for (UsageInfo it : usages) {
            PsiElement methodReference = it.getElement();
            if (methodReference == null) continue;
            PsiFile containingFile = methodReference.getContainingFile();
            affectedFiles.add(containingFile);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myProject, affectedFiles, (boolean)true)) {
            return false;
        }
        PhpMakeStaticConflicts conflicts = new PhpMakeStaticConflicts(this.myMethod);
        conflicts.checkInternalReferences(this.myMethod, this.mySettings);
        conflicts.checkUsagesForConflicts((UsageInfo[])refUsages.get(), this.mySettings);
        conflicts.checkSettings(this.mySettings);
        conflicts.checkOverriding(this.myMethod);
        return this.showConflicts(conflicts.getConflicts(), usages);
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpBundle.message("command.name.make.method.static", new Object[0]);
        if (string == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 12, 15, 16, 31, 33, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 5: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticProcessor";
                break;
            }
            case 9: 
            case 22: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doMakeStatic";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doMakeStaticWithDefaultSettings";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultSettings";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "makeStaticMethod";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doMakeStatic";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 31: 
            case 33: 
            case 36: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doMakeStaticWithDefaultSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultSettings";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "makeStaticMethod";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fixDoc";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "refactorUsages";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "classReferenceSpecial";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "makeStaticCall";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doMakeStaticMethod";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createStaticReplacement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10, 12, 15, 16, 31, 33, 36 -> new IllegalStateException(string);
        };
    }
}

