/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.clazz;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.move.PhpMoveDelegateBase;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassDialog;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMoveClassDelegate
extends PhpMoveDelegateBase {
    public static final String MOVE_CLASS_ID = "move.class";

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        if (elements.length == 1 && elements[0] instanceof PhpClass) {
            return targetContainer == null || super.canMove(elements, targetContainer, reference);
        }
        return false;
    }

    @Override
    public String getRefactoringName() {
        return PhpMoveClassDelegate.getRefactoringNameText();
    }

    @Override
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        if (element instanceof PhpClass && ((PhpClass)element).isAnonymous()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PhpBundle.message("refactoring.move.class.cannot.move.anonymous.class", new Object[0]), (String)PhpMoveClassDelegate.getRefactoringNameText(), null);
            return true;
        }
        return super.tryToMove(element, project, dataContext, reference, editor);
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (elements.length == 1 && elements[0] instanceof PhpClass) {
            PhpMoveRefactoringUsageCollector.triggerMoveRefactoringStarted(project, MOVE_CLASS_ID);
            PhpMoveClassDialog dialog = new PhpMoveClassDialog(project, (PhpClass)elements[0], false);
            dialog.show();
        }
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PhpMoveClassDelegate.$$$reportNull$$$0(0);
        }
        return PhpBundle.message("refactoring.move.class.action.name", new Object[0]);
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringNameText() {
        return PhpBundle.message("refactoring.move.class.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassDelegate", "getActionName"));
    }
}

