/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member.instance;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.move.member.instance.PhpMoveInstanceMethodProcessor;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import com.jetbrains.php.refactoring.ui.PhpVisibilityPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveInstanceMethodToPredefinedTargetClassDialog
extends RefactoringDialog {
    final Method myMethod;
    final PhpClass myClazz;
    final List<? extends PhpNamedElement> myVariables;
    private PhpVisibilityPanel myVisibilityPanel;
    protected JList<PhpNamedElement> myList;
    @Nullable
    private EditorTextField myParametersField;
    public static final String HELP_ID = "refactoring.moveInstMethod";
    private static final String DIMENSION_SERVICE_KEY_BASE = "#com.jetbrains.php.refactoring.move.member.instance.PhpMoveInstanceMethodDialog#";
    private final boolean myIsInvokedExplicitly;

    @Nullable
    protected String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY_BASE;
    }

    @Nullable
    protected String getHelpId() {
        return HELP_ID;
    }

    public PhpMoveInstanceMethodToPredefinedTargetClassDialog(@NotNull Method method, List<? extends PhpNamedElement> variables, boolean isInvokedExplicitly) {
        if (method == null) {
            PhpMoveInstanceMethodToPredefinedTargetClassDialog.$$$reportNull$$$0(0);
        }
        super(method.getProject(), true);
        this.myMethod = method;
        this.myClazz = this.myMethod.getContainingClass();
        this.myVariables = variables;
        this.myIsInvokedExplicitly = isInvokedExplicitly;
        this.setTitle(PhpBundle.message("refactoring.move.instance.method", new Object[0]));
        this.init();
    }

    protected void doAction() {
        String parameterName;
        PhpNamedElement targetVariable = this.myList.getSelectedValue();
        String string = parameterName = this.myParametersField != null ? this.myParametersField.getText() : null;
        if (targetVariable == null) {
            return;
        }
        PhpClass targetClass = PhpMoveInstanceMethodToPredefinedTargetClassDialog.getTargetClass(this.myProject, targetVariable);
        String visibility = this.myVisibilityPanel.getVisibility();
        assert (visibility != null);
        PhpMoveInstanceMethodProcessor processor2 = new PhpMoveInstanceMethodProcessor(this.myMethod.getProject(), this.myMethod, targetVariable, targetClass, visibility, parameterName);
        this.invokeRefactoring(processor2);
        PhpMoveRefactoringUsageCollector.triggerMoveMethodToPredefinedClassFinished(this.myProject, this.myIsInvokedExplicitly);
    }

    public void doCancelAction() {
        PhpMoveRefactoringUsageCollector.triggerMoveMethodToPredefinedClassCancelled(this.myProject, this.myIsInvokedExplicitly);
        super.doCancelAction();
    }

    public void show() {
        PhpMoveRefactoringUsageCollector.triggerMoveMethodToPredefinedClassStarted(this.myProject, this.myIsInvokedExplicitly);
        super.show();
    }

    protected static PhpClass getTargetClass(Project project, PhpNamedElement targetVariable) {
        PhpType type = targetVariable.getType().filterNull();
        Set types = type.getTypes();
        if (!types.isEmpty()) {
            String chosenType = (String)types.iterator().next();
            Collection classesByFQN = PhpIndex.getInstance((Project)project).getClassesByFQN(chosenType);
            if (!classesByFQN.isEmpty()) {
                return (PhpClass)classesByFQN.iterator().next();
            }
        }
        return null;
    }

    protected JList<PhpNamedElement> createTargetVariableChooser() {
        JBList list = new JBList((ListModel)new AbstractListModel<PhpNamedElement>(){

            @Override
            public int getSize() {
                return PhpMoveInstanceMethodToPredefinedTargetClassDialog.this.myVariables.size();
            }

            @Override
            public PhpNamedElement getElementAt(int index) {
                return PhpMoveInstanceMethodToPredefinedTargetClassDialog.this.myVariables.get(index);
            }
        });
        list.setCellRenderer(new MyListCellRenderer());
        list.setSelectionMode(0);
        list.setSelectedIndex(0);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PhpMoveInstanceMethodToPredefinedTargetClassDialog.this.updateOnChanged(this.val$list);
            }
        });
        return list;
    }

    public PhpMoveInstanceMethodToPredefinedTargetClassDialog preselectVariable(PhpNamedElement variable) {
        this.myList.setSelectedValue(variable, true);
        return this;
    }

    protected void updateOnChanged(JList<PhpNamedElement> list) {
        this.getOKAction().setEnabled(!list.getSelectionModel().isSelectionEmpty());
        PhpNamedElement selectedValue = list.getSelectedValue();
        if (selectedValue != null) {
            PhpType psiType = selectedValue.getType();
            Set types = psiType.global(this.myProject).filterNull().getTypes();
            Collection classesByFQN = PhpIndex.getInstance((Project)this.myProject).getClassesByFQN((String)types.iterator().next());
            PhpClass targetClass = !classesByFQN.isEmpty() ? (PhpClass)classesByFQN.iterator().next() : null;
            UIUtil.setEnabled((Component)((Object)this.myVisibilityPanel), (targetClass != null && !targetClass.isInterface() ? 1 : 0) != 0, (boolean)true);
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        TitledSeparator separator = new TitledSeparator();
        mainPanel.add((Component)separator, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.myList = this.createTargetVariableChooser();
        this.myList.addListSelectionListener(new ListSelectionListener(this){

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }
        });
        separator.setText(RefactoringBundle.message((String)"moveInstanceMethod.select.an.instance.parameter"));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myList);
        mainPanel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.myVisibilityPanel = PhpMoveInstanceMethodToPredefinedTargetClassDialog.createVisibilityPanel();
        mainPanel.add((Component)((Object)this.myVisibilityPanel), new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 17, 3, (Insets)JBInsets.emptyInsets(), 0, 0));
        JPanel parametersPanel = this.createParametersPanel();
        if (parametersPanel != null) {
            mainPanel.add((Component)parametersPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        }
        separator.setLabelFor(this.myList);
        this.updateOnChanged(this.myList);
        return mainPanel;
    }

    @Nullable
    private JPanel createParametersPanel() {
        final Ref toReturn = new Ref();
        toReturn.set((Object)false);
        this.myMethod.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(this){

            public void visitPhpVariable(Variable variable) {
                if (variable.getName().equals("this")) {
                    toReturn.set((Object)true);
                }
                super.visitPhpVariable(variable);
            }
        });
        if (!((Boolean)toReturn.get()).booleanValue()) {
            return null;
        }
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
        String text = PhpBundle.message("refactoring.move.instance.method.this.parameter.label", ObjectUtils.notNull((Object)this.myClazz.getName(), (Object)""));
        panel.add((Component)new TitledSeparator(text, null));
        String suggestedName = "$" + StringUtil.decapitalize((String)this.myClazz.getName());
        this.myParametersField = new EditorTextField(suggestedName, this.getProject(), (FileType)PhpFileType.INSTANCE);
        this.myParametersField.setMinimumSize(new Dimension(this.myParametersField.getPreferredSize()));
        panel.add((Component)this.myParametersField);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        return panel;
    }

    private static PhpVisibilityPanel createVisibilityPanel() {
        PhpVisibilityPanel panel = new PhpVisibilityPanel();
        panel.setVisibility("AS_IS");
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/jetbrains/php/refactoring/move/member/instance/PhpMoveInstanceMethodToPredefinedTargetClassDialog", "<init>"));
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof PhpNamedElement) {
                PhpNamedElement psiVariable = (PhpNamedElement)value;
                String text = String.valueOf(psiVariable.getType()) + " " + psiVariable.getName();
                this.setIcon(psiVariable.getIcon(0));
                this.setText(text);
            }
            return this;
        }
    }
}

