/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.codeStyle.constructor.PhpReplaceOldStyleConstructorWithNewStyleQuickFix;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpTraitUseRuleImpl;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.rename.PhpClassMemberRenameProcessor;
import com.jetbrains.php.refactoring.rename.statistics.PhpConstructorRenameUsageCollector;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMethodRenameProcessor
extends PhpClassMemberRenameProcessor {
    private static final String RENAME_TO___CONSTRUCT = "Rename to __construct";
    private static final String RENAME_CLASS = "Rename class";

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(0);
        }
        return element.isValid() && element instanceof Method && !(element instanceof PhpDocMethod) && !(element instanceof PhpTraitUseRuleImpl.TraitUseRuleRenameableFakePsiElement);
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            return element;
        }
        return PhpMethodRenameProcessor.substituteElement(element, editor, null);
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<? super PsiElement> renameCallback) {
        PsiElement substitutedElement;
        if (element == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(3);
        }
        if (renameCallback == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(4);
        }
        if ((substitutedElement = PhpMethodRenameProcessor.substituteElement(element, editor, renameCallback)) != null) {
            renameCallback.accept((Object)substitutedElement);
        }
    }

    @Nullable
    private static PsiElement substituteElement(@NotNull PsiElement element, @Nullable Editor editor, @Nullable Consumer<? super PsiElement> renameCallback) {
        Method constructor;
        Method method;
        PhpClass containingClass;
        if (element == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(5);
        }
        if ((containingClass = (method = (Method)element).getContainingClass()) != null && (constructor = containingClass.getOwnConstructor()) != null && constructor == method) {
            PsiElement elementUnderCaret = PsiDocumentManager.getInstance((Project)element.getProject()).getPsiFile(editor.getDocument()).findElementAt(editor.getCaretModel().getOffset()).getParent();
            if (elementUnderCaret instanceof ClassReference && elementUnderCaret.getParent() instanceof NewExpression) {
                Collection<? extends PhpNamedElement> elements = ClassReferenceImpl.resolveGlobal((PhpReference)elementUnderCaret, ((ClassReference)elementUnderCaret).getName(), ((ClassReference)elementUnderCaret).getNamespaceName(), true);
                return elements.size() == 1 ? (PsiElement)elements.iterator().next() : element;
            }
            if (PhpLangUtil.isNewStyleConstructor(constructor.getName())) {
                return containingClass;
            }
            if (renameCallback != null) {
                PhpMethodRenameProcessor.showPopup(constructor, containingClass, editor, renameCallback);
                return null;
            }
        }
        return element;
    }

    private static void showPopup(Method constructor, PhpClass containingClass, Editor editor, Consumer<? super PsiElement> renameCallback) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            renameCallback.accept((PsiElement)containingClass);
            return;
        }
        if (!PhpLangUtil.isNewStyleConstructor(constructor.getName())) {
            JBPopupFactory.getInstance().createPopupChooserBuilder(List.of(RENAME_TO___CONSTRUCT, RENAME_CLASS)).setItemChosenCallback(selectedValue -> {
                if (RENAME_TO___CONSTRUCT.equals(selectedValue)) {
                    WriteCommandAction.runWriteCommandAction((Project)constructor.getProject(), () -> {
                        PhpConstructorRenameUsageCollector.triggerRenameToConstructor(constructor.getProject());
                        new PhpReplaceOldStyleConstructorWithNewStyleQuickFix().fixConstructor(constructor.getProject(), constructor);
                    });
                } else if (RENAME_CLASS.equals(selectedValue)) {
                    PhpConstructorRenameUsageCollector.triggerRenameClass(constructor.getProject());
                    renameCallback.accept((PsiElement)containingClass);
                }
            }).setTitle(PhpBundle.message("rename.constructor", new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).createPopup().showInBestPositionFor(editor);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        PhpClass containingClass;
        if (element == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(7);
        }
        if (conflicts == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(8);
        }
        if ((containingClass = ((Method)element).getContainingClass()) == null) {
            return;
        }
        Method conflictedMethod = containingClass.findOwnMethodByName((CharSequence)newName);
        if (conflictedMethod != null && conflictedMethod != element) {
            conflicts.putValue((Object)conflictedMethod, (Object)PhpBundle.message("conflict.method.with.same.name.already.exists", new Object[0]));
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(9);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_METHOD;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(10);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(11);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_METHOD = enabled;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpMethodRenameProcessor.$$$reportNull$$$0(12);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD = enabled;
    }

    @Override
    protected boolean isSearchInGlobalScope() {
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_GLOBAL_SCOPE_FOR_METHOD;
    }

    @Override
    protected void setSearchInGlobalScope(boolean enabled) {
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_GLOBAL_SCOPE_FOR_METHOD = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpMethodRenameProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "substituteElementToRename";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "substituteElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingNameConflicts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchInComments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchInComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

