/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.inplace;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.rename.inplace.PhpVariableInplaceRenamer;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFieldInplaceRenamer
extends MemberInplaceRenamer {
    public PhpFieldInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor) {
        if (elementToRename == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(0);
        }
        super(elementToRename, substituted, editor);
    }

    public PhpFieldInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor, String initialName, String oldName) {
        if (elementToRename == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(1);
        }
        super(elementToRename, substituted, editor, initialName, oldName);
    }

    protected boolean buildTemplateAndStart(@NotNull Collection<PsiReference> refs, @NotNull Collection<Pair<PsiElement, TextRange>> stringUsages, @NotNull PsiElement scope, @NotNull PsiFile containingFile) {
        if (refs == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(2);
        }
        if (stringUsages == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(4);
        }
        if (containingFile == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(5);
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        PsiFile myEditorFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        PsiFile file = myEditorFile != null ? myEditorFile : containingFile;
        PsiElement elementAt = file.findElementAt(offset);
        PsiReference referenceAtCaret = PhpRefactoringUtil.getReferenceAtCaret((PsiElement)file, this.myEditor);
        if (referenceAtCaret != null) {
            PsiElement refElement = referenceAtCaret.getElement();
            PhpRefactoringUtil.adjustCaretOffsetToIdentifierRange(this.myEditor, refElement, PhpRefactoringUtil.getVariableIdentifierRange(referenceAtCaret.getRangeInElement(), refElement));
        } else if (elementAt != null) {
            PhpRefactoringUtil.adjustCaretOffsetToIdentifierRange(this.myEditor, elementAt, new TextRange(0, elementAt.getTextLength()));
        }
        return super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
    }

    @Nullable
    protected PsiNamedElement getVariable() {
        PsiNamedElement restoredFakeField;
        PhpClassImpl.MyRenamableFakePsiElement fakeField = (PhpClassImpl.MyRenamableFakePsiElement)((Object)ObjectUtils.tryCast((Object)this.myElementToRename, PhpClassImpl.MyRenamableFakePsiElement.class));
        if (fakeField != null && !fakeField.isValid() && (restoredFakeField = PhpFieldInplaceRenamer.restoreFakeField(this.myProject, this.myEditor, this.myRenameOffset)) != null) {
            this.myElementToRename = restoredFakeField;
            return restoredFakeField;
        }
        return super.getVariable();
    }

    @Nullable
    private static PsiNamedElement restoreFakeField(@NotNull Project project, @NotNull Editor editor, @NotNull RangeMarker range) {
        int endOffset;
        if (project == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(7);
        }
        if (range == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(8);
        }
        if (!range.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        int startOffset = range.getStartOffset();
        FieldReference ref = (FieldReference)PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile, (int)startOffset, (int)(endOffset = range.getEndOffset()), FieldReference.class);
        if (ref == null) {
            return null;
        }
        PhpClassImpl.MyRenamableFakePsiElement element = (PhpClassImpl.MyRenamableFakePsiElement)((Object)ContainerUtil.find((Iterable)ref.multiResolveStrict(PhpClassImpl.MyRenamableFakePsiElement.class), e -> TextRange.create((int)startOffset, (int)endOffset).equals((Object)e.getTextRange())));
        return element != null && element.isValid() ? element : null;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(9);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(new TextRange(0, element.getTextLength()), element);
        if (textRange == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(11);
        }
        PsiElement element = reference.getElement();
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(reference.getRangeInElement(), element);
        if (textRange == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    protected boolean acceptReference(PsiReference reference) {
        PsiElement element = reference.getElement();
        TextRange textRange = this.getRangeToRename(reference);
        String referenceText = textRange.substring(element.getText());
        return Comparing.strEqual((String)referenceText, (String)this.myElementToRename.getName());
    }

    protected boolean isIdentifier(String newName, Language language) {
        if (this.myElementToRename instanceof Field) {
            return PhpNameUtil.isValidFieldName(newName);
        }
        return PhpLangUtil.isPhpIdentifier(newName) && !PhpLangUtil.isPhpReservedKeyword(newName);
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return new PhpFieldInplaceRenamer(variable, this.getSubstituted(), editor, initialName, this.myOldName);
    }

    protected PsiElement getSelectedInEditorElement(@Nullable PsiElement nameIdentifier, @NotNull Collection<? extends PsiReference> refs, @NotNull Collection<? extends Pair<PsiElement, TextRange>> stringUsages, int offset) {
        PsiElement element;
        if (refs == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(13);
        }
        if (stringUsages == null) {
            PhpFieldInplaceRenamer.$$$reportNull$$$0(14);
        }
        if ((element = PhpVariableInplaceRenamer.getSelectedInEditorElementInternal(nameIdentifier, refs, stringUsages, offset)) == null) {
            LOG.error(String.valueOf(nameIdentifier) + " by " + ((Object)((Object)this)).getClass().getName());
        }
        return element;
    }

    protected boolean checkRangeContainsOffset(int offset, TextRange textRange, PsiElement element, int shiftOffset) {
        return PhpVariableInplaceRenamer.checkRangeContainsOffset(offset, textRange, element, shiftOffset, this.getNameIdentifier());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/inplace/PhpFieldInplaceRenamer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/inplace/PhpFieldInplaceRenamer";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplateAndStart";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restoreFakeField";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
            case 10: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedInEditorElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12 -> new IllegalStateException(string);
        };
    }
}

