/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.safeDelete;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.extract.extractInterface.PhpExtractInterfaceProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSafeDeleteProcessorDelegate
implements SafeDeleteProcessorDelegate {
    public boolean handlesElement(@Nullable PsiElement element) {
        return (element instanceof PhpClass || element instanceof Function || element instanceof Field || element instanceof Constant) && !(element instanceof PhpDocMethod) && !(element instanceof PhpDocProperty);
    }

    @Nullable
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete, @NotNull List<? super UsageInfo> result) {
        if (element == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(0);
        }
        if (result == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(1);
        }
        if (allElementsToDelete == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(2);
        }
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element, result, (PsiElement[])allElementsToDelete, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject()));
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element);
    }

    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete) {
        if (element == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(3);
        }
        if (allElementsToDelete == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(4);
        }
        return Collections.singletonList(element);
    }

    public void prepareForDeletion(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(5);
        }
        if (element instanceof PhpClass) {
            PhpExtractInterfaceProcessor.deleteComment((PhpNamedElement)element);
        } else if (element instanceof PhpClassMember) {
            PhpMoveClassMemberBase.removeMembers(Collections.singletonList((PhpClassMember)element), true);
        } else if (element instanceof Function) {
            PhpMoveClassMemberBase.removeFunctionWithPhpDoc((Function)element);
        } else if (element instanceof Constant) {
            PhpCodeEditUtil.removeStatementWithDelivery(element, PhpTokenTypes.opCOMMA);
        }
    }

    @Nullable
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(6);
        }
        if (allElementsToDelete == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(7);
        }
        if (element instanceof PhpClass) {
            PhpClass phpClass = (PhpClass)element;
            ArrayList<PsiElement> members = new ArrayList<PsiElement>();
            ContainerUtil.addAll(members, (Object[])phpClass.getOwnMethods());
            ContainerUtil.addAll(members, (Object[])phpClass.getOwnFields());
            return members;
        }
        return null;
    }

    public Collection<String> findConflicts(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete) {
        if (element == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(8);
        }
        if (allElementsToDelete == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(9);
        }
        return null;
    }

    public UsageInfo[] preprocessUsages(@NotNull Project project, UsageInfo @NotNull [] usages) {
        if (project == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(10);
        }
        if (usages == null) {
            PhpSafeDeleteProcessorDelegate.$$$reportNull$$$0(11);
        }
        return usages;
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/safeDelete/PhpSafeDeleteProcessorDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementsToSearch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareForDeletion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findConflicts";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

