/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.restClient.guzzle;

import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.restClient.guzzle.GuzzleCallMatcher;
import com.jetbrains.php.restClient.guzzle.extractors.GuzzleMagicMethodExtractor;
import com.jetbrains.php.restClient.guzzle.extractors.GuzzleRequestExtractor;
import com.jetbrains.php.restClient.guzzle.extractors.GuzzleRequestMethodExtractor;
import com.jetbrains.php.restClient.guzzle.extractors.GuzzleSendMethodExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GuzzleRequestMatchers {
    private static final String GUZZLE_HTTP_CLIENT_TRAIT = "\\GuzzleHttp\\ClientTrait";
    private static final String GUZZLE_HTTP_CLIENT = "\\GuzzleHttp\\Client";
    private static final String GUZZLE_HTTP_CLIENT_INTERFACE = "\\GuzzleHttp\\ClientInterface";
    private static final List<GuzzleCallMapper> CALL_MAPPERS = GuzzleRequestMatchers.createCallMappers();

    GuzzleRequestMatchers() {
    }

    @NotNull
    private static List<GuzzleCallMapper> createCallMappers() {
        ArrayList<GuzzleCallMapper> mappers = new ArrayList<GuzzleCallMapper>();
        GuzzleRequestMethodExtractor requestMethodExtractor = new GuzzleRequestMethodExtractor();
        mappers.add(GuzzleRequestMatchers.mapper(requestMethodExtractor, GUZZLE_HTTP_CLIENT, "request", "requestAsync"));
        mappers.add(GuzzleRequestMatchers.mapper(requestMethodExtractor, GUZZLE_HTTP_CLIENT_INTERFACE, "request", "requestAsync"));
        GuzzleSendMethodExtractor sendMethodExtractor = new GuzzleSendMethodExtractor();
        mappers.add(GuzzleRequestMatchers.mapper(sendMethodExtractor, GUZZLE_HTTP_CLIENT, "send", "sendAsync"));
        mappers.add(GuzzleRequestMatchers.mapper(sendMethodExtractor, GUZZLE_HTTP_CLIENT_INTERFACE, "send", "sendAsync"));
        mappers.addAll(GuzzleRequestMatchers.createMagicMethodMappers(GUZZLE_HTTP_CLIENT_TRAIT));
        mappers.addAll(GuzzleRequestMatchers.createMagicMethodMappers(GUZZLE_HTTP_CLIENT));
        ArrayList<GuzzleCallMapper> arrayList = mappers;
        if (arrayList == null) {
            GuzzleRequestMatchers.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    private static List<GuzzleCallMapper> createMagicMethodMappers(@NotNull String client) {
        if (client == null) {
            GuzzleRequestMatchers.$$$reportNull$$$0(1);
        }
        List<GuzzleCallMapper> list = Arrays.asList(GuzzleRequestMatchers.mapper(new GuzzleMagicMethodExtractor("GET"), client, "get", "getAsync"), GuzzleRequestMatchers.mapper(new GuzzleMagicMethodExtractor("HEAD"), client, "head", "headAsync"), GuzzleRequestMatchers.mapper(new GuzzleMagicMethodExtractor("POST"), client, "post", "postAsync"), GuzzleRequestMatchers.mapper(new GuzzleMagicMethodExtractor("PUT"), client, "put", "putAsync"), GuzzleRequestMatchers.mapper(new GuzzleMagicMethodExtractor("DELETE"), client, "delete", "deleteAsync"), GuzzleRequestMatchers.mapper(new GuzzleMagicMethodExtractor("PATCH"), client, "patch", "patchAsync"));
        if (list == null) {
            GuzzleRequestMatchers.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public static GuzzleRequestExtractor findRequestExtractor(@Nullable MethodReference methodReference) {
        for (GuzzleCallMapper mapper : CALL_MAPPERS) {
            if (!mapper.myMatcher.matches(methodReference)) continue;
            return mapper.myExtractor;
        }
        return null;
    }

    private static GuzzleCallMapper mapper(@NotNull GuzzleRequestExtractor extractor, @NotNull String className, String ... methodNames) {
        if (extractor == null) {
            GuzzleRequestMatchers.$$$reportNull$$$0(3);
        }
        if (className == null) {
            GuzzleRequestMatchers.$$$reportNull$$$0(4);
        }
        return new GuzzleCallMapper(new GuzzleCallMatcher(className, methodNames), extractor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/restClient/guzzle/GuzzleRequestMatchers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallMappers";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/restClient/guzzle/GuzzleRequestMatchers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMagicMethodMappers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMagicMethodMappers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mapper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static final class GuzzleCallMapper {
        @NotNull
        final GuzzleCallMatcher myMatcher;
        @NotNull
        final GuzzleRequestExtractor myExtractor;

        private GuzzleCallMapper(@NotNull GuzzleCallMatcher matcher, @NotNull GuzzleRequestExtractor extractor) {
            if (matcher == null) {
                GuzzleCallMapper.$$$reportNull$$$0(0);
            }
            if (extractor == null) {
                GuzzleCallMapper.$$$reportNull$$$0(1);
            }
            this.myMatcher = matcher;
            this.myExtractor = extractor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "matcher";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extractor";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/restClient/guzzle/GuzzleRequestMatchers$GuzzleCallMapper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

