/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.filters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.run.filters.PhpFilter;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpErrorMessageFilter
extends PhpFilter {
    private static final Logger LOG = Logger.getInstance(PhpErrorMessageFilter.class);
    private static final Pattern ERROR_MESSAGE_PATTERN = Pattern.compile("in\\s((?:\\p{Alpha}:)?(?:/|\\\\)[^:]*[^.:<>/\\?\\\\]+(?:\\.[^:<>/\\?\\\\]+)?)\\son\\sline\\s(\\p{Digit}*)$");
    public static final Regex GENERALIZED_ERROR_MESSAGE_REGEX = new Regex(String.valueOf(ERROR_MESSAGE_PATTERN) + "|in\\s(?:\\p{Alpha}:)?(?:/|\\\\)[^:]*[^.:<>/\\?\\\\]+(?:\\.[^:<>/\\?\\\\]+)?:\\d*$");

    public PhpErrorMessageFilter(@NotNull Project project, @NotNull PhpPathMapper pathMapper) {
        if (project == null) {
            PhpErrorMessageFilter.$$$reportNull$$$0(0);
        }
        if (pathMapper == null) {
            PhpErrorMessageFilter.$$$reportNull$$$0(1);
        }
        super(project, pathMapper);
    }

    @Override
    public PhpFilter.MyResult applyFilter(@NotNull String line) {
        if (line == null) {
            PhpErrorMessageFilter.$$$reportNull$$$0(2);
        }
        return PhpErrorMessageFilter.apply(this.getErrorMessagePattern(), line);
    }

    @NotNull
    protected Pattern getErrorMessagePattern() {
        Pattern pattern = ERROR_MESSAGE_PATTERN;
        if (pattern == null) {
            PhpErrorMessageFilter.$$$reportNull$$$0(3);
        }
        return pattern;
    }

    @Nullable
    public static PhpFilter.MyResult apply(@NotNull String line) {
        if (line == null) {
            PhpErrorMessageFilter.$$$reportNull$$$0(4);
        }
        return PhpErrorMessageFilter.apply(ERROR_MESSAGE_PATTERN, line);
    }

    @ApiStatus.Internal
    @Nullable
    public static PhpFilter.MyResult apply(@NotNull Pattern pattern, @NotNull String line) {
        if (pattern == null) {
            PhpErrorMessageFilter.$$$reportNull$$$0(5);
        }
        if (line == null) {
            PhpErrorMessageFilter.$$$reportNull$$$0(6);
        }
        try {
            Matcher matcher = pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)1000L));
            if (matcher.find()) {
                String lineNumberString;
                String fileName = matcher.group(1);
                String string = lineNumberString = matcher.groupCount() > 1 ? matcher.group(2) : null;
                if (fileName == null) {
                    return null;
                }
                try {
                    int lineNumber = lineNumberString != null ? Integer.parseInt(lineNumberString) : -1;
                    return new PhpFilter.MyResult(fileName, lineNumber, matcher.start(1), matcher.end(lineNumberString != null ? 2 : 1));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (ProcessCanceledException e) {
            LOG.warn("Matching took too long for line: " + line);
            return null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/filters/PhpErrorMessageFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/filters/PhpErrorMessageFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

