/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.filters;

import com.intellij.openapi.project.Project;
import com.jetbrains.php.run.filters.PhpErrorMessageFilter;
import com.jetbrains.php.run.filters.PhpFilter;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.annotations.VisibleForTesting;

public class PhpFileLinkMessageFilter
extends PhpErrorMessageFilter {
    public static final Pattern FILE_PATH_PATTERN_WITH_LINE = Pattern.compile("((?:\\p{Alpha}:)?(?:/|\\\\)[^:]*[^.:<>/\\?\\\\]+(?:\\.[^:<>/\\?\\\\]+)?)(?::(\\d+))");
    @VisibleForTesting
    public static final Pattern FILE_PATH_PATTERN = Pattern.compile("((?:\\p{Alpha}:)?(?:/|\\\\)[^:]*[^.:<>/\\?\\\\]+(?:\\.[^:<>/\\?\\\\]+)?)(?::(\\d+))?");
    @Nullable
    private final @SystemIndependent @NonNls String myBasePath;

    public PhpFileLinkMessageFilter(@NotNull Project project, @NotNull PhpPathMapper pathMapper) {
        if (project == null) {
            PhpFileLinkMessageFilter.$$$reportNull$$$0(0);
        }
        if (pathMapper == null) {
            PhpFileLinkMessageFilter.$$$reportNull$$$0(1);
        }
        super(project, pathMapper);
        this.myBasePath = project.getBasePath();
    }

    @Override
    @NotNull
    protected Pattern getErrorMessagePattern() {
        Pattern pattern = FILE_PATH_PATTERN;
        if (pattern == null) {
            PhpFileLinkMessageFilter.$$$reportNull$$$0(2);
        }
        return pattern;
    }

    @Override
    public PhpFilter.MyResult applyFilter(@NotNull String line) {
        if (line == null) {
            PhpFileLinkMessageFilter.$$$reportNull$$$0(3);
        }
        if (this.myBasePath == null || !line.contains(this.myBasePath)) {
            return null;
        }
        return super.applyFilter(line);
    }

    public PhpFilter.MyResult applyRawFilterWithLineNumber(@NotNull String line) {
        if (line == null) {
            PhpFileLinkMessageFilter.$$$reportNull$$$0(4);
        }
        return PhpErrorMessageFilter.apply(FILE_PATH_PATTERN_WITH_LINE, line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/filters/PhpFileLinkMessageFilter";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/filters/PhpFileLinkMessageFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyRawFilterWithLineNumber";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

