/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.filters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.run.filters.PhpErrorMessageFilter;
import com.jetbrains.php.run.filters.PhpFilter;
import com.jetbrains.php.run.filters.PhpVarDumpClassLinkMessageFilter;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class VarDumpClassLinkMessageFilter
extends PhpErrorMessageFilter {
    @VisibleForTesting
    public static final Pattern DUMP_CLASS_PATTERN = Pattern.compile("(\"object\" => |\"nestedObject\" => |this: |class: \")([A-Za-z]+(\\\\[A-Za-z]+)+)(file|\\s|\")", 2);

    public VarDumpClassLinkMessageFilter(@NotNull Project project, @NotNull PhpPathMapper pathMapper) {
        if (project == null) {
            VarDumpClassLinkMessageFilter.$$$reportNull$$$0(0);
        }
        if (pathMapper == null) {
            VarDumpClassLinkMessageFilter.$$$reportNull$$$0(1);
        }
        super(project, pathMapper);
    }

    @Override
    @NotNull
    protected Pattern getErrorMessagePattern() {
        Pattern pattern = DUMP_CLASS_PATTERN;
        if (pattern == null) {
            VarDumpClassLinkMessageFilter.$$$reportNull$$$0(2);
        }
        return pattern;
    }

    @Override
    public PhpFilter.MyResult applyFilter(@NotNull String line) {
        Matcher matcher;
        if (line == null) {
            VarDumpClassLinkMessageFilter.$$$reportNull$$$0(3);
        }
        if ((matcher = DUMP_CLASS_PATTERN.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)1000L))).find()) {
            String fileName = matcher.group(2);
            return new PhpVarDumpClassLinkMessageFilter.PhpVarDumpClassResult(PhpLangUtil.toFQN(fileName), matcher.start(2), matcher.end(2));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/filters/VarDumpClassLinkMessageFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/filters/VarDumpClassLinkMessageFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

