/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.webApp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserReferenceConverter;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.webApp.PhpWebAppRunConfigurationEditor;
import com.jetbrains.php.util.PhpUrlUtil;
import com.jetbrains.php.util.QueryString;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class PhpWebAppRunConfiguration
extends PhpRunConfiguration<Settings> {
    public PhpWebAppRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @Override
    @NotNull
    protected Settings createSettings() {
        return new Settings();
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new PhpWebAppRunConfigurationEditor(this.getProject());
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            PhpWebAppRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            PhpWebAppRunConfiguration.$$$reportNull$$$0(1);
        }
        return new RunProfileState(){

            public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                if (runner == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpWebAppRunConfiguration.this.doExecute(QueryString.empty());
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/jetbrains/php/run/webApp/PhpWebAppRunConfiguration$1", "execute"));
            }
        };
    }

    public void doExecute(@NotNull QueryString queryString) {
        if (queryString == null) {
            PhpWebAppRunConfiguration.$$$reportNull$$$0(2);
        }
        Settings settings = (Settings)this.getSettings();
        PhpServer server = PhpProjectConfigurationFacade.getInstance(this.getProject()).findServer(settings.getServerName());
        String host = server.getHost();
        String url = PhpDebugUtil.createUrl(host, server.getPort(), settings.isHTTPS ? "https" : "http", settings.getStartUrl());
        BrowserLauncher.getInstance().browse(PhpUrlUtil.joinUrl(url, queryString), settings.getBrowser(), this.getProject());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Settings settings = (Settings)this.getSettings();
        String serverName = settings.getServerName();
        PhpServer server = PhpRunUtil.checkServerConfigurationByServerName(this.getProject(), serverName);
        String startUrl = settings.getStartUrl();
        String host = server.getHost();
        String fullStartUrl = PhpDebugUtil.createUrl(host, server.getPort(), settings.isHTTPS ? "https" : "http", startUrl);
        try {
            new URL(fullStartUrl);
        }
        catch (MalformedURLException ignored) {
            throw new RuntimeConfigurationWarning(PhpBundle.message("PhpWebAppRunConfigurationEditor.malformed.start.url", fullStartUrl));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryString";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/run/webApp/PhpWebAppRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Settings {
        private WebBrowser myBrowser;
        private String myStartUrl = "/";
        private String myServerName;
        private boolean isHTTPS = false;

        @Attribute(value="server_name")
        public String getServerName() {
            return this.myServerName;
        }

        public void setServerName(String serverName) {
            this.myServerName = serverName;
        }

        @Attribute(converter=WebBrowserReferenceConverter.class)
        public WebBrowser getBrowser() {
            return this.myBrowser;
        }

        public void setBrowser(WebBrowser browser) {
            this.myBrowser = browser;
        }

        @Attribute(value="start_url")
        public String getStartUrl() {
            return this.myStartUrl;
        }

        public void setStartUrl(String startUrl) {
            this.myStartUrl = startUrl;
        }

        @Attribute(value="is_https")
        public boolean isHTTPS() {
            return this.isHTTPS;
        }

        public void setHTTPS(boolean HTTPS) {
            this.isHTTPS = HTTPS;
        }
    }
}

