/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.webApp;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.run.webApp.PhpWebAppRunConfiguration;
import com.jetbrains.php.run.webApp.PhpWebAppRunConfigurationPanel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class PhpWebAppRunConfigurationEditor
extends SettingsEditor<PhpWebAppRunConfiguration> {
    private final BrowserSelector myBrowserSelector;
    final HyperlinkListener myHyperlinkListener;
    private final Project myProject;
    private final PhpWebAppRunConfigurationPanel content;

    public PhpWebAppRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            PhpWebAppRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myBrowserSelector = new BrowserSelector();
        this.myProject = project;
        this.content = new PhpWebAppRunConfigurationPanel(this.myBrowserSelector.getMainComponent(), (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.content.myServerComboBox);
        this.content.instructionsRow.setExpanded(PhpProjectDebugConfiguration.getInstance(project).getState().isShowPreConfigInWebPage());
        this.content.myServerComboBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpWebAppRunConfigurationEditor.this.updateResultUrl();
            }
        });
        this.content.myIsHTTPSCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpWebAppRunConfigurationEditor.this.updateResultUrl();
            }
        });
        this.content.myStartUrlTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                PhpWebAppRunConfigurationEditor.this.updateResultUrl();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/run/webApp/PhpWebAppRunConfigurationEditor$3", "textChanged"));
            }
        });
        this.myHyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserLauncher.getInstance().browse(PhpWebAppRunConfigurationEditor.this.content.myResultUrl.getOriginalText(), PhpWebAppRunConfigurationEditor.this.myBrowserSelector.getSelected(), PhpWebAppRunConfigurationEditor.this.myProject);
                }
            }
        };
        this.content.myResultUrl.addHyperlinkListener(this.myHyperlinkListener);
    }

    protected void resetEditorFrom(@NotNull PhpWebAppRunConfiguration configuration) {
        if (configuration == null) {
            PhpWebAppRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        PhpWebAppRunConfiguration.Settings settings = (PhpWebAppRunConfiguration.Settings)configuration.getSettings();
        this.content.myServerComboBox.reset(this.myProject, settings.getServerName());
        this.myBrowserSelector.setSelected(settings.getBrowser());
        this.content.myStartUrlTextField.setText(settings.getStartUrl());
        this.content.myIsHTTPSCheckBox.setSelected(settings.isHTTPS());
    }

    protected void applyEditorTo(@NotNull PhpWebAppRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            PhpWebAppRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        PhpWebAppRunConfiguration.Settings settings = (PhpWebAppRunConfiguration.Settings)configuration.getSettings();
        settings.setServerName(this.content.myServerComboBox.getSelectedServerName());
        settings.setStartUrl(this.content.myStartUrlTextField.getText().trim());
        settings.setBrowser(this.myBrowserSelector.getSelected());
        settings.setHTTPS(this.content.myIsHTTPSCheckBox.isSelected());
        PhpProjectDebugConfiguration.getInstance(this.myProject).getState().setShowPreConfigInWebPage(this.content.instructionsRow.getExpanded());
    }

    private void updateResultUrl() {
        String startUrl = this.content.myStartUrlTextField.getText();
        PhpServer selectedServer = this.content.myServerComboBox.getSelectedServer();
        if (selectedServer != null) {
            try {
                selectedServer.checkConfiguration(this.myProject);
                String host = selectedServer.getHost();
                this.content.myResultUrl.setVisible(true);
                this.content.myResultUrl.setText(PhpDebugUtil.createUrl(host, selectedServer.getPort(), this.content.myIsHTTPSCheckBox.isSelected() ? "https" : "http", startUrl));
                return;
            }
            catch (RuntimeConfigurationException runtimeConfigurationException) {
                // empty catch block
            }
        }
        this.content.myResultUrl.setVisible(false);
    }

    @NotNull
    protected JComponent createEditor() {
        DialogPanel dialogPanel = this.content.panel;
        if (dialogPanel == null) {
            PhpWebAppRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return dialogPanel;
    }

    protected void disposeEditor() {
        this.content.myResultUrl.removeHyperlinkListener(this.myHyperlinkListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/webApp/PhpWebAppRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/webApp/PhpWebAppRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

