/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.slicer;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceUsage;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.util.FontUtil;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.slicer.PhpSliceForwardUtil;
import com.jetbrains.php.slicer.PhpSliceLeafUsage;
import com.jetbrains.php.slicer.PhpSliceUtil;
import java.awt.Color;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSliceUsage
extends SliceUsage {
    public PhpSliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent) {
        if (element == null) {
            PhpSliceUsage.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            PhpSliceUsage.$$$reportNull$$$0(1);
        }
        super(element, parent);
    }

    protected PhpSliceUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        if (element == null) {
            PhpSliceUsage.$$$reportNull$$$0(2);
        }
        if (params == null) {
            PhpSliceUsage.$$$reportNull$$$0(3);
        }
        super(element, params);
    }

    protected void processUsagesFlownFromThe(PsiElement element, Processor<? super SliceUsage> uniqueProcessor) {
        PhpSliceForwardUtil.processUsagesFlownFromThe(element, uniqueProcessor, this);
    }

    protected void processUsagesFlownDownTo(PsiElement element, Processor<? super SliceUsage> uniqueProcessor) {
        PhpSliceUtil.processUsagesFlownDownTo(element, uniqueProcessor, this);
    }

    @NotNull
    protected SliceUsage copy() {
        PsiElement element = this.getUsageInfo().getElement();
        assert (element != null);
        return this.getParent() == null ? new PhpSliceUsage(element, this.params) : new PhpSliceUsage(element, this.getParent());
    }

    protected TextChunk @NotNull [] computeText() {
        TextChunk[] text = super.computeText();
        ArrayList<TextChunk> result = new ArrayList<TextChunk>();
        boolean isDereferenceUsage = this instanceof PhpSliceLeafUsage;
        for (int i = 0; i < text.length; ++i) {
            TextChunk textChunk = text[i];
            SimpleTextAttributes attributes = textChunk.getSimpleAttributesIgnoreBackground();
            if (isDereferenceUsage) {
                attributes = attributes.derive(attributes.getStyle(), (Color)JBColor.DARK_GRAY, attributes.getBgColor(), attributes.getWaveColor());
            }
            result.add(new TextChunk(attributes.toTextAttributes(), textChunk.getText()));
            if (i != 0) continue;
            result.add(new TextChunk(new TextAttributes(), FontUtil.spaceAndThinSpace()));
        }
        PsiElement element = this.getElement();
        if (element != null) {
            PhpClass aClass;
            Method method = PhpPsiUtil.getParentOfClass(element, Method.class);
            PhpClass phpClass = aClass = method == null ? PhpPsiUtil.getParentOfClass(element, PhpClass.class) : method.getContainingClass();
            String location = method != null ? PhpSliceUsage.formatMethod(method) : (aClass != null ? PhpSliceUsage.formatClass(aClass) : PhpSliceUsage.formatFile(element.getContainingFile()));
            if (location != null) {
                TextAttributes attributes = SimpleTextAttributes.GRAY_ATTRIBUTES.toTextAttributes();
                result.add(new TextChunk(attributes, PhpBundle.message("in.0", location)));
            }
        }
        TextChunk[] textChunkArray = result.toArray(TextChunk.EMPTY_ARRAY);
        if (textChunkArray == null) {
            PhpSliceUsage.$$$reportNull$$$0(4);
        }
        return textChunkArray;
    }

    @Nullable
    private static String formatFile(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    @NotNull
    private static String formatMethod(@NotNull Method method) {
        if (method == null) {
            PhpSliceUsage.$$$reportNull$$$0(5);
        }
        StringBuilder buffer = new StringBuilder();
        PhpClass aClass = method.getContainingClass();
        if (aClass != null) {
            String name = PhpSliceUsage.formatClass(aClass);
            buffer.append(name);
            buffer.append("::");
        }
        buffer.append(method.getName());
        String string = buffer.toString();
        if (string == null) {
            PhpSliceUsage.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String formatClass(@NotNull PhpClass aClass) {
        if (aClass == null) {
            PhpSliceUsage.$$$reportNull$$$0(7);
        }
        String string = aClass.getName();
        if (string == null) {
            PhpSliceUsage.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/slicer/PhpSliceUsage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/slicer/PhpSliceUsage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethod";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8 -> new IllegalStateException(string);
        };
    }
}

