/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.templates;

import com.intellij.ide.fileTemplates.DefaultTemplatePropertiesProvider;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFileTemplateUtil {
    public static final String INTERNAL_PHP_FILE_TEMPLATE_NAME = "PHP File";
    public static final String INTERNAL_PHP_CLASS_TEMPLATE_NAME = "PHP Class";
    public static final String INTERNAL_PHP_INTERFACE_TEMPLATE_NAME = "PHP Interface";
    public static final String INTERNAL_PHP_TRAIT_TEMPLATE_NAME = "PHP Trait";
    public static final String INTERNAL_PHP_ENUM_TEMPLATE_NAME = "PHP Enum";
    public static final String INTERNAL_PHPUNIT_TEST = "PHPUnit Test";
    public static final String INTERNAL_PHPUNIT6_TEST = "PHPUnit 6 Test";
    public static final String INTERNAL_PHPSPEC_SPEC = "PHPSpec Specification";
    public static final String INTERNAL_CODECEPTION_CEST_TEST = "Codeception Functional Test";
    public static final String INTERNAL_CODECEPTION_UNIT_TEST = "Codeception Unit Test";
    public static final String ATTRIBUTE_NAMESPACE = "NAMESPACE";
    public static final String ATTRIBUTE_TESTED_NAME = "TESTED_NAME";
    public static final String ATTRIBUTE_TESTED_NAMESPACE = "TESTED_NAMESPACE";
    private static FileTemplateManager templateManager;

    public static void setTemplateManager(@Nullable FileTemplateManager templateManagerArg) {
        templateManager = templateManagerArg;
    }

    public static FileTemplateManager getTestTemplateManager(Project project) {
        if (templateManager == null) {
            return FileTemplateManager.getInstance((Project)project);
        }
        return templateManager;
    }

    private PhpFileTemplateUtil() {
    }

    @Nullable
    public static PsiFile createPhpFileFromInternalTemplate(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull String templateName, @NotNull Properties properties, @NotNull String fileName) throws IOException {
        if (project == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(1);
        }
        if (templateName == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(4);
        }
        return PhpFileTemplateUtil.createPhpFileFromInternalTemplate(project, PhpFileTemplateUtil.getTestTemplateManager(project), directory, templateName, properties, fileName, "");
    }

    @Nullable
    public static PsiFile createPhpFileFromInternalTemplate(@NotNull Project project, @NotNull FileTemplateManager templateManager, @NotNull PsiDirectory directory, @NotNull String templateName, @NotNull Properties properties, @NotNull String fileName, @NotNull String content) throws IOException {
        if (project == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(5);
        }
        if (templateManager == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(6);
        }
        if (directory == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(7);
        }
        if (templateName == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(9);
        }
        if (fileName == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(10);
        }
        if (content == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(11);
        }
        FileTemplate fileTemplate = templateManager.getInternalTemplate(templateName);
        PhpFileTemplateUtil.fillDefaultProperties(templateManager, properties, directory);
        String fileTemplateText = fileTemplate.getText(properties);
        String fileText = fileTemplateText + (String)(!content.isEmpty() ? " " + content : "");
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, (Language)PhpLanguage.INSTANCE, (CharSequence)fileText, true, false);
        if (fileTemplate.isReformatCode()) {
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
        }
        return file;
    }

    public static void fillDefaultProperties(@NotNull FileTemplateManager templateManager, @NotNull Properties props, @NotNull PsiDirectory directory) {
        if (templateManager == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(12);
        }
        if (props == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(13);
        }
        if (directory == null) {
            PhpFileTemplateUtil.$$$reportNull$$$0(14);
        }
        Properties hardCodedProperties = templateManager.getDefaultProperties();
        for (Object propertyKey : hardCodedProperties.keySet()) {
            props.setProperty((String)propertyKey, hardCodedProperties.getProperty((String)propertyKey));
        }
        for (DefaultTemplatePropertiesProvider provider : DefaultTemplatePropertiesProvider.EP_NAME.getExtensionList()) {
            provider.fillProperties(directory, props);
        }
    }

    public static String[] getRegisteredPhpFileExtensions() {
        ArrayList<String> phpTypes = new ArrayList<String>();
        for (FileNameMatcher fileNameMatcher : FileTypeManager.getInstance().getAssociations((FileType)PhpFileType.INSTANCE)) {
            if (!(fileNameMatcher instanceof ExtensionFileNameMatcher)) continue;
            phpTypes.add(((ExtensionFileNameMatcher)fileNameMatcher).getExtension());
        }
        return ArrayUtilRt.toStringArray(phpTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateManager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/templates/PhpFileTemplateUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPhpFileFromInternalTemplate";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "fillDefaultProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

