/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationIml;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="configuration_by_sdk")
public class PhpTestFrameworkBySdkConfiguration
extends PhpTestFrameworkConfigurationIml
implements PhpSdkDependentConfiguration {
    @NlsSafe
    public static final String ID_PREFIX = "interpreter-";
    private String myInterpreterId;

    @Override
    @Attribute(value="interpreter_id")
    @Nullable
    @NlsSafe
    public String getInterpreterId() {
        return this.myInterpreterId;
    }

    @Override
    public void setInterpreterId(@NotNull String interpreterId) {
        if (interpreterId == null) {
            PhpTestFrameworkBySdkConfiguration.$$$reportNull$$$0(0);
        }
        this.myInterpreterId = interpreterId;
    }

    @Override
    @Transient
    public boolean isProjectLevel() {
        return PhpInterpretersManagerImpl.getInstance(null).findInterpreterById(this.getInterpreterId()) == null;
    }

    @Override
    @Nullable
    public PhpTestFrameworkConfiguration copyWithSettingsSource(@Nullable Project project) {
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance(project);
        PhpInterpreter interpreter = manager.findInterpreterById(this.getInterpreterId());
        if (interpreter == null) {
            return null;
        }
        PhpInterpreter projectLevel = interpreter.clone();
        projectLevel.setId(PhpInterpreter.getNextId());
        projectLevel.setIsProjectLevel(true);
        projectLevel.setName(manager.getUniqueName(interpreter.getName() + " (project level)"));
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreter.getName());
        if (info != null) {
            PhpInterpretersPhpInfoCacheImpl.getInstance(project).setPhpInfo(projectLevel.getName(), info);
        }
        manager.addInterpreter(projectLevel);
        PhpTestFrameworkBySdkConfiguration copy = this.copy();
        copy.setInterpreterId(projectLevel.getId());
        return copy;
    }

    @Override
    @NotNull
    @Nls
    public String getPresentableName(@Nullable Project project) {
        String name = PhpInterpretersManagerImpl.getInstance(project).findInterpreterName(this.getInterpreterId());
        if (name != null && Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            String localExecutablePath = PhpTestFrameworkBySdkConfiguration.getLocalExecutablePath(this.getImmediateExecutablePath(), this.getInterpreterId(), project);
            String string = PhpTestFrameworkBySdkConfiguration.getBaseDirRelativePath(project, localExecutablePath);
            if (string == null) {
                PhpTestFrameworkBySdkConfiguration.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = name == null ? PhpBundle.message("undefined.interpreter", new Object[0]) : name;
        if (string == null) {
            PhpTestFrameworkBySdkConfiguration.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription(@Nullable Project project) {
        return PhpTestFrameworkBySdkConfiguration.getTestFrameworkDescription(project, this.getInterpreterId());
    }

    @NotNull
    @Nls
    public static String getTestFrameworkDescription(@Nullable Project project, @Nullable String interpreterId) {
        String interpreterName = PhpInterpretersManagerImpl.getInstance(project).findInterpreterName(interpreterId);
        String string = interpreterName == null ? PhpBundle.message("php.test.framework.undefined.interpreter", new Object[0]) : PhpBundle.message("php.testframework.remote.interpreter", interpreterName);
        if (string == null) {
            PhpTestFrameworkBySdkConfiguration.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    public String getId(@Nullable Project project) {
        if (Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            String string = ID_PREFIX + this.getInterpreterId() + this.getExecutablePath();
            if (string == null) {
                PhpTestFrameworkBySdkConfiguration.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = ID_PREFIX + this.getInterpreterId();
        if (string == null) {
            PhpTestFrameworkBySdkConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    @NotNull
    public PhpTestFrameworkBySdkConfiguration copy() {
        PhpTestFrameworkBySdkConfiguration configuration = new PhpTestFrameworkBySdkConfiguration();
        configuration.myInterpreterId = this.myInterpreterId;
        this.copyTo(configuration);
        PhpTestFrameworkBySdkConfiguration phpTestFrameworkBySdkConfiguration = configuration;
        if (phpTestFrameworkBySdkConfiguration == null) {
            PhpTestFrameworkBySdkConfiguration.$$$reportNull$$$0(6);
        }
        return phpTestFrameworkBySdkConfiguration;
    }

    @Override
    protected String serialize(@Nullable String path) {
        return path;
    }

    @Override
    protected String deserialize(@Nullable String path) {
        return path;
    }

    public static String getLocalExecutablePath(@Nullable String originalPath, @Nullable String interpreterId, @Nullable Project project) {
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        if (interpreterId == null || originalPath == null || project == null || manager == null) {
            return originalPath;
        }
        PhpSdkAdditionalData interpreterData = PhpInterpretersManagerImpl.getInstance(project).findInterpreterDataById(interpreterId);
        if (!(interpreterData instanceof RemoteSdkAdditionalData)) {
            return originalPath;
        }
        PathMappingSettings pathMappings = manager.createPathMappings(project, interpreterData);
        return pathMappings.convertToLocal(originalPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkBySdkConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkBySdkConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFrameworkDescription";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

