/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.util.PhpConfigurationUtil;
import java.io.File;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="local_configuration")
public class PhpTestFrameworkConfigurationIml
implements PhpTestFrameworkConfiguration {
    @Nls
    private static final String LOCAL = PhpBundle.message("local", new Object[0]);
    @Nls
    public static final String MAIN = PhpBundle.message("php.project.configurable.composer.main", new Object[0]);
    private PhpTestFrameworkType myFrameworkType;
    private boolean myUseConfigurationFile;
    @Nullable
    private String myExecutablePath;
    @Nullable
    private String myImmediateExecutablePath;
    @Nullable
    private String myConfigurationFilePath;

    public PhpTestFrameworkConfigurationIml() {
        this.myUseConfigurationFile = false;
    }

    @Override
    public boolean isAvailable() {
        return this.myFrameworkType != null;
    }

    public PhpTestFrameworkConfigurationIml(@NotNull PhpTestFrameworkType frameworkType) {
        if (frameworkType == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(0);
        }
        this.myUseConfigurationFile = false;
        this.myFrameworkType = frameworkType;
    }

    @Override
    @NotNull
    @Nls
    public String getId(@Nullable Project project) {
        if (Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            return PhpTestFrameworkConfigurationIml.resolveId(project, LOCAL, this.getExecutablePath());
        }
        String string = LOCAL;
        if (string == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    public String getPresentableName(@Nullable Project project) {
        if (Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            return PhpTestFrameworkConfigurationIml.getBaseDirRelativePath(project, this.getImmediateExecutablePath());
        }
        String string = this.getId(project);
        if (string == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription(@Nullable Project project) {
        return PhpTestFrameworkConfigurationIml.getTestFrameworkDescription(project);
    }

    @NlsSafe
    @NotNull
    public static String getTestFrameworkDescription(@Nullable Project project) {
        if (project != null) {
            PhpInfo phpInfo;
            String interpreterName = PhpProjectConfigurationFacade.getInstance(project).getProjectConfiguration().getInterpreterName();
            PhpInfo phpInfo2 = phpInfo = interpreterName != null ? PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreterName) : null;
            if (phpInfo != null) {
                String string = PhpBundle.message("php.testframework.local.interpreter.version", phpInfo.getVersion());
                if (string == null) {
                    PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        String string = PhpBundle.message("php.testframework.local.interpreter", new Object[0]);
        if (string == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    @Transient
    public boolean isProjectLevel() {
        return true;
    }

    @Override
    @Transient
    @NotNull
    public PhpTestFrameworkType getFrameworkType() {
        PhpTestFrameworkType phpTestFrameworkType = this.myFrameworkType;
        if (phpTestFrameworkType == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(5);
        }
        return phpTestFrameworkType;
    }

    @Override
    public void setFrameworkType(@NotNull PhpTestFrameworkType type) {
        if (type == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(6);
        }
        this.myFrameworkType = type;
    }

    @Override
    @Transient
    @Nullable
    public String getExecutablePath() {
        return this.myExecutablePath;
    }

    @Override
    public void setExecutablePath(@Nullable String executable) {
        this.myExecutablePath = executable;
        this.myImmediateExecutablePath = executable;
    }

    @Override
    public void setImmediateExecutablePath(@Nullable String executable) {
        this.myImmediateExecutablePath = executable;
    }

    @Override
    @Transient
    @Nullable
    public String getImmediateExecutablePath() {
        return this.myImmediateExecutablePath;
    }

    @Attribute(value="executable_path")
    @Nullable
    public String getSerializedExecutablePath() {
        return this.serialize(this.myExecutablePath);
    }

    public void setSerializedExecutablePath(@Nullable String path) {
        this.myImmediateExecutablePath = this.myExecutablePath = this.deserialize(path);
    }

    @Override
    @Attribute(value="use_configuration_file")
    public boolean isUseConfigurationFile() {
        return this.myUseConfigurationFile;
    }

    @Override
    public void setUseConfigurationFile(boolean useConfigurationFile) {
        this.myUseConfigurationFile = useConfigurationFile;
    }

    @Override
    @Transient
    @Nullable
    public String getConfigurationFilePath() {
        return this.myConfigurationFilePath;
    }

    @Override
    public void setConfigurationFilePath(@Nullable String configurationFilePath) {
        this.myConfigurationFilePath = StringUtil.nullize((String)configurationFilePath);
    }

    @Attribute(value="configuration_file_path")
    @Nullable
    public String getSerializedConfigurationFilePath() {
        return this.serialize(this.myConfigurationFilePath);
    }

    public void setSerializedConfigurationFilePath(@Nullable String configurationFilePath) {
        this.myConfigurationFilePath = this.deserialize(configurationFilePath);
    }

    protected String serialize(@Nullable String path) {
        return PhpConfigurationUtil.serializePath(path);
    }

    protected String deserialize(@Nullable String path) {
        return PhpConfigurationUtil.deserializePath(path);
    }

    @NlsSafe
    @NotNull
    public static String getBaseDirRelativePath(@Nullable Project project, @Nullable String executablePath) {
        if (StringUtil.isEmpty((String)executablePath)) {
            String string = MAIN;
            if (string == null) {
                PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (project == null) {
            String string = executablePath;
            if (string == null) {
                PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(8);
            }
            return string;
        }
        String composerConfigPath = ComposerConfigManager.getInstance(project).getConfigPath(FileUtilRt.toSystemIndependentName((String)executablePath));
        if (StringUtil.isEmpty((String)composerConfigPath)) {
            String string = executablePath;
            if (string == null) {
                PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(9);
            }
            return string;
        }
        VirtualFile mainConfig = ComposerConfigManager.getInstance(project).getMainConfig();
        if (mainConfig == null) {
            String string = executablePath;
            if (string == null) {
                PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (mainConfig.getPath().equals(composerConfigPath)) {
            String string = MAIN;
            if (string == null) {
                PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(11);
            }
            return string;
        }
        VirtualFile composerFile = ComposerUtils.refreshAndFindFileByPath(composerConfigPath);
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (composerFile == null || projectDir == null) {
            String string = executablePath;
            if (string == null) {
                PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(12);
            }
            return string;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)composerFile.getParent(), (VirtualFile)projectDir);
        if (relativePath == null) {
            String string = executablePath;
            if (string == null) {
                PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = FileUtilRt.toSystemDependentName((String)relativePath);
        if (string == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String resolveId(@Nullable Project project, @NotNull String prefix, @Nullable String executablePath) {
        if (prefix == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(15);
        }
        String absoluteId = prefix + executablePath;
        if (project == null || executablePath == null) {
            String string = absoluteId;
            if (string == null) {
                PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(16);
            }
            return string;
        }
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir == null) {
            String string = absoluteId;
            if (string == null) {
                PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(17);
            }
            return string;
        }
        VirtualFile executableFile = LocalFileSystem.getInstance().findFileByPath(executablePath);
        if (executableFile == null) {
            String string = absoluteId;
            if (string == null) {
                PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(18);
            }
            return string;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)executableFile, (VirtualFile)projectDir);
        String string = prefix + (String)(relativePath != null ? File.separatorChar + relativePath : executablePath);
        if (string == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    @Nullable
    public PhpTestFrameworkConfiguration copyWithSettingsSource(@Nullable Project project) {
        return null;
    }

    @Override
    @NotNull
    public PhpTestFrameworkConfiguration copy() {
        PhpTestFrameworkConfigurationIml configuration = new PhpTestFrameworkConfigurationIml();
        this.copyTo(configuration);
        PhpTestFrameworkConfigurationIml phpTestFrameworkConfigurationIml = configuration;
        if (phpTestFrameworkConfigurationIml == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(20);
        }
        return phpTestFrameworkConfigurationIml;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpTestFrameworkConfigurationIml configuration = (PhpTestFrameworkConfigurationIml)o;
        if (this.myUseConfigurationFile != configuration.myUseConfigurationFile) {
            return false;
        }
        if (this.myExecutablePath != null ? !this.myExecutablePath.equals(configuration.myExecutablePath) : configuration.myExecutablePath != null) {
            return false;
        }
        return !(this.myConfigurationFilePath != null ? !this.myConfigurationFilePath.equals(configuration.myConfigurationFilePath) : configuration.myConfigurationFilePath != null);
    }

    public int hashCode() {
        int result = this.myUseConfigurationFile ? 1 : 0;
        result = 31 * result + (this.myExecutablePath != null ? this.myExecutablePath.hashCode() : 0);
        result = 31 * result + (this.myConfigurationFilePath != null ? this.myConfigurationFilePath.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkConfigurationIml";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkConfigurationIml";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFrameworkDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirRelativePath";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveId";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFrameworkType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

