/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.run;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.PhpTestFrameworksConfigurable;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestRunnerConfigurationEditor
implements PanelWithAnchor {
    private static final Logger LOG = Logger.getInstance(PhpTestRunnerConfigurationEditor.class);
    private JRadioButton myScopeTypeRadioButton;
    private JBRadioButton myScopeDirectoryRadioButton;
    private JBRadioButton myScopeFileRadioButton;
    private JBRadioButton myScopeMethodRadioButton;
    private JBRadioButton myScopeConfigFileRadioButton;
    private JPanel myTestTypePanel;
    private JComboBox<String> myTypeComboBox;
    private JPanel myTestDirectoryPanel;
    private TextFieldWithBrowseButton myDirectoryTextField;
    private JPanel myTestMethodPanel;
    private JPanel myTestFilePanel;
    private TextFieldWithBrowseButton myFileTextField;
    private TextFieldWithCompletion myMethodTextField;
    private RawCommandLineEditor myTestRunnerOptions;
    private JBLabel myTestScopeLabel;
    private JBLabel myTypeLabel;
    private JBLabel myDirectoryLabel;
    private JBLabel myMethodLabel;
    private JBLabel myFileLabel;
    private FixedSizeButton myTestRunnerOptionsHelpButton;
    private JBLabel myTestRunnerOptionsLabel;
    private JCheckBox myUseAlternativeConfigurationFileJBCheckBox;
    private TextFieldWithBrowseButton myConfigurationFileTextField;
    private FixedSizeButton myShowSettingsButton;
    private JPanel myMainPanel;
    private JPanel myMethodTextFieldWrapper;
    private boolean myInitialized = false;
    private JComponent myAnchor;
    private String myRunnerOptionsDocumentation = null;

    public PhpTestRunnerConfigurationEditor() {
        this.$$$setupUI$$$();
        this.myTestRunnerOptions.setDialogCaption(PhpBundle.message("php.test.framework.run.confuguration.ui.dialog.caption.test.runner.options", new Object[0]));
        this.myTestRunnerOptionsLabel.setLabelFor((Component)this.myTestRunnerOptions);
    }

    public void setRunnerOptionsDocumentation(@NotNull String documentation) {
        if (documentation == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myRunnerOptionsDocumentation = documentation;
        this.myTestRunnerOptionsHelpButton.setVisible(true);
    }

    @NotNull
    public TextFieldWithBrowseButton getByScope(@NotNull PhpTestRunnerSettings.Scope scope) {
        if (scope == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(1);
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = switch (scope) {
            case PhpTestRunnerSettings.Scope.Directory -> this.myDirectoryTextField;
            case PhpTestRunnerSettings.Scope.File -> this.myFileTextField;
            default -> this.myConfigurationFileTextField;
        };
        if (textFieldWithBrowseButton == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(2);
        }
        return textFieldWithBrowseButton;
    }

    public void init(final @NotNull Project project, @NotNull Map<PhpTestRunnerSettings.Scope, @Nls String> names, @NotNull TextFieldCompletionProvider methodCompletionProvider, final @NotNull PhpTestFrameworkType frameworkType, final @NotNull Supplier<String> interpreterNameSupplier) {
        if (project == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(3);
        }
        if (names == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(4);
        }
        if (methodCompletionProvider == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(5);
        }
        if (frameworkType == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(6);
        }
        if (interpreterNameSupplier == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(!this.myInitialized, (Object)"component is already initialized");
        this.myInitialized = true;
        this.myShowSettingsButton.setIcon(AllIcons.General.GearPlain);
        this.myShowSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String interpreterName = (String)interpreterNameSupplier.get();
                PhpInterpreter interpreter = interpreterName != null ? PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName) : PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
                PhpTestFrameworksConfigurable.createFix(project, frameworkType, interpreter).run();
            }
        });
        this.myShowSettingsButton.setVisible(true);
        this.myTestRunnerOptionsHelpButton.setIcon(UIUtil.getBalloonInformationIcon());
        this.myTestRunnerOptionsHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)PhpTestRunnerConfigurationEditor.this.myRunnerOptionsDocumentation);
            }
        });
        this.myTestRunnerOptionsHelpButton.setVisible(this.myRunnerOptionsDocumentation != null);
        this.renameScope(names);
        ChangeListener updateRadioButton = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                PhpTestRunnerConfigurationEditor.this.updateState();
            }
        };
        this.myScopeTypeRadioButton.addChangeListener(updateRadioButton);
        this.myScopeDirectoryRadioButton.addChangeListener(updateRadioButton);
        this.myScopeFileRadioButton.addChangeListener(updateRadioButton);
        this.myScopeMethodRadioButton.addChangeListener(updateRadioButton);
        this.myScopeConfigFileRadioButton.addChangeListener(updateRadioButton);
        this.myScopeTypeRadioButton.setVisible(false);
        ActionListener updateStateActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpTestRunnerConfigurationEditor.this.updateState();
            }
        };
        this.myDirectoryTextField.addActionListener(updateStateActionListener);
        this.myFileTextField.addActionListener(updateStateActionListener);
        this.myDirectoryTextField.addBrowseFolderListener(project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myFileTextField.addBrowseFolderListener(project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myConfigurationFileTextField.addBrowseFolderListener(project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myUseAlternativeConfigurationFileJBCheckBox.addActionListener(updateStateActionListener);
        this.myMethodTextField = new TextFieldWithCompletion(project, (TextCompletionProvider)methodCompletionProvider, "", true, true, true);
        this.myMethodTextFieldWrapper.add((Component)this.myMethodTextField);
        JBLabel longest = Stream.of(this.myTestScopeLabel, this.myDirectoryLabel, this.myFileLabel, this.myMethodLabel).max(Comparator.comparingInt(l -> l.getText().length())).orElse(this.myTestScopeLabel);
        this.setAnchor((JComponent)longest);
    }

    public void setSupportedTypes(@NotNull List<@Nls String> types) {
        if (types == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(8);
        }
        if (!types.isEmpty()) {
            for (String type : types) {
                this.myTypeComboBox.addItem(type);
            }
            this.myScopeTypeRadioButton.setVisible(true);
        }
    }

    private void renameScope(@NotNull Map<PhpTestRunnerSettings.Scope, @Nls String> names) {
        if (names == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(9);
        }
        for (Map.Entry<PhpTestRunnerSettings.Scope, String> entry : names.entrySet()) {
            String withMnemonic = UIUtil.replaceMnemonicAmpersand((String)entry.getValue());
            String label = UIUtil.removeMnemonic((String)(entry.getValue() + ":"));
            switch (entry.getKey()) {
                case Type: {
                    this.myScopeTypeRadioButton.setText(withMnemonic);
                    this.myTypeLabel.setText(label);
                    break;
                }
                case Directory: {
                    this.myScopeDirectoryRadioButton.setText(withMnemonic);
                    this.myDirectoryLabel.setText(label);
                    break;
                }
                case File: {
                    this.myScopeFileRadioButton.setText(withMnemonic);
                    this.myFileLabel.setText(label);
                    break;
                }
                case Method: {
                    this.myScopeMethodRadioButton.setText(withMnemonic);
                    this.myMethodLabel.setText(label);
                    break;
                }
                case ConfigurationFile: {
                    this.myScopeConfigFileRadioButton.setText(PhpBundle.message("php.test.framework.run.configuration.ui.custom.file.radio.button", withMnemonic));
                    this.myUseAlternativeConfigurationFileJBCheckBox.setText(PhpBundle.message("php.test.framework.run.configuration.ui.alternative.custom.file", label));
                }
            }
        }
    }

    private void updateState() {
        this.myDirectoryTextField.setEnabled(true);
        this.myFileTextField.setEnabled(true);
        if (this.myScopeTypeRadioButton.isSelected()) {
            this.setVisiblePanels(true, false, false, false);
        } else if (this.myScopeDirectoryRadioButton.isSelected()) {
            this.setVisiblePanels(false, true, false, false);
        } else if (this.myScopeFileRadioButton.isSelected()) {
            this.setVisiblePanels(false, false, true, false);
        } else if (this.myScopeMethodRadioButton.isSelected()) {
            this.setVisiblePanels(false, false, true, true);
        } else if (this.myScopeConfigFileRadioButton.isSelected()) {
            this.setVisiblePanels(false, false, false, false);
        }
        this.myConfigurationFileTextField.setEnabled(this.myUseAlternativeConfigurationFileJBCheckBox.isSelected());
    }

    private void setVisiblePanels(boolean type, boolean directory, boolean file, boolean scenario) {
        this.myTestTypePanel.setVisible(type);
        this.myTestDirectoryPanel.setVisible(directory);
        this.myTestFilePanel.setVisible(file);
        this.myTestMethodPanel.setVisible(scenario);
    }

    protected void resetEditorFrom(@NotNull PhpTestRunnerSettings testRunnerSettings) {
        if (testRunnerSettings == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(10);
        }
        JRadioButton scopeButton = switch (testRunnerSettings.getScope()) {
            default -> throw new MatchException(null, null);
            case PhpTestRunnerSettings.Scope.Type -> this.myScopeTypeRadioButton;
            case PhpTestRunnerSettings.Scope.Directory -> this.myScopeDirectoryRadioButton;
            case PhpTestRunnerSettings.Scope.File -> this.myScopeFileRadioButton;
            case PhpTestRunnerSettings.Scope.Method -> this.myScopeMethodRadioButton;
            case PhpTestRunnerSettings.Scope.ConfigurationFile -> this.myScopeConfigFileRadioButton;
        };
        scopeButton.setSelected(true);
        this.myTypeComboBox.setSelectedItem(testRunnerSettings.getSelectedType());
        this.myDirectoryTextField.setText(testRunnerSettings.getDirectoryPath());
        this.myFileTextField.setText(testRunnerSettings.getFilePath());
        this.myMethodTextField.setText(testRunnerSettings.getMethodName());
        this.myUseAlternativeConfigurationFileJBCheckBox.setSelected(testRunnerSettings.isUseAlternativeConfigurationFile());
        this.myConfigurationFileTextField.setText(testRunnerSettings.getConfigurationFilePath());
        this.myTestRunnerOptions.setText(testRunnerSettings.getTestRunnerOptions());
        this.updateState();
    }

    protected void applyEditorTo(@NotNull PhpTestRunnerSettings testRunnerSettings) throws ConfigurationException {
        if (testRunnerSettings == null) {
            PhpTestRunnerConfigurationEditor.$$$reportNull$$$0(11);
        }
        if (this.myScopeTypeRadioButton.isSelected()) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.Type);
        } else if (this.myScopeDirectoryRadioButton.isSelected()) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.Directory);
        } else if (this.myScopeFileRadioButton.isSelected()) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.File);
        } else if (this.myScopeMethodRadioButton.isSelected()) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.Method);
        } else if (this.myScopeConfigFileRadioButton.isSelected()) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.ConfigurationFile);
        }
        testRunnerSettings.setSelectedType((String)this.myTypeComboBox.getSelectedItem());
        testRunnerSettings.setDirectoryPath(this.myDirectoryTextField.getText());
        testRunnerSettings.setFilePath(this.myFileTextField.getText());
        testRunnerSettings.setMethodName(this.myMethodTextField.getText());
        testRunnerSettings.setUseAlternativeConfigurationFile(this.myUseAlternativeConfigurationFileJBCheckBox.isSelected());
        testRunnerSettings.setConfigurationFilePath(this.myConfigurationFileTextField.getText());
        testRunnerSettings.setTestRunnerOptions(this.myTestRunnerOptions.getText());
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myTestScopeLabel.setAnchor(anchor);
        this.myTypeLabel.setAnchor(anchor);
        this.myDirectoryLabel.setAnchor(anchor);
        this.myMethodLabel.setAnchor(anchor);
        this.myFileLabel.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/run/PhpTestRunnerConfigurationEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCompletionProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterNameSupplier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpTestRunnerConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getByScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRunnerOptionsDocumentation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getByScope";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSupportedTypes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renameScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        FixedSizeButton fixedSizeButton;
        RawCommandLineEditor rawCommandLineEditor;
        JBLabel jBLabel;
        FixedSizeButton fixedSizeButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel2;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBLabel jBLabel3;
        JPanel jPanel2;
        JPanel jPanel3;
        JBLabel jBLabel4;
        JPanel jPanel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JBLabel jBLabel5;
        JPanel jPanel5;
        JRadioButton jRadioButton;
        JBRadioButton jBRadioButton;
        JBLabel jBLabel6;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JBRadioButton jBRadioButton4;
        JPanel jPanel6;
        this.myMainPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.putClientProperty("html.disable", Boolean.FALSE);
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.configuration.ui.test.runner"), (int)0, (int)0, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel9.add((Component)spacer, new GridConstraints(0, 6, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myScopeDirectoryRadioButton = jBRadioButton4 = new JBRadioButton();
        jBRadioButton4.setSelected(false);
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.run.configuration.ui.directory.radio.button"));
        jPanel9.add((Component)jBRadioButton4, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myScopeFileRadioButton = jBRadioButton3 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.run.configuration.ui.file.radio.button"));
        jPanel9.add((Component)jBRadioButton3, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myScopeMethodRadioButton = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.run.configuration.ui.scenario.radio.button"));
        jPanel9.add((Component)jBRadioButton2, new GridConstraints(0, 4, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTestScopeLabel = jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.run.configuration.ui.scope"));
        jPanel9.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myScopeConfigFileRadioButton = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.run.configuration.ui.configuration.radio.button"));
        jPanel9.add((Component)jBRadioButton, new GridConstraints(0, 5, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myScopeTypeRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.run.configuration.ui.type.radio.button"));
        jPanel9.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTestDirectoryPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel5, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDirectoryLabel = jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.run.configuration.ui.directory.text.field"));
        jPanel5.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoryTextField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myTestMethodPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel4, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myMethodLabel = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.run.configuration.ui.scenario.text.field"));
        jPanel4.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMethodTextFieldWrapper = jPanel3 = new JPanel();
        jPanel3.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myTestFilePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myFileLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.run.configuration.ui.file.text.field"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileTextField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myTestTypePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTypeLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.run.configuration.ui.type.combo.box"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myTypeComboBox = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel10, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel11, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.myUseAlternativeConfigurationFileJBCheckBox = jBCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.run.configuration.ui.alternative.configuration.file"));
        jPanel11.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout(0, 0));
        jPanel11.add((Component)jPanel12, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myConfigurationFileTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel12.add((Component)textFieldWithBrowseButton, "Center");
        this.myShowSettingsButton = fixedSizeButton2 = new FixedSizeButton();
        jPanel12.add((Component)fixedSizeButton2, "East");
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel13, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myTestRunnerOptionsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestRunnerConfigurationEditor.class).getString("php.test.framework.field.test.runner.options"));
        jPanel13.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BorderLayout(0, 0));
        jPanel13.add((Component)jPanel14, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTestRunnerOptions = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel14.add((Component)rawCommandLineEditor, "Center");
        this.myTestRunnerOptionsHelpButton = fixedSizeButton = new FixedSizeButton();
        jPanel14.add((Component)fixedSizeButton, "East");
        JSeparator jSeparator = new JSeparator();
        jPanel7.add((Component)jSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 7, null, null, null));
        jBLabel2.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton4);
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

