/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.ui;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.ui.PhpConfigurableWithDescription;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PhpTestFrameworkConfigurableForm<C extends PhpTestFrameworkConfiguration>
extends PhpConfigurableWithDescription,
Configurable {
    @Nls
    default public String getDisplayName() {
        return this.getConfiguration().getFrameworkType().getDisplayName();
    }

    @Nullable
    default public String getHelpTopic() {
        return this.getConfiguration().getFrameworkType().getHelpTopic();
    }

    @NotNull
    public C getConfiguration();

    @Nullable
    public String getLastDetectedVersion();

    @Nullable
    public String getExecutablePath();

    @NotNull
    public Project getProject();

    @Override
    @Nullable
    @Nls
    default public String getDescription() {
        if (Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            C configuration = this.getConfiguration();
            String configurationDescription = configuration.getDescription(this.getProject());
            if (!this.getConfiguration().isProjectLevel()) {
                return configurationDescription + PhpBundle.message("php.test.frameworks.form.application", new Object[0]);
            }
            return configurationDescription;
        }
        if (this.getConfiguration().isProjectLevel()) {
            return PhpBundle.message("php.test.framework.project.level", new Object[0]);
        }
        return null;
    }
}

