/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.CoreFormattingService;
import com.intellij.formatting.service.FormattingService;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.tools.quality.QualityToolAnnotator;
import com.jetbrains.php.tools.quality.QualityToolBlackList;
import com.jetbrains.php.tools.quality.QualityToolReformatFile;
import com.jetbrains.php.tools.quality.QualityToolsExternalFormatterConfiguration;
import com.jetbrains.php.tools.quality.laravelPint.LaravelPintQualityToolType;
import com.jetbrains.php.tools.quality.laravelPint.LaravelPintReformatFile;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerQualityToolType;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerReformatFile;
import com.jetbrains.php.tools.quality.phpcs.PhpCSBeautifierReformatFile;
import com.jetbrains.php.tools.quality.phpcs.PhpCSQualityToolType;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QualityToolExternalFormatter
extends AsyncDocumentFormattingService {
    ProcessHandler handler;
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = NotNullLazyValue.lazy(() -> NotificationGroupManager.getInstance().getNotificationGroup("PHP External Quality Tools"));

    public boolean canFormat(@NotNull PsiFile file) {
        if (file == null) {
            QualityToolExternalFormatter.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return file instanceof PhpFile;
        }
        return file instanceof PhpFile && QualityToolExternalFormatter.isEnabled(file.getProject()) && new QualityToolAnnotator.ContextValidator().isValid((PsiElement)file);
    }

    public static boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            QualityToolExternalFormatter.$$$reportNull$$$0(1);
        }
        return QualityToolsExternalFormatterConfiguration.getInstance(project).getExternalFormatter() != QualityToolsExternalFormatterConfiguration.ExternalFormatter.NO;
    }

    private static boolean isOptimizeImportsAvailable(@NotNull PsiFile file) {
        if (file == null) {
            QualityToolExternalFormatter.$$$reportNull$$$0(2);
        }
        return !LanguageImportStatements.INSTANCE.forFile(file).isEmpty();
    }

    public static Pair<QualityToolReformatFile, QualityToolBlackList> getQualityToolReformatFileToBlackList(Project project) {
        QualityToolsExternalFormatterConfiguration.ExternalFormatter formatter = QualityToolsExternalFormatterConfiguration.getInstance(project).getExternalFormatter();
        switch (formatter) {
            case PHP_CBF: {
                return Pair.create((Object)new PhpCSBeautifierReformatFile(), (Object)PhpCSFixerQualityToolType.INSTANCE.getQualityToolBlackList(project));
            }
            case LARAVEL_PINT: {
                return Pair.create((Object)new LaravelPintReformatFile(), (Object)LaravelPintQualityToolType.INSTANCE.getQualityToolBlackList(project));
            }
            case PHP_CS_FIXER: {
                return Pair.create((Object)new PhpCSFixerReformatFile(), (Object)PhpCSFixerQualityToolType.INSTANCE.getQualityToolBlackList(project));
            }
        }
        return null;
    }

    @Nullable
    protected AsyncDocumentFormattingService.FormattingTask createFormattingTask(final @NotNull AsyncFormattingRequest formattingRequest) {
        Pair<QualityToolReformatFile, QualityToolBlackList> pair;
        if (formattingRequest == null) {
            QualityToolExternalFormatter.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        FormattingContext context = formattingRequest.getContext();
        final PsiFile file = context.getContainingFile();
        final Project project = context.getProject();
        if (QualityToolExternalFormatter.isOptimizeImportsAvailable(formattingRequest.getContext().getContainingFile())) {
            new OptimizeImportsProcessor(project, file).runWithoutProgress();
        }
        if ((pair = QualityToolExternalFormatter.getQualityToolReformatFileToBlackList(project)) == null) {
            return null;
        }
        final QualityToolReformatFile qualityToolReformatFile = (QualityToolReformatFile)pair.first;
        QualityToolBlackList blackList = (QualityToolBlackList)pair.second;
        final VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile == null || blackList.containsFile(virtualFile)) {
            return null;
        }
        if (!qualityToolReformatFile.isAvailable(project)) {
            return null;
        }
        return new AsyncDocumentFormattingService.FormattingTask(){

            public void run() {
                QualityToolExternalFormatter.this.handler = qualityToolReformatFile.getProcessHandler(project, file);
                if (QualityToolExternalFormatter.this.handler == null) {
                    qualityToolReformatFile.notifyAboutProcessCreationProblem(project);
                } else {
                    QualityToolExternalFormatter.this.handler.addProcessListener((ProcessListener)new FormatterProcessAdapter(virtualFile, QualityToolExternalFormatter.this.handler, formattingRequest, qualityToolReformatFile));
                    WriteAction.runAndWait(() -> {
                        FileDocumentManager documentManager = FileDocumentManager.getInstance();
                        Document document = documentManager.getDocument(virtualFile);
                        if (document != null) {
                            documentManager.saveDocument(document);
                        }
                    });
                    QualityToolExternalFormatter.this.handler.startNotify();
                }
            }

            public boolean cancel() {
                if (QualityToolExternalFormatter.this.handler != null) {
                    QualityToolExternalFormatter.this.handler.destroyProcess();
                }
                return true;
            }

            public boolean isRunUnderProgress() {
                return true;
            }
        };
    }

    @NotNull
    protected String getNotificationGroupId() {
        return "PHP External Quality Tools";
    }

    @NotNull
    protected String getName() {
        String string = PhpBundle.message("php.external.formatter", new Object[0]);
        if (string == null) {
            QualityToolExternalFormatter.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected boolean needToUpdate() {
        return false;
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        Set<FormattingService.Feature> set = Collections.emptySet();
        if (set == null) {
            QualityToolExternalFormatter.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public Class<? extends FormattingService> runAfter() {
        return AdvancedSettings.getBoolean((String)"php.use.internal.formatter") || ApplicationManager.getApplication().isUnitTestMode() ? CoreFormattingService.class : null;
    }

    protected AnAction[] getTimeoutActions(@NotNull FormattingContext context) {
        if (context == null) {
            QualityToolExternalFormatter.$$$reportNull$$$0(6);
        }
        Project project = context.getProject();
        return new AnAction[]{NotificationAction.createSimpleExpiring((String)PhpBundle.message("add.to.excluded.files.action", context.getContainingFile().getName()), () -> {
            QualityToolsExternalFormatterConfiguration.ExternalFormatter formatter = QualityToolsExternalFormatterConfiguration.getInstance(project).getExternalFormatter();
            if (formatter == QualityToolsExternalFormatterConfiguration.ExternalFormatter.NO || context.getVirtualFile() == null) {
                return;
            }
            QualityToolBlackList blackList = formatter == QualityToolsExternalFormatterConfiguration.ExternalFormatter.PHP_CS_FIXER ? PhpCSFixerQualityToolType.INSTANCE.getQualityToolBlackList(project) : (formatter == QualityToolsExternalFormatterConfiguration.ExternalFormatter.PHP_CBF ? PhpCSQualityToolType.INSTANCE.getQualityToolBlackList(project) : LaravelPintQualityToolType.INSTANCE.getQualityToolBlackList(project));
            blackList.addFile(context.getVirtualFile());
        }), NotificationAction.createSimpleExpiring((String)PhpBundle.message("turn.off.external.formatter", this.getName()), () -> QualityToolsExternalFormatterConfiguration.getInstance(project).setExternalFormatter(QualityToolsExternalFormatterConfiguration.ExternalFormatter.NO))};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingRequest";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolExternalFormatter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolExternalFormatter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFormat";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isOptimizeImportsAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingTask";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTimeoutActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    class FormatterProcessAdapter
    extends QualityToolReformatFile.MyProcessAdapter {
        private final AsyncFormattingRequest myRequest;
        private final QualityToolReformatFile myQualityToolReformatFile;

        FormatterProcessAdapter(VirtualFile virtualFile, ProcessHandler processHandler, AsyncFormattingRequest request, QualityToolReformatFile qualityToolReformatFile) {
            if (virtualFile == null) {
                FormatterProcessAdapter.$$$reportNull$$$0(0);
            }
            super(virtualFile, processHandler);
            this.myRequest = request;
            this.myQualityToolReformatFile = qualityToolReformatFile;
        }

        @Override
        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                FormatterProcessAdapter.$$$reportNull$$$0(1);
            }
            super.processTerminated(event);
            int exitCode = event.getExitCode();
            if (exitCode != 0 && this.myQualityToolReformatFile.reportNonZeroCodes()) {
                String text = event.getText();
                this.myRequest.onError(QualityToolExternalFormatter.this.getName(), StringUtil.isEmpty((String)text) ? PhpBundle.message("notification.content.process.exited.with.non.zero.code", new Object[0]) : text);
            } else {
                try {
                    this.myRequest.onTextReady(VfsUtilCore.loadText((VirtualFile)this.myVirtualFile));
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{this.myVirtualFile});
                }
                catch (IOException e) {
                    this.myRequest.onError(QualityToolExternalFormatter.this.getName(), PhpBundle.message("notification.content.formatter.couldn.t.apply.result.external.tool", new Object[0]));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolExternalFormatter$FormatterProcessAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

