/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpCSFixer;

import com.google.gson.JsonElement;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.tools.quality.QualityToolConfigurationManager;
import com.jetbrains.php.tools.quality.QualityToolsComposerConfig;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerConfigurationManager;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerOptionsConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerOptionsPanel;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerQualityToolType;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerRulesetAnalyzer;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerValidationInspection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PhpCSFixerComposerConfig
extends QualityToolsComposerConfig<PhpCSFixerConfiguration, PhpCSFixerValidationInspection> {
    @NonNls
    private static final String PACKAGE = "friendsofphp/php-cs-fixer";
    @NonNls
    private static final String RELATIVE_PATH = "bin/php-cs-fixer" + (SystemInfo.isWindows ? ".bat" : "");
    private static final String SEPARATOR = "=";
    @NonNls
    private static final String RULES = "--rules";
    @NonNls
    private static final String CONFIG = "--config";

    public PhpCSFixerComposerConfig() {
        super(PACKAGE, RELATIVE_PATH);
    }

    @Override
    @NotNull
    public QualityToolConfigurationManager<PhpCSFixerConfiguration> getConfigurationManager(@NotNull Project project) {
        if (project == null) {
            PhpCSFixerComposerConfig.$$$reportNull$$$0(0);
        }
        PhpCSFixerConfigurationManager phpCSFixerConfigurationManager = PhpCSFixerConfigurationManager.getInstance(project);
        if (phpCSFixerConfigurationManager == null) {
            PhpCSFixerComposerConfig.$$$reportNull$$$0(1);
        }
        return phpCSFixerConfigurationManager;
    }

    @Override
    public String getQualityInspectionShortName() {
        return PhpCSFixerQualityToolType.INSTANCE.getInspectionId();
    }

    @Override
    protected boolean applyRulesetFromRoot(@NotNull Project project) {
        if (project == null) {
            PhpCSFixerComposerConfig.$$$reportNull$$$0(2);
        }
        for (String configFileName : PhpCSFixerRulesetAnalyzer.PHP_CS_CONFIG) {
            VirtualFile customRulesetFile = this.detectCustomRulesetFile(project.getBaseDir(), configFileName);
            if (customRulesetFile == null) continue;
            String path = customRulesetFile.getPath();
            return this.modifyRulesetInspectionSetting(project, tool -> PhpCSFixerComposerConfig.applyRuleset(project, "Custom", path));
        }
        return false;
    }

    @Override
    protected boolean applyRulesetFromComposer(@NotNull Project project, PhpCSFixerConfiguration configuration) {
        VirtualFile customRulesetFile;
        if (project == null) {
            PhpCSFixerComposerConfig.$$$reportNull$$$0(3);
        }
        String configPath = ComposerDataService.getInstance(project).getConfigPath();
        VirtualFile config = LocalFileSystem.getInstance().refreshAndFindFileByPath(configPath);
        if (config == null) {
            return false;
        }
        String ruleset = this.getRuleset(config);
        if (ruleset == null) {
            return false;
        }
        List rulesetParts = StringUtil.split((String)ruleset, (String)SEPARATOR);
        if (rulesetParts.size() != 2) {
            return false;
        }
        String type = (String)rulesetParts.get(0);
        String rules = StringUtil.trimLeading((String)((String)rulesetParts.get(1)), (char)'@');
        if (StringUtil.equals((CharSequence)RULES, (CharSequence)type) && ArrayUtil.contains((String)rules, (String[])PhpCSFixerOptionsPanel.getInstalledStandards(project, configuration, null))) {
            return this.modifyRulesetInspectionSetting(project, tool -> PhpCSFixerComposerConfig.applyRuleset(project, rules, ""));
        }
        if (StringUtil.equals((CharSequence)CONFIG, (CharSequence)type) && (customRulesetFile = this.detectCustomRulesetFile(config.getParent(), rules)) != null) {
            return this.modifyRulesetInspectionSetting(project, tool -> PhpCSFixerComposerConfig.applyRuleset(project, "Custom", customRulesetFile.getPath()));
        }
        return false;
    }

    @Override
    @NotNull
    public ComposerLogMessageBuilder.Settings getSettings() {
        ComposerLogMessageBuilder.Settings settings = ComposerLogMessageBuilder.Settings.CS_FIXER;
        if (settings == null) {
            PhpCSFixerComposerConfig.$$$reportNull$$$0(4);
        }
        return settings;
    }

    private static void applyRuleset(@NotNull Project project, String codingStandard, String customRuleset) {
        if (project == null) {
            PhpCSFixerComposerConfig.$$$reportNull$$$0(5);
        }
        PhpCSFixerOptionsConfiguration configuration = PhpCSFixerOptionsConfiguration.getInstance(project);
        configuration.setRulesetPath(customRuleset);
        configuration.setCodingStandard(codingStandard);
    }

    @Override
    protected void checkComposerScriptsLeaves(JsonElement element, Ref<String> result) {
        String string = element.getAsString();
        if (string != null && string.contains("php-cs-fixer")) {
            for (String arg : StringUtil.split((String)string, (String)" ")) {
                if (!StringUtil.startsWith((CharSequence)arg, (CharSequence)CONFIG) && !StringUtil.startsWith((CharSequence)arg, (CharSequence)RULES)) continue;
                result.set((Object)arg);
            }
        }
    }

    @Override
    protected boolean checkRulesetFile(VirtualFile file) {
        return PhpCSFixerRulesetAnalyzer.isCodingStandardFile(file.getPath());
    }

    @Override
    public boolean canBeEnabled(@NotNull Project project) {
        InspectionToolWrapper tool;
        if (project == null) {
            PhpCSFixerComposerConfig.$$$reportNull$$$0(6);
        }
        if ((tool = InspectionProfileManager.getInstance((Project)project).getCurrentProfile().getInspectionTool(this.getQualityInspectionShortName(), project)) != null) {
            PhpCSFixerValidationInspection inspection = (PhpCSFixerValidationInspection)((Object)ObjectUtils.tryCast((Object)tool.getTool(), PhpCSFixerValidationInspection.class));
            return super.canBeEnabled(project) && inspection != null && !StringUtil.isEmpty((String)PhpCSFixerOptionsConfiguration.getInstance(project).getCodingStandard());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerComposerConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerComposerConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromComposer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyRuleset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBeEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

