/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpCSFixer;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolMessage;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolXmlMessageProcessor;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerQualityToolType;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerReformatFileAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PhpCSFixerMessageProcessor
extends QualityToolXmlMessageProcessor {
    @NonNls
    private static final String WARNING_MESSAGE_START = "<report";
    @NonNls
    private static final String WARNING_MESSAGE_END = "</report>";
    @NonNls
    private static final String APPLIED_FIXER = "applied_fixer";
    public static final IntentionAction REFORMAT_FILE_ACTION = new PhpCSFixerReformatFileAction();
    private static final Logger LOG = Logger.getInstance(QualityToolXmlMessageProcessor.class);
    private final Set<TextRange> lineMessages = new HashSet<TextRange>();

    protected PhpCSFixerMessageProcessor(QualityToolAnnotatorInfo<?> info) {
        super(info);
    }

    @Override
    protected void processMessage(InputSource source) throws SAXException, IOException {
        MultiLineXMLMessageHandler messageHandler = new MultiLineXMLMessageHandler();
        this.mySAXParser.parse(source, (DefaultHandler)messageHandler);
        if (messageHandler.isStatusValid()) {
            for (TextRange textRange : messageHandler.getTextRanges()) {
                QualityToolMessage qualityToolMessage = new QualityToolMessage((QualityToolMessageProcessor)this, textRange, messageHandler.getSeverity(), messageHandler.getMessageText(), this.getQuickFix(messageHandler));
                if (!this.lineMessages.add(textRange)) continue;
                this.addMessage(qualityToolMessage);
            }
        }
    }

    @Override
    protected IntentionAction @NotNull [] getQuickFix(QualityToolXmlMessageProcessor.XMLMessageHandler messageHandler) {
        IntentionAction[] intentionActionArray = new IntentionAction[]{REFORMAT_FILE_ACTION};
        if (intentionActionArray == null) {
            PhpCSFixerMessageProcessor.$$$reportNull$$$0(0);
        }
        return intentionActionArray;
    }

    @Override
    protected QualityToolXmlMessageProcessor.XMLMessageHandler getXmlMessageHandler() {
        return new MultiLineXMLMessageHandler();
    }

    @Override
    public int getMessageStart(@NotNull String line) {
        if (line == null) {
            PhpCSFixerMessageProcessor.$$$reportNull$$$0(1);
        }
        return line.indexOf(WARNING_MESSAGE_START);
    }

    @Override
    public int getMessageEnd(@NotNull String line) {
        if (line == null) {
            PhpCSFixerMessageProcessor.$$$reportNull$$$0(2);
        }
        return line.indexOf(WARNING_MESSAGE_END);
    }

    @Override
    @Nullable
    protected String getMessagePrefix() {
        return "PHP CS Fixer";
    }

    @Override
    protected QualityToolType<?> getQualityToolType() {
        return PhpCSFixerQualityToolType.INSTANCE;
    }

    @Override
    public boolean processStdErrMessages(StringBuffer error) {
        if (error.toString().contains("The rules contain risky fixers")) {
            return true;
        }
        return !error.toString().contains("Loaded config");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerMessageProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerMessageProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessageStart";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMessageEnd";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public class MultiLineXMLMessageHandler
    extends QualityToolXmlMessageProcessor.XMLMessageHandler {
        final StringBuilder myDiffBuf = new StringBuilder();

        @Override
        public void characters(char[] ch, int start, int length) {
            this.myDiffBuf.append(ch, start, length);
        }

        private TextRange createTextRange(int startLineNum, int endLineNum) {
            Document doc = PsiDocumentManager.getInstance((Project)PhpCSFixerMessageProcessor.this.getFile().getProject()).getDocument(PhpCSFixerMessageProcessor.this.getFile());
            if (doc == null) {
                return TextRange.EMPTY_RANGE;
            }
            int offset = doc.getLineEndOffset(endLineNum);
            return TextRange.create((int)doc.getLineStartOffset(startLineNum), (int)(offset < doc.getTextLength() ? offset : doc.getTextLength()));
        }

        @Override
        protected void parseTag(@NotNull String tagName, @NotNull Attributes attributes) {
            if (tagName == null) {
                MultiLineXMLMessageHandler.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                MultiLineXMLMessageHandler.$$$reportNull$$$0(1);
            }
            if (tagName.equals(PhpCSFixerMessageProcessor.APPLIED_FIXER)) {
                if (!this.myMessageBuf.isEmpty()) {
                    this.myMessageBuf.append(", ");
                }
                this.myMessageBuf.append(attributes.getValue("name"));
            }
            this.mySeverity = QualityToolMessage.Severity.WARNING;
        }

        public List<TextRange> getTextRanges() {
            ArrayList<TextRange> myTextRanges = new ArrayList<TextRange>();
            int modifiedLine = 0;
            int startModifiedLine = 0;
            boolean diffStarted = false;
            for (String line : StringUtil.splitByLines((String)this.myDiffBuf.toString(), (boolean)false)) {
                String version;
                String[] versions;
                if (StringUtil.contains((CharSequence)line, (CharSequence)"@@") && (versions = line.split("@@")).length > 1 && StringUtil.contains((CharSequence)(version = versions[1]), (CharSequence)"-") && StringUtil.contains((CharSequence)version, (CharSequence)",")) {
                    try {
                        modifiedLine = StringUtil.parseInt((String)version.substring(StringUtil.indexOf((CharSequence)version, (CharSequence)"-") + 1, StringUtil.indexOf((CharSequence)version, (CharSequence)",")), (int)0) - 1;
                        diffStarted = true;
                        continue;
                    }
                    catch (Exception e) {
                        LOG.warn("Wrong version format:" + PhpCSFixerMessageProcessor.this.getFile().getVirtualFile().getCanonicalPath());
                    }
                }
                if (!diffStarted) continue;
                if (StringUtil.startsWith((CharSequence)line, (CharSequence)"-") && startModifiedLine == 0 && modifiedLine > 0) {
                    startModifiedLine = modifiedLine;
                } else if (StringUtil.startsWith((CharSequence)line, (CharSequence)"+") && startModifiedLine != 0 && modifiedLine > 0) {
                    try {
                        myTextRanges.add(this.createTextRange(startModifiedLine, modifiedLine - 1));
                    }
                    catch (Exception e) {
                        LOG.warn("Invalid range: " + PhpCSFixerMessageProcessor.this.getFile().getVirtualFile().getCanonicalPath() + " " + e.toString());
                    }
                    startModifiedLine = 0;
                }
                if (StringUtil.startsWith((CharSequence)line, (CharSequence)"+") || StringUtil.startsWith((CharSequence)line, (CharSequence)"\\")) continue;
                ++modifiedLine;
            }
            return myTextRanges;
        }

        @Override
        public boolean isStatusValid() {
            return !this.myDiffBuf.isEmpty() && !this.myMessageBuf.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tagName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attributes";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerMessageProcessor$MultiLineXMLMessageHandler";
            objectArray[2] = "parseTag";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

