/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpCSFixer;

import com.google.gson.JsonParser;
import com.intellij.DynamicBundle;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.tools.quality.QualityToolConfigurationComboBox;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.QualityToolsOptionsPanel;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerOptionsConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerProjectConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerQualityToolType;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCSFixerOptionsPanel
extends QualityToolsOptionsPanel {
    private static final Logger LOG = Logger.getInstance(PhpCSFixerOptionsPanel.class);
    private JPanel myOptionsPanel;
    private JComboBox<String> myStandardCombo;
    private JBCheckBox myAllowRiskyRules;
    private TextFieldWithBrowseButton myCustomRulesetTextField;
    private final QualityToolConfigurationComboBox myConfigurationBox;

    public PhpCSFixerOptionsPanel(Project project, QualityToolConfigurationComboBox configurationBox, final Runnable validate) {
        super(project, validate, PhpCSFixerQualityToolType.INSTANCE);
        this.myConfigurationBox = configurationBox;
        this.$$$setupUI$$$();
        PhpCSFixerOptionsConfiguration configuration = PhpCSFixerOptionsConfiguration.getInstance(project);
        this.myAllowRiskyRules.setSelected(configuration.isAllowRiskyRules());
        this.myStandardCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PhpCSFixerOptionsPanel.this.myCustomRulesetTextField.setVisible(e.getItem().equals("Custom"));
                    PhpCSFixerOptionsPanel.this.myAllowRiskyRules.setEnabled(!e.getItem().equals("Custom"));
                }
            }
        });
        this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{configuration.getCodingStandard()}));
        this.myStandardCombo.setSelectedItem(configuration.getCodingStandard());
        this.myCustomRulesetTextField.setVisible(Objects.equals(this.myStandardCombo.getSelectedItem(), "Custom"));
        this.myCustomRulesetTextField.addActionListener(e -> {
            try {
                ActionListener action = this.createBrowserAction(project, this.myCustomRulesetTextField.getParent(), this.myCustomRulesetTextField, configurationBox, configuration.getRulesetPath());
                action.actionPerformed(e);
            }
            catch (PhpInvalidSdkTypeException ex) {
                throw new RuntimeException(ex);
            }
        });
        this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{PhpCSFixerOptionsConfiguration.getInstance(this.myProject).getCodingStandard()}));
        this.myStandardCombo.addItemListener(i -> validate.run());
        this.myCustomRulesetTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                validate.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerOptionsPanel$2", "textChanged"));
            }
        });
    }

    public void init() {
        String codingStandard = PhpCSFixerOptionsConfiguration.getInstance(this.myProject).getCodingStandard();
        try {
            PhpCSFixerConfiguration configuration = (PhpCSFixerConfiguration)PhpCSFixerProjectConfiguration.getInstance(this.myProject).findSelectedConfiguration(this.myProject, false);
            if (configuration != null) {
                Object[] installedStandards;
                if (PhpCSFixerOptionsPanel.standardsMatch(codingStandard, configuration.getStandards())) {
                    this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(configuration.getStandards()));
                    if (!StringUtil.isEmpty((String)codingStandard)) {
                        this.myStandardCombo.setSelectedItem(codingStandard);
                    }
                }
                if ((installedStandards = PhpCSFixerOptionsPanel.getInstalledStandards(this.myProject, configuration, this.getOptionsPanel())).length == 0) {
                    PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.can.not.retrieve.standards", new Object[0]), MessageType.ERROR, this.myStandardCombo);
                    return;
                }
                installedStandards = (String[])ArrayUtil.append((Object[])installedStandards, (Object)"Custom");
                configuration.setStandards((String[])installedStandards);
                String currentStandard = (String)this.myStandardCombo.getSelectedItem();
                this.myStandardCombo.setModel(new DefaultComboBoxModel<Object>(installedStandards));
                this.myStandardCombo.setSelectedItem(PhpCSFixerOptionsPanel.standardsMatch(currentStandard, (String[])installedStandards) ? currentStandard : installedStandards[0]);
                this.updated = true;
                PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.stardards.has.been.updated", new Object[0]), MessageType.INFO, this.myStandardCombo);
            } else {
                this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{codingStandard}));
            }
        }
        catch (QualityToolValidationException e) {
            this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{codingStandard}));
            PhpUiUtil.showBalloon(e.getMessage(), MessageType.ERROR, this.myStandardCombo);
        }
    }

    @Override
    @Nullable
    protected String validatePath() {
        if (Objects.equals(this.myStandardCombo.getSelectedItem(), "Custom")) {
            URL url;
            PhpInterpreter interpreter = this.getSelectedInterpreter(this.myProject, this.myConfigurationBox);
            if (interpreter != null && interpreter.isRemote()) {
                return null;
            }
            if (this.myStandardCombo.getSelectedItem().equals("Custom") && ((url = VfsUtilCore.convertToURL((String)VfsUtilCore.pathToUrl((String)this.myCustomRulesetTextField.getText()))) == null || VfsUtil.findFileByURL((URL)url) == null)) {
                return PhpBundle.message("config.file.doesnt.exist", new Object[0]);
            }
        }
        return null;
    }

    private void createUIComponents() {
    }

    private static boolean standardsMatch(String current, String[] collected) {
        if (StringUtil.isEmpty((String)current)) {
            return true;
        }
        return Arrays.asList(collected).contains(current);
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.myOptionsPanel;
    }

    @Override
    public void reset() {
        PhpCSFixerOptionsConfiguration configuration = PhpCSFixerOptionsConfiguration.getInstance(this.myProject);
        this.myAllowRiskyRules.setSelected(configuration.isAllowRiskyRules());
        this.myStandardCombo.setSelectedItem(configuration.getCodingStandard());
        this.myCustomRulesetTextField.setText(configuration.getRulesetPath());
    }

    @Override
    public boolean isModified() {
        PhpCSFixerOptionsConfiguration configuration = PhpCSFixerOptionsConfiguration.getInstance(this.myProject);
        if (this.myAllowRiskyRules.isSelected() != configuration.isAllowRiskyRules()) {
            return true;
        }
        if (!Objects.equals(this.myStandardCombo.getSelectedItem(), configuration.getCodingStandard())) {
            return true;
        }
        return !StringUtil.equals((CharSequence)this.myCustomRulesetTextField.getText(), (CharSequence)configuration.getRulesetPath());
    }

    @Override
    public void apply() {
        PhpCSFixerOptionsConfiguration configuration = PhpCSFixerOptionsConfiguration.getInstance(this.myProject);
        configuration.setAllowRiskyRules(this.myAllowRiskyRules.isSelected());
        configuration.setCodingStandard((String)this.myStandardCombo.getSelectedItem());
        configuration.setRulesetPath(this.myCustomRulesetTextField.getText());
    }

    static String @NotNull [] getInstalledStandards(@Nullable Project project, @NotNull PhpCSFixerConfiguration configuration, @Nullable JComponent component) {
        if (configuration == null) {
            PhpCSFixerOptionsPanel.$$$reportNull$$$0(0);
        }
        HashSet standards = new HashSet(20);
        String[] params = new String[]{"list-sets", "--format=json"};
        try {
            ProcessOutput output = QualityToolProcessCreator.getToolOutput(project != null ? project : ProjectManager.getInstance().getDefaultProject(), configuration.getInterpreterId(), configuration.getToolPath(), configuration.getTimeout(), PhpBundle.message("getting.installed.standards", new Object[0]), component, params);
            String jsonString = String.join((CharSequence)"", output.getStdoutLines());
            JsonParser.parseString((String)jsonString).getAsJsonObject().get("sets").getAsJsonObject().entrySet().forEach(entry -> standards.add(StringUtil.trimEnd((String)StringUtil.trimStart((String)((String)entry.getKey()), (String)"@"), (String)":risky")));
        }
        catch (Exception e) {
            LOG.debug("Failed getting installed standards for " + configuration.getToolPath(), (Throwable)e);
        }
        if (standards.isEmpty()) {
            String[] stringArray = new String[]{"PSR1", "PSR2", "Symfony", "DoctrineAnnotation", "PHP70Migration", "PHP71Migration"};
            if (stringArray == null) {
                PhpCSFixerOptionsPanel.$$$reportNull$$$0(1);
            }
            return stringArray;
        }
        String[] stringArray = (String[])standards.stream().sorted().toArray(String[]::new);
        if (stringArray == null) {
            PhpCSFixerOptionsPanel.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    public void updateStandards() {
        ApplicationManager.getApplication().invokeLater(() -> this.init());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerOptionsPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledStandards";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledStandards";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.myOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(5, 5, 0, 0), -1, -1, false, false));
        jPanel2.setAlignmentY(0.5f);
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAllowRiskyRules = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSFixerOptionsPanel.class).getString("quality.tool.cs.fixer.allow.risky.rules"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSFixerOptionsPanel.class).getString("quality.tool.cs.fixer.ruleset"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myStandardCombo = jComboBox;
        ((Component)jComboBox).setEnabled(true);
        jPanel4.add(jComboBox, "Center");
        this.myCustomRulesetTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myOptionsPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

