/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpcs;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.tools.quality.QualityToolAnnotator;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.phpcs.PhpCSCustomRulesetAnalyzer;
import com.jetbrains.php.tools.quality.phpcs.PhpCSOptionsConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSQualityToolType;
import com.jetbrains.php.tools.quality.phpcs.PhpCSValidationInspection;
import com.jetbrains.php.tools.quality.phpcs.PhpCSXmlMessageProcessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCSAnnotatorProxy
extends QualityToolAnnotator<PhpCSValidationInspection> {
    public static final PhpCSAnnotatorProxy INSTANCE = new PhpCSAnnotatorProxy();

    @Override
    protected boolean runOnTempFiles() {
        return !Registry.is((String)"php.no.temp.file");
    }

    @Override
    @NotNull
    protected List<String> getOptions(@Nullable String filePath, @NotNull PhpCSValidationInspection inspection, @Nullable InspectionProfile profile, @NotNull Project project) {
        if (inspection == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(1);
        }
        assert (filePath != null);
        @NonNls ArrayList<String> params = new ArrayList<String>();
        if (Registry.is((String)"php.no.temp.file")) {
            params.add("-");
        } else {
            params.add(filePath);
        }
        PhpCSOptionsConfiguration configuration = PhpCSOptionsConfiguration.getInstance(project);
        if (configuration.isIgnoreWarnings()) {
            params.add("-n");
        }
        if (!StringUtil.isEmpty((String)configuration.getCodingStandard())) {
            String codingStandard = configuration.getCodingStandard();
            if ("Custom".equals(codingStandard)) {
                codingStandard = PhpCSAnnotatorProxy.updateIfRemoteMappingExists(configuration.getCustomRuleset(), project, this.getQualityToolType());
            }
            params.add("--standard=" + codingStandard);
        }
        if (configuration.isUseInstalledPaths() && !StringUtil.isEmpty((String)configuration.getInstalledPaths())) {
            params.add("--runtime-set");
            params.add("installed_paths");
            params.add(configuration.getInstalledPaths());
        }
        params.add("--encoding=utf-8");
        params.add("--report=xml");
        params.add("--extensions=" + configuration.getExtensions());
        if (Registry.is((String)"php.no.temp.file")) {
            params.add("--stdin-path=" + filePath);
        }
        ArrayList<String> arrayList = params;
        if (arrayList == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    protected String getWorkingDir(@NotNull Project project, @NotNull PhpCSValidationInspection inspection) {
        if (project == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(3);
        }
        if (inspection == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(4);
        }
        PhpCSOptionsConfiguration configuration = PhpCSOptionsConfiguration.getInstance(project);
        String workingDirectory = project.getBasePath();
        if (!StringUtil.isEmpty((String)configuration.getCodingStandard()) && "Custom".equals(configuration.getCodingStandard())) {
            String rulesetPath = PhpCSAnnotatorProxy.updateIfRemoteMappingExists(configuration.getCustomRuleset(), project, this.getQualityToolType());
            workingDirectory = PhpCSCustomRulesetAnalyzer.isCodingStandardFile(rulesetPath) ? PathUtil.getParentPath((String)rulesetPath) : rulesetPath;
        }
        return workingDirectory;
    }

    @Override
    protected boolean isFileSuitable(@NotNull PsiFile file, @NotNull Project project) {
        String extension;
        if (file == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(6);
        }
        return (extension = PathUtil.getFileExtension((String)file.getVirtualFile().getPath())) != null && PhpCSOptionsConfiguration.getInstance(project).getExtensions().contains(extension);
    }

    @NotNull
    protected PhpCSQualityToolType getQualityToolType() {
        PhpCSQualityToolType phpCSQualityToolType = PhpCSQualityToolType.INSTANCE;
        if (phpCSQualityToolType == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(7);
        }
        return phpCSQualityToolType;
    }

    @Override
    protected QualityToolMessageProcessor createMessageProcessor(@NotNull QualityToolAnnotatorInfo<PhpCSValidationInspection> collectedInfo) {
        if (collectedInfo == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(8);
        }
        return new PhpCSXmlMessageProcessor(collectedInfo, PhpCSOptionsConfiguration.getInstance(collectedInfo.getProject()).isShowSniffs());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpcs/PhpCSAnnotatorProxy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpcs/PhpCSAnnotatorProxy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualityToolType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFileSuitable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createMessageProcessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }
}

