/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.debug.PhpDebugUtil;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMutableDebuggerComboBox
extends ComboBox<Pair<String, String>> {
    private static final Pair<String, String> emptyItem = Pair.create((Object)PhpBundle.message("debug.not.installed", new Object[0]), (Object)"");
    private static final List<Pair<String, String>> noItems = new SmartList(emptyItem);
    private static final Pair<String, String> xdebugItem = Pair.create((Object)PhpBundle.message("debug.xdebug", new Object[0]), (Object)"php.debugger.XDebug");
    private static final Pair<String, String> zendDebuggerItem = Pair.create((Object)PhpBundle.message("debug.zend.debugger", new Object[0]), (Object)"php.debugger.ZendDebugger");
    private Set<String> myLoadedDebuggerIds = new HashSet<String>();

    public PhpMutableDebuggerComboBox() {
        this.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", value -> (String)value.getFirst()));
        this.setModel((ComboBoxModel)new CollectionComboBoxModel(noItems));
        this.setPreferredSize(new Dimension(150, this.getPreferredSize().height));
    }

    public void updateAvailableItems(@Nullable PhpInfo info, @Nullable String selected) {
        if (info == null || info.getDebuggers().isEmpty()) {
            if (!this.myLoadedDebuggerIds.isEmpty()) {
                this.myLoadedDebuggerIds.clear();
                this.setModel((ComboBoxModel)new CollectionComboBoxModel(noItems));
            }
            return;
        }
        Set<String> ids = PhpDebugUtil.getLoadedDebuggerIds(info);
        if (!ids.equals(this.myLoadedDebuggerIds)) {
            this.myLoadedDebuggerIds = ids;
            SmartList items = new SmartList();
            for (String id : ids) {
                items.add(PhpMutableDebuggerComboBox.getItemById(id));
            }
            Pair<String, String> selectedItem = StringUtil.isNotEmpty((String)selected) && ids.contains(selected) ? PhpMutableDebuggerComboBox.getItemById(selected) : (Pair<String, String>)items.get(0);
            this.setModel((ComboBoxModel)new CollectionComboBoxModel((List)items, selectedItem));
        }
    }

    @NotNull
    private static Pair<String, String> getItemById(@NotNull String id) {
        if (id == null) {
            PhpMutableDebuggerComboBox.$$$reportNull$$$0(0);
        }
        if (StringUtil.equals((CharSequence)((CharSequence)xdebugItem.getSecond()), (CharSequence)id)) {
            Pair<String, String> pair = xdebugItem;
            if (pair == null) {
                PhpMutableDebuggerComboBox.$$$reportNull$$$0(1);
            }
            return pair;
        }
        if (StringUtil.equals((CharSequence)((CharSequence)zendDebuggerItem.getSecond()), (CharSequence)id)) {
            Pair<String, String> pair = zendDebuggerItem;
            if (pair == null) {
                PhpMutableDebuggerComboBox.$$$reportNull$$$0(2);
            }
            return pair;
        }
        assert (false);
        if (null == null) {
            PhpMutableDebuggerComboBox.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Nullable
    public String getSelectedDebuggerId() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem == null || selectedItem == emptyItem) {
            return null;
        }
        return (String)((Pair)selectedItem).getSecond();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/ui/PhpMutableDebuggerComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/ui/PhpMutableDebuggerComboBox";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemById";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItemById";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

