/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.logger;

import io.sentry.HostnameCache;
import io.sentry.IScope;
import io.sentry.ISpan;
import io.sentry.PropagationContext;
import io.sentry.Scopes;
import io.sentry.SentryDate;
import io.sentry.SentryLevel;
import io.sentry.SentryLogEvent;
import io.sentry.SentryLogEventAttributeValue;
import io.sentry.SentryLogLevel;
import io.sentry.SentryOptions;
import io.sentry.SpanId;
import io.sentry.logger.ILoggerApi;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryId;
import io.sentry.util.Platform;
import io.sentry.util.TracingUtils;
import java.util.HashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class LoggerApi
implements ILoggerApi {
    @NotNull
    private final Scopes scopes;

    public LoggerApi(@NotNull Scopes scopes) {
        this.scopes = scopes;
    }

    @Override
    public void trace(@Nullable String message, Object ... args) {
        this.log(SentryLogLevel.TRACE, message, args);
    }

    @Override
    public void debug(@Nullable String message, Object ... args) {
        this.log(SentryLogLevel.DEBUG, message, args);
    }

    @Override
    public void info(@Nullable String message, Object ... args) {
        this.log(SentryLogLevel.INFO, message, args);
    }

    @Override
    public void warn(@Nullable String message, Object ... args) {
        this.log(SentryLogLevel.WARN, message, args);
    }

    @Override
    public void error(@Nullable String message, Object ... args) {
        this.log(SentryLogLevel.ERROR, message, args);
    }

    @Override
    public void fatal(@Nullable String message, Object ... args) {
        this.log(SentryLogLevel.FATAL, message, args);
    }

    @Override
    public void log(@NotNull SentryLogLevel level, @Nullable String message, Object ... args) {
        this.log(level, null, message, args);
    }

    @Override
    public void log(@NotNull SentryLogLevel level, @Nullable SentryDate timestamp, @Nullable String message, Object ... args) {
        this.captureLog(level, timestamp, message, args);
    }

    private void captureLog(@NotNull SentryLogLevel level, @Nullable SentryDate timestamp, @Nullable String message, Object ... args) {
        @NotNull SentryOptions options = this.scopes.getOptions();
        try {
            if (!this.scopes.isEnabled()) {
                options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'logger' call is a no-op.", new Object[0]);
                return;
            }
            if (!options.getLogs().isEnabled()) {
                options.getLogger().log(SentryLevel.WARNING, "Sentry Log is disabled and this 'logger' call is a no-op.", new Object[0]);
                return;
            }
            if (message == null) {
                return;
            }
            SentryDate timestampToUse = timestamp == null ? options.getDateProvider().now() : timestamp;
            @NotNull String messageToUse = this.maybeFormatMessage(message, args);
            @NotNull IScope combinedScope = this.scopes.getCombinedScopeView();
            @NotNull PropagationContext propagationContext = combinedScope.getPropagationContext();
            @Nullable ISpan span = combinedScope.getSpan();
            if (span == null) {
                TracingUtils.maybeUpdateBaggage(combinedScope, options);
            }
            @NotNull SentryId traceId = span == null ? propagationContext.getTraceId() : span.getSpanContext().getTraceId();
            @NotNull SpanId spanId = span == null ? propagationContext.getSpanId() : span.getSpanContext().getSpanId();
            SentryLogEvent logEvent = new SentryLogEvent(traceId, timestampToUse, messageToUse, level);
            logEvent.setAttributes(this.createAttributes(message, spanId, args));
            logEvent.setSeverityNumber(level.getSeverityNumber());
            this.scopes.getClient().captureLog(logEvent, combinedScope);
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Error while capturing log event", e);
        }
    }

    @NotNull
    private String maybeFormatMessage(@NotNull String message, @Nullable Object[] args) {
        if (args == null || args.length == 0) {
            return message;
        }
        try {
            return String.format(message, args);
        }
        catch (Throwable t) {
            this.scopes.getOptions().getLogger().log(SentryLevel.ERROR, "Error while running log through String.format", t);
            return message;
        }
    }

    @NotNull
    private HashMap<String, SentryLogEventAttributeValue> createAttributes(@NotNull String message, @NotNull SpanId spanId, Object ... args) {
        String release;
        String environment;
        SdkVersion sdkVersion;
        @NotNull HashMap<String, SentryLogEventAttributeValue> attributes = new HashMap<String, SentryLogEventAttributeValue>();
        if (args != null) {
            int i = 0;
            for (Object arg : args) {
                @NotNull String type = this.getType(arg);
                attributes.put("sentry.message.parameter." + i, new SentryLogEventAttributeValue(type, arg));
                ++i;
            }
            if (i > 0) {
                attributes.put("sentry.message.template", new SentryLogEventAttributeValue("string", message));
            }
        }
        if ((sdkVersion = this.scopes.getOptions().getSdkVersion()) != null) {
            attributes.put("sentry.sdk.name", new SentryLogEventAttributeValue("string", sdkVersion.getName()));
            attributes.put("sentry.sdk.version", new SentryLogEventAttributeValue("string", sdkVersion.getVersion()));
        }
        if ((environment = this.scopes.getOptions().getEnvironment()) != null) {
            attributes.put("sentry.environment", new SentryLogEventAttributeValue("string", environment));
        }
        if ((release = this.scopes.getOptions().getRelease()) != null) {
            attributes.put("sentry.release", new SentryLogEventAttributeValue("string", release));
        }
        attributes.put("sentry.trace.parent_span_id", new SentryLogEventAttributeValue("string", spanId));
        if (Platform.isJvm()) {
            this.setServerName(attributes);
        }
        return attributes;
    }

    private void setServerName(@NotNull HashMap<String, SentryLogEventAttributeValue> attributes) {
        String hostname;
        @NotNull SentryOptions options = this.scopes.getOptions();
        @Nullable String optionsServerName = options.getServerName();
        if (optionsServerName != null) {
            attributes.put("server.address", new SentryLogEventAttributeValue("string", optionsServerName));
        } else if (options.isAttachServerName() && (hostname = HostnameCache.getInstance().getHostname()) != null) {
            attributes.put("server.address", new SentryLogEventAttributeValue("string", hostname));
        }
    }

    @NotNull
    private String getType(@Nullable Object arg) {
        if (arg instanceof Boolean) {
            return "boolean";
        }
        if (arg instanceof Integer) {
            return "integer";
        }
        if (arg instanceof Number) {
            return "double";
        }
        return "string";
    }
}

