/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.analysis;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.services.GraphGroupingService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.uml.undo.UmlUndoableAction;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DiagramAutoClusteringUndoableAction
extends BasicUndoableAction {
    @NotNull
    public static final Key<Map<DiagramNode<?>, NodeGroupDescriptor>> CURRENT_CLUSTERING_KEY = Key.create((String)"com.intellij.uml.core.actions.analysis.DiagramAutoClusteringUndoableAction.CURRENT_CLUSTERING_KEY");
    @NotNull
    private final DiagramBuilder myBuilder;
    @NotNull
    private final Map<DiagramNode<?>, NodeGroupDescriptor> myClusters;
    private final boolean myIsEnableFirst;

    DiagramAutoClusteringUndoableAction(@NotNull DiagramBuilder builder, @NotNull Map<DiagramNode<?>, NodeGroupDescriptor> clusters, boolean isEnableFirst) {
        if (builder == null) {
            DiagramAutoClusteringUndoableAction.$$$reportNull$$$0(0);
        }
        if (clusters == null) {
            DiagramAutoClusteringUndoableAction.$$$reportNull$$$0(1);
        }
        super(UmlUndoableAction.getAffectedDocuments(builder, new PsiFile[0]));
        this.myBuilder = builder;
        this.myClusters = clusters;
        this.myIsEnableFirst = isEnableFirst;
    }

    public void undo() {
        if (this.myIsEnableFirst) {
            this.dropClustering();
        } else {
            this.applyClustering();
        }
    }

    public void redo() {
        if (this.myIsEnableFirst) {
            this.applyClustering();
        } else {
            this.dropClustering();
        }
    }

    public void applyClustering() {
        Map clusterId2Nodes = this.myClusters.entrySet().stream().map(it -> Pair.create((Object)this.myBuilder.getNode((DiagramNode)it.getKey()), (Object)((NodeGroupDescriptor)it.getValue()))).filter(it -> it.getFirst() != null).collect(Collectors.groupingBy(it -> (NodeGroupDescriptor)it.getSecond(), Collectors.mapping(it -> (Node)it.getFirst(), Collectors.toList())));
        for (Map.Entry entry : clusterId2Nodes.entrySet()) {
            GraphGroupingService.getInstance().groupNodesExternally(this.myBuilder.getGraphBuilder(), (Collection)entry.getValue(), entry.getKey());
        }
        this.myBuilder.putUserData(CURRENT_CLUSTERING_KEY, this.myClusters);
        this.myBuilder.queryUpdate().withPresentationUpdate().withAllNodeSizeUpdate().run();
    }

    public void dropClustering() {
        for (NodeGroupDescriptor groupDescriptor : this.myClusters.values()) {
            GraphGroupingService.getInstance().ungroupNodesExternally(this.myBuilder.getGraphBuilder(), groupDescriptor);
        }
        this.myBuilder.putUserData(CURRENT_CLUSTERING_KEY, null);
        this.myBuilder.queryUpdate().withPresentationUpdate().run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "clusters";
                break;
            }
        }
        objectArray[1] = "com/intellij/uml/core/actions/analysis/DiagramAutoClusteringUndoableAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

