/*
 * Decompiled with CFR 0.152.
 */
package com.pestphp.pest.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.suggested.UtilsKt;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDivisionByZeroInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.pestphp.pest.PestBundle;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/pestphp/pest/inspections/PestAssertionCanBeSimplifiedInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "PestSimplifyAssertionQuickFix", "intellij.pest"})
public final class PestAssertionCanBeSimplifiedInspection
extends PhpInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpMethodReference(MethodReference reference) {
                block2: {
                    PsiElement mainParameter;
                    Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                    ASTNode aSTNode = reference.getNameNode();
                    if (aSTNode == null || (aSTNode = aSTNode.getPsi()) == null) {
                        return;
                    }
                    ASTNode methodNamePsi = aSTNode;
                    PsiElement psiElement = this.getMainParameterFromToBe(reference, (PsiElement)methodNamePsi);
                    if (psiElement != null) {
                        mainParameter = psiElement;
                        boolean bl = false;
                        this.registerProblem((PsiElement)methodNamePsi, mainParameter, "toBe" + StringUtil.capitalize((String)StringUtil.toLowerCase((String)mainParameter.getText())));
                    }
                    PsiElement psiElement2 = this.getMainParameterFromToHaveCount(reference, (PsiElement)methodNamePsi);
                    if (psiElement2 == null) break block2;
                    mainParameter = psiElement2;
                    boolean bl = false;
                    this.registerProblem((PsiElement)methodNamePsi, mainParameter, "toBeEmpty");
                }
            }

            private final PsiElement getMainParameterFromToBe(MethodReference reference, PsiElement methodNameIdentifier) {
                ParameterList parameterList = reference.getParameterList();
                if (parameterList == null || (parameterList = parameterList.getParameter("count", 0)) == null) {
                    return null;
                }
                ParameterList parameter = parameterList;
                if (PhpLangUtil.equalsMethodNames((CharSequence)methodNameIdentifier.getText(), (CharSequence)"toBe") && (PhpLangUtil.isTrue((PsiElement)parameter) || PhpLangUtil.isFalse((PsiElement)parameter) || PhpLangUtil.isNull((PsiElement)parameter))) {
                    return parameter;
                }
                return null;
            }

            private final PsiElement getMainParameterFromToHaveCount(MethodReference reference, PsiElement methodNameIdentifier) {
                ParameterList parameterList = reference.getParameterList();
                if (parameterList == null || (parameterList = parameterList.getParameter("expected", 0)) == null) {
                    return null;
                }
                ParameterList parameter = parameterList;
                if (PhpLangUtil.equalsMethodNames((CharSequence)methodNameIdentifier.getText(), (CharSequence)"toHaveCount") && PhpPsiUtil.isOfType((PsiElement)parameter, (IElementType)PhpElementTypes.NUMBER) && PhpDivisionByZeroInspection.isZero((PsiElement)parameter)) {
                    FunctionReference functionCall;
                    PhpExpression phpExpression = reference.getClassReference();
                    FunctionReference functionReference = functionCall = phpExpression instanceof FunctionReference ? (FunctionReference)phpExpression : null;
                    if (functionCall == null || functionCall.getParameters().length != 1) {
                        return null;
                    }
                    String functionName = functionCall.getName();
                    PsiElement[] psiElementArray = functionCall.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getParameters(...)");
                    PsiElement functionParameter = (PsiElement)ArraysKt.first((Object[])psiElementArray);
                    if (Intrinsics.areEqual((Object)functionName, (Object)"expect") && functionParameter instanceof PhpTypedElement && PhpType.isArray((PhpType)((PhpTypedElement)functionParameter).getGlobalType())) {
                        return parameter;
                    }
                }
                return null;
            }

            private final void registerProblem(PsiElement methodNamePsi, PsiElement parameterToRemove, String newMethodName) {
                Object[] objectArray = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)methodNamePsi.getText(), (String)"getText(...)");
                objectArray[1] = newMethodName;
                this.$holder.problem(methodNamePsi, PestBundle.message("INSPECTION_ASSERTION_CAN_BE_SIMPLIFIED", objectArray)).fix((ModCommandAction)new PestSimplifyAssertionQuickFix(newMethodName, methodNamePsi, parameterToRemove)).register();
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\r\u001a\u00070\u0004\u00a2\u0006\u0002\b\u000eH\u0016J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0094\u0002J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00020\u00020\n\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/pestphp/pest/inspections/PestAssertionCanBeSimplifiedInspection$PestSimplifyAssertionQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lcom/intellij/psi/PsiElement;", "newMethodName", "", "methodNamePsi", "parameterToRemove", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "parameterToRemovePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "insertIntoMethodReference", "Lcom/jetbrains/php/lang/psi/elements/MethodReference;", "methodReference", "insertionRange", "Lcom/intellij/openapi/util/TextRange;", "insertionText", "project", "Lcom/intellij/openapi/project/Project;", "intellij.pest"})
    private static final class PestSimplifyAssertionQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        @NotNull
        private final String newMethodName;
        @NotNull
        private final SmartPsiElementPointer<PsiElement> parameterToRemovePointer;

        public PestSimplifyAssertionQuickFix(@NotNull String newMethodName, @NotNull PsiElement methodNamePsi, @NotNull PsiElement parameterToRemove) {
            Intrinsics.checkNotNullParameter((Object)newMethodName, (String)"newMethodName");
            Intrinsics.checkNotNullParameter((Object)methodNamePsi, (String)"methodNamePsi");
            Intrinsics.checkNotNullParameter((Object)parameterToRemove, (String)"parameterToRemove");
            super(methodNamePsi);
            this.newMethodName = newMethodName;
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)parameterToRemove.getProject()).createSmartPsiElementPointer(parameterToRemove);
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
            this.parameterToRemovePointer = smartPsiElementPointer;
        }

        @NotNull
        public String getFamilyName() {
            return PestBundle.message("QUICK_FIX_SIMPLIFY_ASSERTION", new Object[0]);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement methodNamePsi, @NotNull ModPsiUpdater updater) {
            MethodReference methodReference;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)methodNamePsi, (String)"methodNamePsi");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            PsiElement psiElement = updater.getWritable(this.parameterToRemovePointer.getElement());
            if (psiElement == null) {
                return;
            }
            PsiElement parameterToRemove = psiElement;
            PsiElement psiElement2 = methodNamePsi.getParent();
            MethodReference methodReference2 = methodReference = psiElement2 instanceof MethodReference ? (MethodReference)psiElement2 : null;
            if (methodReference == null) {
                return;
            }
            ParameterList parameterList = new ParameterList[]{PhpTokenTypes.chRPAREN};
            PsiElement psiElement3 = PhpPsiUtil.findNextSiblingOfAnyType((PsiElement)methodNamePsi, (IElementType[])parameterList);
            if (psiElement3 == null) {
                return;
            }
            PsiElement methodEnd = psiElement3;
            parameterList = methodReference.getParameterList();
            ParameterListImpl parameterListImpl = parameterList instanceof ParameterListImpl ? (ParameterListImpl)parameterList : null;
            if (parameterListImpl != null) {
                parameterListImpl.removeParameter(parameterToRemove);
            }
            ParameterList parameterList2 = methodReference.getParameterList();
            String newMethodCallText = this.newMethodName + "(" + (parameterList2 != null ? parameterList2.getText() : null) + ")";
            TextRange textRange = new TextRange(UtilsKt.getStartOffset((PsiElement)methodNamePsi), UtilsKt.getEndOffset((PsiElement)methodEnd));
            Project project = context.project();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
            MethodReference newMethodReference = this.insertIntoMethodReference(methodReference, textRange, newMethodCallText, project);
            methodReference.replace((PsiElement)newMethodReference);
        }

        private final MethodReference insertIntoMethodReference(MethodReference methodReference, TextRange insertionRange, String insertionText, Project project) {
            TextRange referenceRange = methodReference.getTextRange();
            String referenceText = methodReference.getText();
            int referenceRelativeStart = insertionRange.getStartOffset() - referenceRange.getStartOffset();
            int referenceRelativeEnd = insertionRange.getEndOffset() - referenceRange.getStartOffset();
            Intrinsics.checkNotNull((Object)referenceText);
            String string = referenceText.substring(0, referenceRelativeStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = referenceText.substring(referenceRelativeEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String newMethodReferenceText = string + insertionText + string2;
            MethodReference methodReference2 = PhpPsiElementFactory.createMethodReference((Project)project, (String)newMethodReferenceText);
            Intrinsics.checkNotNullExpressionValue((Object)methodReference2, (String)"createMethodReference(...)");
            return methodReference2;
        }
    }
}

